/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.pattern;

import com.icl.saxon.Context;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.Pattern;
import java.util.StringTokenizer;

public final class IDPattern
extends Pattern {
    private String id;
    private boolean containsSpaces;

    public IDPattern(String string) {
        this.id = string;
        this.containsSpaces = this.id.indexOf(32) >= 0 || this.id.indexOf(9) >= 0 || this.id.indexOf(10) >= 0 || this.id.indexOf(12) >= 0;
    }

    public boolean matches(NodeInfo nodeInfo, Context context) throws XPathException {
        if (nodeInfo.getNodeType() != 1) {
            return false;
        }
        DocumentInfo documentInfo = nodeInfo.getDocumentRoot();
        if (!this.containsSpaces) {
            NodeInfo nodeInfo2 = documentInfo.selectID(this.id);
            if (nodeInfo2 == null) {
                return false;
            }
            return nodeInfo2.isSameNode(nodeInfo);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.id);
        while (stringTokenizer.hasMoreElements()) {
            String string = (String)stringTokenizer.nextElement();
            NodeInfo nodeInfo3 = documentInfo.selectID(string);
            if (nodeInfo3 == null || !nodeInfo.isSameNode(nodeInfo3)) continue;
            return true;
        }
        return false;
    }

    public short getNodeType() {
        return 1;
    }
}

