/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype;

import org.apache.avalon.framework.CascadingException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.forms.datatype.Datatype;
import org.apache.cocoon.forms.datatype.DatatypeBuilder;
import org.apache.cocoon.forms.datatype.DatatypeManager;
import org.apache.cocoon.forms.datatype.ValidationRule;
import org.apache.cocoon.forms.datatype.ValidationRuleBuilder;
import org.apache.cocoon.forms.datatype.convertor.Convertor;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.cocoon.forms.util.SimpleServiceSelector;
import org.w3c.dom.Element;

public class DefaultDatatypeManager
extends AbstractLogEnabled
implements DatatypeManager,
ThreadSafe,
Serviceable,
Configurable,
Initializable,
Disposable,
Contextualizable {
    private SimpleServiceSelector typeBuilderSelector;
    private SimpleServiceSelector validationRuleBuilderSelector;
    private ServiceManager serviceManager;
    private Configuration configuration;
    private Context context;
    static /* synthetic */ Class class$org$apache$cocoon$forms$datatype$DatatypeBuilder;
    static /* synthetic */ Class class$org$apache$cocoon$forms$datatype$ValidationRuleBuilder;

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = configuration;
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.serviceManager = serviceManager;
    }

    public void initialize() throws Exception {
        this.typeBuilderSelector = new SimpleServiceSelector("datatype", class$org$apache$cocoon$forms$datatype$DatatypeBuilder == null ? (class$org$apache$cocoon$forms$datatype$DatatypeBuilder = DefaultDatatypeManager.class$("org.apache.cocoon.forms.datatype.DatatypeBuilder")) : class$org$apache$cocoon$forms$datatype$DatatypeBuilder);
        this.typeBuilderSelector.enableLogging(this.getLogger());
        this.typeBuilderSelector.contextualize(this.context);
        this.typeBuilderSelector.service(this.serviceManager);
        this.typeBuilderSelector.configure(this.configuration.getChild("datatypes"));
        this.validationRuleBuilderSelector = new SimpleServiceSelector("validation-rule", class$org$apache$cocoon$forms$datatype$ValidationRuleBuilder == null ? (class$org$apache$cocoon$forms$datatype$ValidationRuleBuilder = DefaultDatatypeManager.class$("org.apache.cocoon.forms.datatype.ValidationRuleBuilder")) : class$org$apache$cocoon$forms$datatype$ValidationRuleBuilder);
        this.validationRuleBuilderSelector.enableLogging(this.getLogger());
        this.validationRuleBuilderSelector.contextualize(this.context);
        this.validationRuleBuilderSelector.service(this.serviceManager);
        this.validationRuleBuilderSelector.configure(this.configuration.getChild("validation-rules"));
        this.configuration = null;
    }

    public Datatype createDatatype(Element datatypeElement, boolean arrayType) throws Exception {
        String typeName = DomHelper.getAttribute(datatypeElement, "base");
        DatatypeBuilder builder = null;
        try {
            builder = (DatatypeBuilder)this.typeBuilderSelector.select(typeName);
        }
        catch (ServiceException e) {
            throw new CascadingException("Unknown datatype '" + typeName + "' specified at " + DomHelper.getLocation(datatypeElement), (Throwable)e);
        }
        return builder.build(datatypeElement, arrayType, this);
    }

    public ValidationRule createValidationRule(Element validationRuleElement) throws Exception {
        String name = validationRuleElement.getLocalName();
        ValidationRuleBuilder builder = null;
        try {
            builder = (ValidationRuleBuilder)this.validationRuleBuilderSelector.select(name);
        }
        catch (ServiceException e) {
            throw new CascadingException("Unknown validation rule \"" + name + "\" specified at " + DomHelper.getLocation(validationRuleElement), (Throwable)e);
        }
        return builder.build(validationRuleElement);
    }

    public Convertor createConvertor(String dataTypeName, Element convertorElement) throws Exception {
        DatatypeBuilder datatypeBulder = (DatatypeBuilder)this.typeBuilderSelector.select(dataTypeName);
        return datatypeBulder.buildConvertor(convertorElement);
    }

    public void dispose() {
        this.typeBuilderSelector.dispose();
        this.validationRuleBuilderSelector.dispose();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

