/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.transformation;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.cocoon.forms.formmodel.AggregateField;
import org.apache.cocoon.forms.formmodel.ContainerWidget;
import org.apache.cocoon.forms.formmodel.Repeater;
import org.apache.cocoon.forms.formmodel.Struct;
import org.apache.cocoon.forms.formmodel.Union;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.transformation.EffectPipe;
import org.apache.cocoon.forms.transformation.FormsPipelineConfig;
import org.apache.cocoon.forms.validation.ValidationError;
import org.apache.cocoon.forms.validation.ValidationErrorAware;
import org.apache.cocoon.i18n.I18nUtils;
import org.apache.cocoon.xml.AbstractXMLPipe;
import org.apache.cocoon.xml.SaxBuffer;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.jxpath.JXPathException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class EffectWidgetReplacingPipe
extends EffectPipe {
    private static final String LOCATION = "location";
    private static final String CLASS = "class";
    private static final String CONTINUATION_ID = "continuation-id";
    private static final String FORM_TEMPLATE_EL = "form-template";
    private static final String NEW = "new";
    private static final String REPEATER_SIZE = "repeater-size";
    private static final String REPEATER_WIDGET = "repeater-widget";
    private static final String REPEATER_WIDGET_LABEL = "repeater-widget-label";
    private static final String AGGREGATE_WIDGET = "aggregate-widget";
    private static final String STRUCT = "struct";
    private static final String STYLING_EL = "styling";
    private static final String UNION = "union";
    private static final String VALIDATION_ERROR = "validation-error";
    private static final String WIDGET_LABEL = "widget-label";
    private static final String WIDGET = "widget";
    protected Widget contextWidget;
    protected LinkedList contextWidgets;
    protected String widgetId;
    protected Widget widget;
    protected Map classes;
    private final DocHandler docHandler = new DocHandler();
    private final FormHandler formHandler = new FormHandler();
    private final NestedHandler nestedHandler = new NestedHandler();
    private final WidgetLabelHandler widgetLabelHandler = new WidgetLabelHandler();
    private final WidgetHandler widgetHandler = new WidgetHandler();
    private final RepeaterSizeHandler repeaterSizeHandler = new RepeaterSizeHandler();
    private final RepeaterWidgetLabelHandler repeaterWidgetLabelHandler = new RepeaterWidgetLabelHandler();
    private final RepeaterWidgetHandler repeaterWidgetHandler = new RepeaterWidgetHandler();
    private final AggregateWidgetHandler aggregateWidgetHandler = new AggregateWidgetHandler();
    private final StructHandler structHandler = new StructHandler();
    private final UnionHandler unionHandler = new UnionHandler();
    private final UnionPassThruHandler unionPassThruHandler = new UnionPassThruHandler();
    private final NewHandler newHandler = new NewHandler();
    private final ClassHandler classHandler = new ClassHandler();
    private final ContinuationIdHandler continuationIdHandler = new ContinuationIdHandler();
    private final StylingContentHandler stylingHandler = new StylingContentHandler();
    private final ValidationErrorHandler validationErrorHandler = new ValidationErrorHandler();
    private final Map templates = new HashMap(12, 1.0f);
    protected FormsPipelineConfig pipeContext;
    protected boolean gotStylingElement;
    protected String namespacePrefix;

    public EffectWidgetReplacingPipe() {
        this.templates.put(WIDGET, this.widgetHandler);
        this.templates.put(WIDGET_LABEL, this.widgetLabelHandler);
        this.templates.put(REPEATER_WIDGET, this.repeaterWidgetHandler);
        this.templates.put(AGGREGATE_WIDGET, this.aggregateWidgetHandler);
        this.templates.put(REPEATER_SIZE, this.repeaterSizeHandler);
        this.templates.put(REPEATER_WIDGET_LABEL, this.repeaterWidgetLabelHandler);
        this.templates.put(STRUCT, this.structHandler);
        this.templates.put(UNION, this.unionHandler);
        this.templates.put(NEW, this.newHandler);
        this.templates.put(CLASS, this.classHandler);
        this.templates.put(CONTINUATION_ID, this.continuationIdHandler);
        this.templates.put(VALIDATION_ERROR, this.validationErrorHandler);
    }

    private void throwSAXException(String message) throws SAXException {
        throw new SAXException("EffectFormTemplateTransformer: " + message);
    }

    public void init(Widget contextWidget, FormsPipelineConfig pipeContext) {
        super.init();
        this.pipeContext = pipeContext;
        this.handler = this.docHandler;
        this.contextWidgets = new LinkedList();
        this.classes = new HashMap();
    }

    protected String getWidgetId(Attributes attributes) throws SAXException {
        String widgetId = attributes.getValue("id");
        if (widgetId == null || widgetId.equals("")) {
            this.throwSAXException("Missing required widget \"id\" attribute.");
        }
        return widgetId;
    }

    protected Widget getWidget(String widgetId) throws SAXException {
        Widget widget = ((ContainerWidget)this.contextWidget).getChild(widgetId);
        if (widget == null) {
            if (this.contextWidget.getRequestParameterName().equals("")) {
                this.throwSAXException("Widget with id \"" + widgetId + "\" does not exist in the form container.");
            } else {
                this.throwSAXException("Widget with id \"" + widgetId + "\" does not exist in the container \"" + this.contextWidget.getRequestParameterName() + "\"");
            }
        }
        return widget;
    }

    protected void getRepeaterWidget(String handler) throws SAXException {
        this.widgetId = this.getWidgetId(this.input.attrs);
        this.widget = this.getWidget(this.widgetId);
        if (!(this.widget instanceof Repeater)) {
            this.throwWrongWidgetType("RepeaterWidgetLabelHandler", this.input.loc, "repeater");
        }
    }

    public void throwWrongWidgetType(String pipeName, String element, String widget) throws SAXException {
        this.throwSAXException(pipeName + ": Element \"" + element + "\" can only be used for " + widget + " widgets.");
    }

    private ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    private LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public EffectPipe.Handler nestedTemplate() throws SAXException {
        if ("http://apache.org/cocoon/forms/1.0#template".equals(this.input.uri)) {
            EffectPipe.Handler handler = (EffectPipe.Handler)this.templates.get(this.input.loc);
            if (handler != null) {
                return handler;
            }
            if (FORM_TEMPLATE_EL.equals(this.input.loc)) {
                this.throwSAXException("Element \"form-template\" must not be nested.");
                return null;
            }
            this.throwSAXException("Unrecognized template: " + this.input.loc);
            return null;
        }
        return this.nestedHandler;
    }

    private Attributes translateAttributes(Attributes attributes, String[] names) {
        AttributesImpl newAtts = new AttributesImpl(attributes);
        if (names != null) {
            int i = 0;
            while (i < names.length) {
                String name = names[i];
                int position = newAtts.getIndex(name);
                String newValue = this.pipeContext.translateText(newAtts.getValue(position));
                newAtts.setValue(position, newValue);
                ++i;
            }
        }
        return newAtts;
    }

    public void recycle() {
        super.recycle();
        this.contextWidget = null;
        this.widget = null;
        this.widgetId = null;
        this.namespacePrefix = null;
    }

    protected class ValidationErrorHandler
    extends EffectPipe.Handler {
        protected ValidationErrorHandler() {
        }

        public EffectPipe.Handler process() throws SAXException {
            switch (EffectWidgetReplacingPipe.this.event) {
                case 5: {
                    EffectWidgetReplacingPipe.this.widgetId = EffectWidgetReplacingPipe.this.getWidgetId(EffectWidgetReplacingPipe.this.input.attrs);
                    EffectWidgetReplacingPipe.this.widget = EffectWidgetReplacingPipe.this.getWidget(EffectWidgetReplacingPipe.this.widgetId);
                    EffectWidgetReplacingPipe.this.out.bufferInit();
                    return this;
                }
                case 7: {
                    return EffectWidgetReplacingPipe.this.bufferHandler;
                }
                case 6: {
                    ValidationError error;
                    if (EffectWidgetReplacingPipe.this.widget instanceof ValidationErrorAware && (error = ((ValidationErrorAware)((Object)EffectWidgetReplacingPipe.this.widget)).getValidationError()) != null) {
                        EffectWidgetReplacingPipe.this.out.startElement("http://apache.org/cocoon/forms/1.0#instance", EffectWidgetReplacingPipe.VALIDATION_ERROR, "fi:validation-error", (Attributes)XMLUtils.EMPTY_ATTRIBUTES);
                        error.generateSaxFragment((ContentHandler)((Object)EffectWidgetReplacingPipe.this.stylingHandler));
                        EffectWidgetReplacingPipe.this.out.endElement("http://apache.org/cocoon/forms/1.0#instance", EffectWidgetReplacingPipe.VALIDATION_ERROR, "fi:validation-error");
                    }
                    EffectWidgetReplacingPipe.this.widget = null;
                    EffectWidgetReplacingPipe.this.out.bufferFini();
                    return this;
                }
            }
            EffectWidgetReplacingPipe.this.out.copy();
            return this;
        }
    }

    protected class StylingContentHandler
    extends AbstractXMLPipe
    implements Recyclable {
        private int elementNesting;
        private SaxBuffer saxBuffer;

        protected StylingContentHandler() {
        }

        public void setSaxFragment(SaxBuffer saxFragment) {
            this.saxBuffer = saxFragment;
        }

        public void recycle() {
            super.recycle();
            this.elementNesting = 0;
            this.saxBuffer = null;
        }

        public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
            ++this.elementNesting;
            super.startElement(uri, loc, raw, a);
        }

        public void endElement(String uri, String loc, String raw) throws SAXException {
            --this.elementNesting;
            if (this.elementNesting == 0 && this.saxBuffer != null) {
                if (EffectWidgetReplacingPipe.this.gotStylingElement) {
                    this.saxBuffer.toSAX(EffectWidgetReplacingPipe.this.getContentHandler());
                } else {
                    EffectWidgetReplacingPipe.this.out.startElement("http://apache.org/cocoon/forms/1.0#instance", EffectWidgetReplacingPipe.STYLING_EL, "fi:styling", (Attributes)XMLUtils.EMPTY_ATTRIBUTES);
                    this.saxBuffer.toSAX(EffectWidgetReplacingPipe.this.getContentHandler());
                    EffectWidgetReplacingPipe.this.out.endElement("http://apache.org/cocoon/forms/1.0#instance", EffectWidgetReplacingPipe.STYLING_EL, "fi:styling");
                }
            }
            super.endElement(uri, loc, raw);
        }
    }

    protected class ContinuationIdHandler
    extends EffectPipe.Handler {
        protected ContinuationIdHandler() {
        }

        public EffectPipe.Handler process() throws SAXException {
            switch (EffectWidgetReplacingPipe.this.event) {
                case 5: {
                    Object idObj = EffectWidgetReplacingPipe.this.pipeContext.evaluateExpression("$continuation/id");
                    if (idObj == null) {
                        EffectWidgetReplacingPipe.this.throwSAXException("No continuation found");
                    }
                    String id = idObj.toString();
                    EffectWidgetReplacingPipe.this.out.element("fi", "http://apache.org/cocoon/forms/1.0#instance", EffectWidgetReplacingPipe.CONTINUATION_ID, EffectWidgetReplacingPipe.this.input.attrs);
                    EffectWidgetReplacingPipe.this.out.startElement();
                    EffectWidgetReplacingPipe.this.out.characters(id.toCharArray(), 0, id.length());
                    EffectWidgetReplacingPipe.this.out.endElement();
                    return this;
                }
                case 6: {
                    return this;
                }
                case 9: {
                    return this;
                }
            }
            EffectWidgetReplacingPipe.this.throwSAXException("ContinuationIdHandler: No content allowed in \"continuation-id\" element");
            return null;
        }
    }

    protected class ClassHandler
    extends EffectPipe.Handler {
        protected ClassHandler() {
        }

        public EffectPipe.Handler process() throws SAXException {
            switch (EffectWidgetReplacingPipe.this.event) {
                case 5: {
                    EffectWidgetReplacingPipe.this.widgetId = EffectWidgetReplacingPipe.this.getWidgetId(EffectWidgetReplacingPipe.this.input.attrs);
                    EffectWidgetReplacingPipe.this.out.bufferInit();
                    return this;
                }
                case 7: {
                    return EffectWidgetReplacingPipe.this.bufferHandler;
                }
                case 6: {
                    EffectWidgetReplacingPipe.this.classes.put(EffectWidgetReplacingPipe.this.widgetId, EffectWidgetReplacingPipe.this.out.getBuffer());
                    EffectWidgetReplacingPipe.this.out.bufferFini();
                    return this;
                }
            }
            EffectWidgetReplacingPipe.this.out.buffer();
            return this;
        }
    }

    protected class NewHandler
    extends EffectPipe.Handler {
        protected NewHandler() {
        }

        public EffectPipe.Handler process() throws SAXException {
            switch (EffectWidgetReplacingPipe.this.event) {
                case 5: {
                    EffectWidgetReplacingPipe.this.widgetId = EffectWidgetReplacingPipe.this.getWidgetId(EffectWidgetReplacingPipe.this.input.attrs);
                    SaxBuffer classBuffer = (SaxBuffer)EffectWidgetReplacingPipe.this.classes.get(EffectWidgetReplacingPipe.this.widgetId);
                    if (classBuffer == null) {
                        EffectWidgetReplacingPipe.this.throwSAXException("New: Class \"" + EffectWidgetReplacingPipe.this.widgetId + "\" does not exist.");
                    }
                    EffectWidgetReplacingPipe.this.handlers.addFirst(EffectWidgetReplacingPipe.this.handler);
                    EffectWidgetReplacingPipe.this.handler = EffectWidgetReplacingPipe.this.nestedHandler;
                    classBuffer.toSAX((ContentHandler)((Object)EffectWidgetReplacingPipe.this));
                    EffectWidgetReplacingPipe.this.handler = (EffectPipe.Handler)EffectWidgetReplacingPipe.this.handlers.removeFirst();
                    return this;
                }
                case 7: {
                    return EffectWidgetReplacingPipe.this.nullHandler;
                }
                case 6: {
                    return this;
                }
            }
            EffectWidgetReplacingPipe.this.out.copy();
            return this;
        }
    }

    protected class UnionPassThruHandler
    extends EffectPipe.Handler {
        protected UnionPassThruHandler() {
        }

        public EffectPipe.Handler process() throws SAXException {
            switch (EffectWidgetReplacingPipe.this.event) {
                case 7: {
                    if ("http://apache.org/cocoon/forms/1.0#template".equals(EffectWidgetReplacingPipe.this.input.uri)) {
                        if ("case".equals(EffectWidgetReplacingPipe.this.input.loc)) {
                            if (EffectWidgetReplacingPipe.this.contextWidget.getValue().equals(EffectWidgetReplacingPipe.this.input.attrs.getValue("id"))) {
                                return EffectWidgetReplacingPipe.this.nestedHandler;
                            }
                            return EffectWidgetReplacingPipe.this.nullHandler;
                        }
                        if (EffectWidgetReplacingPipe.FORM_TEMPLATE_EL.equals(EffectWidgetReplacingPipe.this.input.loc)) {
                            EffectWidgetReplacingPipe.this.throwSAXException("Element \"form-template\" must not be nested.");
                            break;
                        }
                        EffectWidgetReplacingPipe.this.throwSAXException("Unrecognized template: " + EffectWidgetReplacingPipe.this.input.loc);
                        break;
                    }
                    return this;
                }
            }
            EffectWidgetReplacingPipe.this.out.copy();
            return this;
        }
    }

    protected class UnionHandler
    extends EffectPipe.Handler {
        protected UnionHandler() {
        }

        public EffectPipe.Handler process() throws SAXException {
            switch (EffectWidgetReplacingPipe.this.event) {
                case 5: {
                    EffectWidgetReplacingPipe.this.widgetId = EffectWidgetReplacingPipe.this.getWidgetId(EffectWidgetReplacingPipe.this.input.attrs);
                    EffectWidgetReplacingPipe.this.widget = EffectWidgetReplacingPipe.this.getWidget(EffectWidgetReplacingPipe.this.widgetId);
                    if (!(EffectWidgetReplacingPipe.this.widget instanceof Union)) {
                        EffectWidgetReplacingPipe.this.throwWrongWidgetType("UnionHandler", EffectWidgetReplacingPipe.this.input.loc, EffectWidgetReplacingPipe.UNION);
                    }
                    EffectWidgetReplacingPipe.this.contextWidgets.addFirst(EffectWidgetReplacingPipe.this.contextWidget);
                    EffectWidgetReplacingPipe.this.contextWidget = EffectWidgetReplacingPipe.this.widget;
                    EffectWidgetReplacingPipe.this.out.element("fi", "http://apache.org/cocoon/forms/1.0#instance", EffectWidgetReplacingPipe.UNION);
                    EffectWidgetReplacingPipe.this.out.startElement();
                    return this;
                }
                case 7: {
                    if ("http://apache.org/cocoon/forms/1.0#template".equals(EffectWidgetReplacingPipe.this.input.uri)) {
                        if ("case".equals(EffectWidgetReplacingPipe.this.input.loc)) {
                            String value;
                            String id = EffectWidgetReplacingPipe.this.input.attrs.getValue("id");
                            if (id == null) {
                                EffectWidgetReplacingPipe.this.throwSAXException("Element \"case\" missing required \"id\" attribute.");
                            }
                            if (id.equals((value = (String)EffectWidgetReplacingPipe.this.contextWidget.getValue()) != null ? value : "")) {
                                return EffectWidgetReplacingPipe.this.nestedHandler;
                            }
                            return EffectWidgetReplacingPipe.this.nullHandler;
                        }
                        if (EffectWidgetReplacingPipe.FORM_TEMPLATE_EL.equals(EffectWidgetReplacingPipe.this.input.loc)) {
                            EffectWidgetReplacingPipe.this.throwSAXException("Element \"form-template\" must not be nested.");
                        } else {
                            EffectWidgetReplacingPipe.this.throwSAXException("Unrecognized template: " + EffectWidgetReplacingPipe.this.input.loc);
                        }
                    } else {
                        return EffectWidgetReplacingPipe.this.unionPassThruHandler;
                    }
                }
                case 6: {
                    EffectWidgetReplacingPipe.this.out.endElement();
                    EffectWidgetReplacingPipe.this.contextWidget = (Widget)EffectWidgetReplacingPipe.this.contextWidgets.removeFirst();
                    return this;
                }
            }
            EffectWidgetReplacingPipe.this.out.copy();
            return this;
        }
    }

    protected class StructHandler
    extends EffectPipe.Handler {
        protected StructHandler() {
        }

        public EffectPipe.Handler process() throws SAXException {
            switch (EffectWidgetReplacingPipe.this.event) {
                case 5: {
                    EffectWidgetReplacingPipe.this.widgetId = EffectWidgetReplacingPipe.this.getWidgetId(EffectWidgetReplacingPipe.this.input.attrs);
                    EffectWidgetReplacingPipe.this.widget = EffectWidgetReplacingPipe.this.getWidget(EffectWidgetReplacingPipe.this.widgetId);
                    if (!(EffectWidgetReplacingPipe.this.widget instanceof Struct)) {
                        EffectWidgetReplacingPipe.this.throwWrongWidgetType("StructHandler", EffectWidgetReplacingPipe.this.input.loc, EffectWidgetReplacingPipe.STRUCT);
                    }
                    EffectWidgetReplacingPipe.this.contextWidgets.addFirst(EffectWidgetReplacingPipe.this.contextWidget);
                    EffectWidgetReplacingPipe.this.contextWidget = EffectWidgetReplacingPipe.this.widget;
                    EffectWidgetReplacingPipe.this.out.element("fi", "http://apache.org/cocoon/forms/1.0#instance", EffectWidgetReplacingPipe.STRUCT);
                    EffectWidgetReplacingPipe.this.out.attributes();
                    EffectWidgetReplacingPipe.this.out.startElement();
                    return this;
                }
                case 7: {
                    return EffectWidgetReplacingPipe.this.nestedTemplate();
                }
                case 6: {
                    EffectWidgetReplacingPipe.this.out.copy();
                    EffectWidgetReplacingPipe.this.contextWidget = (Widget)EffectWidgetReplacingPipe.this.contextWidgets.removeFirst();
                    return this;
                }
            }
            EffectWidgetReplacingPipe.this.out.copy();
            return this;
        }
    }

    protected class AggregateWidgetHandler
    extends EffectPipe.Handler {
        protected AggregateWidgetHandler() {
        }

        public EffectPipe.Handler process() throws SAXException {
            switch (EffectWidgetReplacingPipe.this.event) {
                case 5: {
                    EffectWidgetReplacingPipe.this.widgetId = EffectWidgetReplacingPipe.this.getWidgetId(EffectWidgetReplacingPipe.this.input.attrs);
                    EffectWidgetReplacingPipe.this.widget = EffectWidgetReplacingPipe.this.getWidget(EffectWidgetReplacingPipe.this.widgetId);
                    if (!(EffectWidgetReplacingPipe.this.widget instanceof AggregateField)) {
                        EffectWidgetReplacingPipe.this.throwWrongWidgetType("AggregateWidgetHandler", EffectWidgetReplacingPipe.this.input.loc, "aggregate");
                    }
                    EffectWidgetReplacingPipe.this.contextWidgets.addFirst(EffectWidgetReplacingPipe.this.contextWidget);
                    EffectWidgetReplacingPipe.this.contextWidget = EffectWidgetReplacingPipe.this.widget;
                    return this;
                }
                case 7: {
                    return EffectWidgetReplacingPipe.this.nestedTemplate();
                }
                case 6: {
                    EffectWidgetReplacingPipe.this.contextWidget = (Widget)EffectWidgetReplacingPipe.this.contextWidgets.removeFirst();
                    return this;
                }
            }
            EffectWidgetReplacingPipe.this.out.copy();
            return this;
        }
    }

    protected class RepeaterWidgetHandler
    extends EffectPipe.Handler {
        protected RepeaterWidgetHandler() {
        }

        public EffectPipe.Handler process() throws SAXException {
            switch (EffectWidgetReplacingPipe.this.event) {
                case 5: {
                    EffectWidgetReplacingPipe.this.getRepeaterWidget("RepeaterWidgetHandler");
                    EffectWidgetReplacingPipe.this.out.bufferInit();
                    return this;
                }
                case 7: {
                    return EffectWidgetReplacingPipe.this.bufferHandler;
                }
                case 6: {
                    Repeater repeater = (Repeater)EffectWidgetReplacingPipe.this.widget;
                    int rowCount = repeater.getSize();
                    EffectWidgetReplacingPipe.this.handlers.addFirst(EffectWidgetReplacingPipe.this.handler);
                    EffectWidgetReplacingPipe.this.handler = EffectWidgetReplacingPipe.this.nestedHandler;
                    EffectWidgetReplacingPipe.this.contextWidgets.addFirst(EffectWidgetReplacingPipe.this.contextWidget);
                    int i = 0;
                    while (i < rowCount) {
                        Repeater.RepeaterRow row = repeater.getRow(i);
                        EffectWidgetReplacingPipe.this.contextWidget = row;
                        EffectWidgetReplacingPipe.this.out.getBuffer().toSAX((ContentHandler)((Object)EffectWidgetReplacingPipe.this));
                        ++i;
                    }
                    EffectWidgetReplacingPipe.this.contextWidget = (Widget)EffectWidgetReplacingPipe.this.contextWidgets.removeFirst();
                    EffectWidgetReplacingPipe.this.handler = (EffectPipe.Handler)EffectWidgetReplacingPipe.this.handlers.removeFirst();
                    EffectWidgetReplacingPipe.this.widget = null;
                    EffectWidgetReplacingPipe.this.out.bufferFini();
                    return this;
                }
            }
            EffectWidgetReplacingPipe.this.out.buffer();
            return this;
        }
    }

    protected class RepeaterWidgetLabelHandler
    extends EffectPipe.Handler {
        protected RepeaterWidgetLabelHandler() {
        }

        public EffectPipe.Handler process() throws SAXException {
            switch (EffectWidgetReplacingPipe.this.event) {
                case 5: {
                    EffectWidgetReplacingPipe.this.getRepeaterWidget("RepeaterWidgetLabelHandler");
                    String widgetId = EffectWidgetReplacingPipe.this.input.attrs.getValue("widget-id");
                    if (widgetId == null || widgetId.equals("")) {
                        EffectWidgetReplacingPipe.this.throwSAXException("Element repeater-widget-label missing required widget-id attribute.");
                    }
                    ((Repeater)EffectWidgetReplacingPipe.this.widget).generateWidgetLabel(widgetId, EffectWidgetReplacingPipe.this.getContentHandler());
                    EffectWidgetReplacingPipe.this.widget = null;
                    return this;
                }
                case 7: {
                    return EffectWidgetReplacingPipe.this.nullHandler;
                }
                case 6: {
                    return this;
                }
            }
            EffectWidgetReplacingPipe.this.out.copy();
            return this;
        }
    }

    protected class RepeaterSizeHandler
    extends EffectPipe.Handler {
        protected RepeaterSizeHandler() {
        }

        public EffectPipe.Handler process() throws SAXException {
            switch (EffectWidgetReplacingPipe.this.event) {
                case 5: {
                    EffectWidgetReplacingPipe.this.getRepeaterWidget("RepeaterSizeHandler");
                    ((Repeater)EffectWidgetReplacingPipe.this.widget).generateSize(EffectWidgetReplacingPipe.this.getContentHandler());
                    EffectWidgetReplacingPipe.this.widget = null;
                    return this;
                }
                case 7: {
                    return EffectWidgetReplacingPipe.this.nullHandler;
                }
                case 6: {
                    return this;
                }
            }
            EffectWidgetReplacingPipe.this.out.copy();
            return this;
        }
    }

    protected class WidgetHandler
    extends EffectPipe.Handler {
        protected WidgetHandler() {
        }

        public EffectPipe.Handler process() throws SAXException {
            switch (EffectWidgetReplacingPipe.this.event) {
                case 5: {
                    EffectWidgetReplacingPipe.this.widgetId = EffectWidgetReplacingPipe.this.getWidgetId(EffectWidgetReplacingPipe.this.input.attrs);
                    EffectWidgetReplacingPipe.this.widget = EffectWidgetReplacingPipe.this.getWidget(EffectWidgetReplacingPipe.this.widgetId);
                    EffectWidgetReplacingPipe.this.gotStylingElement = false;
                    EffectWidgetReplacingPipe.this.out.bufferInit();
                    return this;
                }
                case 7: {
                    if ("http://apache.org/cocoon/forms/1.0#instance".equals(EffectWidgetReplacingPipe.this.input.uri) && EffectWidgetReplacingPipe.STYLING_EL.equals(EffectWidgetReplacingPipe.this.input.loc)) {
                        EffectWidgetReplacingPipe.this.gotStylingElement = true;
                    }
                    return EffectWidgetReplacingPipe.this.bufferHandler;
                }
                case 6: {
                    EffectWidgetReplacingPipe.this.stylingHandler.recycle();
                    EffectWidgetReplacingPipe.this.stylingHandler.setSaxFragment(EffectWidgetReplacingPipe.this.out.getBuffer());
                    EffectWidgetReplacingPipe.this.stylingHandler.setContentHandler(EffectWidgetReplacingPipe.this.getContentHandler());
                    EffectWidgetReplacingPipe.this.stylingHandler.setLexicalHandler(EffectWidgetReplacingPipe.this.getLexicalHandler());
                    EffectWidgetReplacingPipe.this.widget.generateSaxFragment((ContentHandler)((Object)EffectWidgetReplacingPipe.this.stylingHandler), EffectWidgetReplacingPipe.this.pipeContext.getLocale());
                    EffectWidgetReplacingPipe.this.widget = null;
                    EffectWidgetReplacingPipe.this.out.bufferFini();
                    return this;
                }
            }
            EffectWidgetReplacingPipe.this.out.copy();
            return this;
        }
    }

    protected class WidgetLabelHandler
    extends EffectPipe.Handler {
        protected WidgetLabelHandler() {
        }

        public EffectPipe.Handler process() throws SAXException {
            switch (EffectWidgetReplacingPipe.this.event) {
                case 5: {
                    EffectWidgetReplacingPipe.this.widgetId = EffectWidgetReplacingPipe.this.getWidgetId(EffectWidgetReplacingPipe.this.input.attrs);
                    Widget widget = EffectWidgetReplacingPipe.this.getWidget(EffectWidgetReplacingPipe.this.widgetId);
                    widget.generateLabel(EffectWidgetReplacingPipe.this.getContentHandler());
                    widget = null;
                    return this;
                }
                case 7: {
                    return EffectWidgetReplacingPipe.this.nullHandler;
                }
                case 6: {
                    return this;
                }
            }
            EffectWidgetReplacingPipe.this.out.copy();
            return this;
        }
    }

    protected class NestedHandler
    extends EffectPipe.Handler {
        protected NestedHandler() {
        }

        public EffectPipe.Handler process() throws SAXException {
            switch (EffectWidgetReplacingPipe.this.event) {
                case 7: {
                    return EffectWidgetReplacingPipe.this.nestedTemplate();
                }
            }
            EffectWidgetReplacingPipe.this.out.copy();
            return this;
        }
    }

    protected class FormHandler
    extends EffectPipe.Handler {
        protected FormHandler() {
        }

        public EffectPipe.Handler process() throws SAXException {
            switch (EffectWidgetReplacingPipe.this.event) {
                case 5: {
                    if (EffectWidgetReplacingPipe.this.contextWidget != null) {
                        EffectWidgetReplacingPipe.this.throwSAXException("Detected nested wt:form-template elements, this is not allowed.");
                    }
                    EffectWidgetReplacingPipe.this.out.startPrefixMapping("fi", "http://apache.org/cocoon/forms/1.0#instance");
                    String formJXPath = EffectWidgetReplacingPipe.this.input.attrs.getValue(EffectWidgetReplacingPipe.LOCATION);
                    if (formJXPath != null) {
                        EffectWidgetReplacingPipe.this.input.removeAttribute(EffectWidgetReplacingPipe.LOCATION);
                    }
                    EffectWidgetReplacingPipe.this.contextWidget = EffectWidgetReplacingPipe.this.pipeContext.findForm(formJXPath);
                    String localeAttr = EffectWidgetReplacingPipe.this.input.attrs.getValue("locale");
                    if (localeAttr != null) {
                        localeAttr = EffectWidgetReplacingPipe.this.pipeContext.translateText(localeAttr);
                        EffectWidgetReplacingPipe.this.pipeContext.setLocale(I18nUtils.parseLocale((String)localeAttr));
                    } else if (EffectWidgetReplacingPipe.this.pipeContext.getLocaleParameter() != null) {
                        EffectWidgetReplacingPipe.this.pipeContext.setLocale(EffectWidgetReplacingPipe.this.pipeContext.getLocaleParameter());
                    } else {
                        Object locale = null;
                        try {
                            locale = EffectWidgetReplacingPipe.this.pipeContext.evaluateExpression("/locale");
                        }
                        catch (JXPathException e) {
                            // empty catch block
                        }
                        if (locale != null) {
                            EffectWidgetReplacingPipe.this.pipeContext.setLocale((Locale)locale);
                        } else {
                            EffectWidgetReplacingPipe.this.pipeContext.setLocale(Locale.getDefault());
                        }
                    }
                    EffectWidgetReplacingPipe.this.input.addAttributes(EffectWidgetReplacingPipe.this.pipeContext.getFormAttributes());
                    String[] namesToTranslate = new String[]{"action"};
                    Attributes transAttrs = EffectWidgetReplacingPipe.this.translateAttributes(EffectWidgetReplacingPipe.this.input.attrs, namesToTranslate);
                    EffectWidgetReplacingPipe.this.out.element("fi", "http://apache.org/cocoon/forms/1.0#instance", EffectWidgetReplacingPipe.FORM_TEMPLATE_EL, transAttrs);
                    EffectWidgetReplacingPipe.this.out.startElement();
                    return this;
                }
                case 7: {
                    return EffectWidgetReplacingPipe.this.nestedTemplate();
                }
                case 6: {
                    EffectWidgetReplacingPipe.this.out.copy();
                    EffectWidgetReplacingPipe.this.out.endPrefixMapping("fi");
                    EffectWidgetReplacingPipe.this.contextWidget = null;
                    return this;
                }
            }
            EffectWidgetReplacingPipe.this.out.copy();
            return this;
        }
    }

    protected class DocHandler
    extends EffectPipe.Handler {
        protected DocHandler() {
        }

        public EffectPipe.Handler process() throws SAXException {
            switch (EffectWidgetReplacingPipe.this.event) {
                case 0: {
                    return this;
                }
                case 3: {
                    if ("http://apache.org/cocoon/forms/1.0#template".equals(EffectWidgetReplacingPipe.this.input.uri)) {
                        EffectWidgetReplacingPipe.this.namespacePrefix = EffectWidgetReplacingPipe.this.input.prefix;
                        return this;
                    }
                    EffectWidgetReplacingPipe.this.out.copy();
                    return this;
                }
                case 7: {
                    if ("http://apache.org/cocoon/forms/1.0#template".equals(EffectWidgetReplacingPipe.this.input.uri)) {
                        if (EffectWidgetReplacingPipe.FORM_TEMPLATE_EL.equals(EffectWidgetReplacingPipe.this.input.loc)) {
                            return EffectWidgetReplacingPipe.this.formHandler;
                        }
                        EffectWidgetReplacingPipe.this.throwSAXException("CForms template \"" + EffectWidgetReplacingPipe.this.input.loc + "\" not permitted outside \"form-template\"");
                    } else {
                        EffectWidgetReplacingPipe.this.out.copy();
                        return this;
                    }
                }
                case 4: {
                    return this;
                }
            }
            EffectWidgetReplacingPipe.this.out.copy();
            return this;
        }
    }
}

