/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.validation.impl;

import org.apache.cocoon.forms.datatype.ValidationRule;
import org.apache.cocoon.forms.formmodel.ExpressionContextImpl;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.validation.ValidationError;
import org.apache.cocoon.forms.validation.ValidationErrorAware;
import org.apache.cocoon.forms.validation.WidgetValidator;

public class ValidationRuleValidator
implements WidgetValidator {
    private ValidationRule rule;

    public ValidationRuleValidator(ValidationRule rule) {
        this.rule = rule;
    }

    public boolean validate(Widget widget) {
        if (!(widget instanceof ValidationErrorAware)) {
            throw new IllegalArgumentException("Widget '" + widget.getRequestParameterName() + "' is not ValidationErrorAware");
        }
        Object value = widget.getValue();
        if (value == null) {
            return true;
        }
        ValidationError error = this.rule.validate(value, new ExpressionContextImpl(widget));
        if (error != null) {
            ((ValidationErrorAware)((Object)widget)).setValidationError(error);
            return false;
        }
        return true;
    }
}

