/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.util.Map;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.Cookie;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;

public class CookieCreatorAction
extends ServiceableAction
implements ThreadSafe {
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws Exception {
        Response res = ObjectModelHelper.getResponse((Map)objectModel);
        if (res == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("COOKIECREATOR: no response object");
            }
            return null;
        }
        String cookieName = null;
        String cookieValue = null;
        String cookieComment = null;
        String cookieDomain = null;
        String cookiePath = null;
        try {
            cookieName = parameters.getParameter("name");
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("COOKIECREATOR: cannot retrieve cookie name attribute");
            }
            return null;
        }
        cookieValue = parameters.getParameter("value", "");
        Cookie cookie = res.createCookie(cookieName, cookieValue);
        try {
            cookieComment = parameters.getParameter("comment");
            if (cookieComment != null) {
                cookie.setComment(cookieComment);
            }
        }
        catch (ParameterException ignore) {
            // empty catch block
        }
        try {
            cookieDomain = parameters.getParameter("domain");
            if (cookieDomain != null) {
                cookie.setDomain(cookieDomain);
            }
        }
        catch (ParameterException ignore) {
            // empty catch block
        }
        try {
            cookiePath = parameters.getParameter("path");
            if (cookiePath != null) {
                cookie.setPath(cookiePath);
            }
        }
        catch (ParameterException ignore) {
            // empty catch block
        }
        cookie.setSecure(parameters.getParameterAsBoolean("secure", false));
        cookie.setMaxAge(parameters.getParameterAsInteger("maxage", 0));
        cookie.setVersion(parameters.getParameterAsInteger("version", 0));
        res.addCookie(cookie);
        if (this.getLogger().isDebugEnabled()) {
            if (cookie.getMaxAge() == 0) {
                this.getLogger().debug("COOKIECREATOR: '" + cookieName + "' cookie has been removed");
            } else {
                this.getLogger().debug("COOKIECREATOR: '" + cookieName + "' cookie created with value '" + cookieValue + "' (version " + cookie.getVersion() + "; it will expire in " + cookie.getMaxAge() + " seconds)");
            }
        }
        return null;
    }
}

