/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.avalon.excalibur.logger.LogKitLoggerManager;
import org.apache.avalon.excalibur.logger.LoggerManager;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.Cocoon;
import org.apache.cocoon.Constants;
import org.apache.cocoon.ant.CocoonProcessorDelegate;
import org.apache.cocoon.environment.commandline.CommandLineContext;
import org.apache.cocoon.util.IOUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log.Hierarchy;
import org.apache.log.Priority;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class CocoonTask
extends Task {
    protected static final String DEFAULT_USER_AGENT = Constants.COMPLETE_NAME;
    protected static final String DEFAULT_ACCEPT = "text/html, */*";
    private File logkitXconf = null;
    private File destDir = null;
    private File workDir;
    private File contextDir;
    private File configFile;
    private String logger;
    private String logLevel;
    private String acceptHeader;
    private String agentHeader;
    private Boolean followLinks;
    private List targets;
    private Path cocoonClasspath;

    public CocoonTask() {
        File workDirParent = new File(SystemUtils.JAVA_IO_TMPDIR != null ? SystemUtils.JAVA_IO_TMPDIR : ".");
        this.workDir = new File(workDirParent, "work");
        this.contextDir = null;
        this.logLevel = "INFO";
        this.logger = "cocoon";
        this.acceptHeader = DEFAULT_ACCEPT;
        this.agentHeader = DEFAULT_USER_AGENT;
        this.followLinks = Boolean.TRUE;
        this.targets = new ArrayList();
    }

    public void setLogkitXconf(File logkitXconf) {
        this.logkitXconf = logkitXconf;
    }

    public void setLogger(String logger) {
        this.logger = logger;
    }

    public void setLogLevel(LogLevelOption logLevelOption) {
        this.logLevel = logLevelOption.getValue();
    }

    public void setAcceptHeader(String acceptHeader) {
        this.acceptHeader = acceptHeader;
    }

    public void setAgentHeader(String agentHeader) {
        this.agentHeader = agentHeader;
    }

    public void setPrecompileOnly(boolean preCompileOnly) {
    }

    public void setFollowLinks(boolean followLinks) {
        this.followLinks = new Boolean(followLinks);
    }

    public void setTargets(String targets) {
        this.targets = new ArrayList();
        String DEFAULT_DELIM = " ,;";
        String delimiter = " ,;";
        StringTokenizer st = new StringTokenizer(targets, " ,;");
        while (st.hasMoreTokens()) {
            String target = st.nextToken();
            this.targets.add(target);
        }
    }

    public void setDestDir(File destDir) {
        this.destDir = this.getDir(destDir.toString(), true, "dest-dir");
    }

    public void setWorkDir(File workDir) {
        this.workDir = this.getDir(workDir.toString(), true, "work-dir");
    }

    public void setContextDir(File contextDir) {
        this.contextDir = this.getDir(contextDir.toString(), false, "context-dir");
    }

    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public Path createClasspath() {
        if (this.cocoonClasspath == null) {
            this.cocoonClasspath = new Path(this.project);
        }
        return this.cocoonClasspath.createPath();
    }

    public void execute() throws BuildException {
        String message;
        if (this.contextDir != null) {
            if (this.configFile == null) {
                this.configFile = this.getContextDirFile(this.contextDir, "cocoon.xconf");
            }
            if (this.logkitXconf == null) {
                this.logkitXconf = this.getContextDirFile(this.contextDir, "logkit.xconf");
            }
        }
        this.checkValidity();
        DefaultContext rootCtx = new DefaultContext();
        DefaultConfiguration configuration = new DefaultConfiguration("root", "");
        Cocoon cocoon = null;
        CocoonFactory cocoonFactory = null;
        try {
            DefaultConfiguration child;
            rootCtx.put((Object)"dest-dir", (Object)this.destDir);
            rootCtx.put((Object)"context-root", (Object)this.contextDir);
            rootCtx.put((Object)"work-directory", (Object)this.workDir);
            rootCtx.put((Object)"config-url", (Object)this.configFile.toURL());
            ClassLoader classLoader = null;
            if (this.cocoonClasspath != null) {
                AntClassLoader antClassLoader = new AntClassLoader(this.project, this.cocoonClasspath, false);
                this.log("Using Class Loader having classpath " + String.valueOf(this.cocoonClasspath), 2);
                classLoader = antClassLoader;
            } else {
                classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            }
            rootCtx.put((Object)"class-loader", (Object)classLoader);
            Thread.currentThread().setContextClassLoader(classLoader);
            if (this.logkitXconf != null) {
                child = new DefaultConfiguration("logkit", "");
                child.setValue(this.logkitXconf.toString());
                configuration.addChild((Configuration)child);
            }
            child = new DefaultConfiguration("log-level", "");
            child.setValue(this.logLevel);
            configuration.addChild((Configuration)child);
            child = new DefaultConfiguration("follow-links", "");
            child.setValue(this.followLinks.toString());
            configuration.addChild((Configuration)child);
            DefaultConfiguration headers = new DefaultConfiguration("headers", "");
            child = new DefaultConfiguration("parameter", "");
            child.setAttribute("name", "accept");
            child.setAttribute("value", this.acceptHeader);
            headers.addChild((Configuration)child);
            child = new DefaultConfiguration("parameter", "");
            child.setAttribute("name", "user-agent");
            child.setAttribute("value", this.agentHeader);
            headers.addChild((Configuration)child);
            configuration.addChild((Configuration)headers);
            cocoonFactory = new CocoonFactory();
            cocoonFactory.enableLogging((Logger)new ConsoleLogger());
            cocoonFactory.contextualize((Context)rootCtx);
            cocoonFactory.configure((Configuration)configuration);
        }
        catch (Exception e) {
            String message2 = "Cannot create cocoon factory";
            throw new BuildException(message2, (Throwable)e);
        }
        try {
            cocoon = cocoonFactory.createCocoon();
        }
        catch (Exception e) {
            message = "Cannot create cocoon object";
            throw new BuildException(message, (Throwable)e);
        }
        try {
            try {
                HashSet uniqueTargets = new HashSet();
                uniqueTargets.addAll(this.targets);
                CocoonProcessorDelegate cpd = cocoonFactory.createCocoonProcessorDelegate(cocoon, (Configuration)configuration);
                cpd.processAllUris(uniqueTargets);
            }
            catch (Exception e) {
                message = "Cannot process Uri(s) by Cocoon";
                throw new BuildException(message, (Throwable)e);
            }
            Object var9_12 = null;
            cocoonFactory.disposeCocoon(cocoon);
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            cocoonFactory.disposeCocoon(cocoon);
            throw throwable;
        }
    }

    protected File getContextDirFile(File contextDir, String name) {
        File fullName1 = new File(contextDir, "WEB-INF/" + name);
        if (fullName1.exists() && fullName1.canRead()) {
            return fullName1;
        }
        File fullName2 = new File(contextDir, name);
        if (fullName2.exists() && fullName2.canRead()) {
            return fullName2;
        }
        String message = "Cannot find, or access file " + String.valueOf(name) + " " + "neither " + String.valueOf(fullName1) + ", " + "nor " + String.valueOf(fullName2);
        this.log(message, 2);
        return null;
    }

    protected File getDir(String dir, boolean create, String type) throws BuildException {
        this.log("Getting handle to " + type + " directory '" + dir + "'", 2);
        File d = new File(dir);
        if (!d.exists() && create && !d.mkdirs()) {
            String message = "Error creating " + type + " directory '" + d + "'";
            throw new BuildException(message);
        }
        if (!d.isDirectory()) {
            String message = "'" + d + "' is not a directory.";
            throw new BuildException(message);
        }
        if (!d.canRead() || !d.canWrite()) {
            String message = "Directory '" + d + "' is not readable/writable";
            throw new BuildException(message);
        }
        return d;
    }

    protected void checkValidity() throws BuildException {
        if (this.destDir == null) {
            throw new BuildException("Set attribute destDir!");
        }
        this.destDir = this.getDir(this.destDir.toString(), true, "dest-dir");
        if (this.workDir == null) {
            throw new BuildException("Set attribute workDir!");
        }
        this.workDir = this.getDir(this.workDir.toString(), true, "work-dir");
        if (this.contextDir == null) {
            throw new BuildException("Set attribute contextDir!");
        }
        this.contextDir = this.getDir(this.contextDir.toString(), false, "contex-dir");
        if (this.configFile == null) {
            throw new BuildException("Set attribute configFile!");
        }
        if (this.logger == null) {
            throw new BuildException("Set attribute logger!");
        }
        if (this.logLevel == null) {
            throw new BuildException("Set attribute logLevel!");
        }
        if (this.acceptHeader == null) {
            throw new BuildException("Set attribute acceptHeader!");
        }
        if (this.agentHeader == null) {
            throw new BuildException("Set attribute agentHeader!");
        }
        if (!this.destDir.exists() || !this.destDir.isDirectory()) {
            throw new BuildException("Attribute destDir directory " + String.valueOf(this.destDir) + " does not exists, or is not a directory!");
        }
        if (!this.contextDir.exists() || !this.contextDir.isDirectory()) {
            throw new BuildException("Attribute contextDir directory " + String.valueOf(this.contextDir) + " does not exists, or is not a directory!");
        }
        if (!this.workDir.exists() || !this.workDir.isDirectory()) {
            throw new BuildException("Attribute worktDir directory " + String.valueOf(this.workDir) + " does not exists, or is not a directory!");
        }
    }

    public static class LogLevelOption
    extends EnumeratedAttribute {
        public String[] getValues() {
            String[] values = new String[]{"DEBUG", "INFO", "WARN", "ERROR", "FATAL_ERROR"};
            return values;
        }
    }

    public static class CocoonFactory
    extends AbstractLogEnabled
    implements Contextualizable,
    Configurable {
        private LogKitLoggerManager logKitLoggerManager;
        private Logger logger;
        private DefaultContext ctx;

        public void contextualize(Context context) throws ContextException {
            this.ctx = new DefaultContext(context);
            File contextDir = (File)this.ctx.get((Object)"context-root");
            File workDir = (File)this.ctx.get((Object)"work-directory");
            CommandLineContext clContext = new CommandLineContext(contextDir.toString());
            clContext.enableLogging(this.getLogger());
            this.ctx.put((Object)"environment-context", (Object)clContext);
            this.ctx.put((Object)"classpath", (Object)this.getClassPath(contextDir));
            this.ctx.put((Object)"upload-directory", (Object)new File(contextDir, "upload-dir"));
            this.ctx.put((Object)"cache-directory", (Object)new File(workDir, "cache-dir"));
        }

        public void configure(Configuration configuration) throws ConfigurationException {
            String logLevel = "WARN";
            Configuration child = configuration.getChild("log-level", false);
            logLevel = child != null ? child.getValue() : "WARN";
            Priority priority = Priority.getPriorityForName((String)logLevel);
            Hierarchy.getDefaultHierarchy().setDefaultPriority(priority);
            this.logger = new LogKitLogger(Hierarchy.getDefaultHierarchy().getLoggerFor(""));
            child = configuration.getChild("logKit", false);
            if (child != null) {
                String logKit = child.getValue();
                String logKitLogCategory = child.getAttribute("category", "cocoon");
                if (logKit != null) {
                    try {
                        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
                        Configuration logKitConf = builder.buildFromFile(logKit);
                        this.logKitLoggerManager = new LogKitLoggerManager(Hierarchy.getDefaultHierarchy());
                        DefaultContext subcontext = new DefaultContext((Context)this.ctx);
                        File contextDir = (File)this.ctx.get((Object)"context-root");
                        subcontext.put((Object)"context-root", (Object)contextDir);
                        this.logKitLoggerManager.contextualize((Context)subcontext);
                        this.logKitLoggerManager.configure(logKitConf);
                        this.logger = this.logKitLoggerManager.getLoggerForCategory(logKitLogCategory);
                    }
                    catch (Exception e) {
                        this.getLogger().error("Cannot initialize log-kit-manager from logkit-xconf " + String.valueOf(logKit));
                        this.logKitLoggerManager = null;
                    }
                }
            }
            if (this.logKitLoggerManager == null) {
                this.logKitLoggerManager = new LogKitLoggerManager(Hierarchy.getDefaultHierarchy());
                this.logKitLoggerManager.enableLogging(this.logger);
            }
        }

        public Cocoon createCocoon() throws Exception, ContextException, ConfigurationException {
            Cocoon cocoon = new Cocoon();
            cocoon.enableLogging(this.logger);
            cocoon.contextualize((Context)this.ctx);
            cocoon.setLoggerManager((LoggerManager)this.logKitLoggerManager);
            cocoon.initialize();
            return cocoon;
        }

        public void disposeCocoon(Cocoon cocoon) {
            if (cocoon != null) {
                cocoon.dispose();
            }
        }

        public CocoonProcessorDelegate createCocoonProcessorDelegate(Cocoon cocoon, Configuration configuration) throws Exception {
            CocoonProcessorDelegate cpd = new CocoonProcessorDelegate(cocoon);
            cpd.enableLogging(this.logger);
            cpd.contextualize((Context)this.ctx);
            cpd.configure(configuration);
            cpd.initialize();
            return cpd;
        }

        protected String getClassPath(File contextDir) {
            StringBuffer buildClassPath = new StringBuffer();
            File classDir = new File(contextDir, "WEB-INF/classes");
            File root = new File(contextDir, "WEB-INF/lib");
            buildClassPath.append(classDir);
            if (root.isDirectory()) {
                Object[] libraries = root.listFiles();
                Arrays.sort(libraries);
                int i = 0;
                while (i < libraries.length) {
                    buildClassPath.append(File.pathSeparatorChar).append(IOUtils.getFullFilename((File)libraries[i]));
                    ++i;
                }
            }
            buildClassPath.append(File.pathSeparatorChar).append(SystemUtils.JAVA_CLASS_PATH);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Context classpath: " + buildClassPath.toString());
            }
            return buildClassPath.toString();
        }
    }
}

