/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.Serializable;
import java.util.Map;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.caching.Cache;
import org.apache.cocoon.caching.CachedResponse;
import org.apache.cocoon.caching.IdentifierCacheKey;
import org.apache.cocoon.components.cron.ConfigurableCronJob;
import org.apache.cocoon.components.source.impl.CachedSourceResponse;
import org.apache.cocoon.components.source.impl.CachingSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.ExpiresValidity;

public class UpdateTarget
extends AbstractLogEnabled
implements Serviceable,
ConfigurableCronJob {
    private ServiceManager manager;
    private SourceResolver resolver;
    private String uri;
    private String cacheRole;
    private int expires;
    private boolean failSafe;
    private IdentifierCacheKey cacheKey;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
    }

    public void setup(Parameters pars, Map objects) {
        this.uri = pars.getParameter("uri", null);
        this.cacheRole = pars.getParameter("cache-role", Cache.ROLE);
        this.expires = pars.getParameterAsInteger("cache-expires", 60);
        this.failSafe = pars.getParameterAsBoolean("fail-safe", true);
        this.cacheKey = (IdentifierCacheKey)objects.get("cache-key");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(String name) {
        Cache cache;
        Source source;
        block17: {
            block16: {
                if (this.uri == null) return;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Refreshing " + this.uri);
                }
                source = null;
                cache = null;
                try {
                    try {
                        SourceValidity sourceValidity;
                        cache = (Cache)this.manager.lookup(this.cacheRole);
                        source = this.resolver.resolveURI(this.uri);
                        CachedSourceResponse response = (CachedSourceResponse)cache.get((Serializable)this.cacheKey);
                        if (response != null && CachingSource.isValid(sourceValidity = response.getValidityObjects()[1], source)) {
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("Cached response is still valid for source " + this.uri + ".");
                            }
                            response.getValidityObjects()[0] = new ExpiresValidity((long)(this.expires * 1000));
                            Object var10_7 = null;
                            break block16;
                        }
                        if (source.exists()) {
                            byte[] binary = null;
                            byte[] xml = null;
                            if (response != null) {
                                binary = response.getBinaryResponse();
                                xml = response.getXMLResponse();
                            }
                            ExpiresValidity cacheValidity = new ExpiresValidity((long)(this.expires * 1000));
                            SourceValidity sourceValidity2 = source.getValidity();
                            response = new CachedSourceResponse(new SourceValidity[]{cacheValidity, sourceValidity2});
                            if (binary != null) {
                                binary = CachingSource.readBinaryResponse(source);
                                response.setBinaryResponse(binary);
                            }
                            if (xml != null) {
                                xml = CachingSource.readXMLResponse(source, binary, this.manager);
                                response.setXMLResponse(xml);
                            }
                            response.setExtra(CachingSource.readMeta(source));
                            cache.store((Serializable)this.cacheKey, (CachedResponse)response);
                            break block17;
                        }
                        if (response != null) {
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("Source " + this.uri + " no longer exists." + " Throwing out cached response.");
                            }
                            cache.remove((Serializable)this.cacheKey);
                        }
                        break block17;
                    }
                    catch (Exception e) {
                        if (!this.failSafe) {
                            cache.remove((Serializable)this.cacheKey);
                            this.getLogger().warn("Exception during updating of source " + this.uri, (Throwable)e);
                        } else {
                            this.getLogger().warn("Updating of source " + this.uri + " failed. " + "Cached response (if any) will be stale.", (Throwable)e);
                        }
                        Object var10_9 = null;
                        this.resolver.release(source);
                        this.manager.release((Object)cache);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    this.resolver.release(source);
                    this.manager.release((Object)cache);
                    throw throwable;
                }
            }
            this.resolver.release(source);
            this.manager.release((Object)cache);
            return;
        }
        Object var10_8 = null;
        this.resolver.release(source);
        this.manager.release((Object)cache);
    }
}

