/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servlet;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class CocoonFilterGeneratorImpl
implements Filter {
    public static final String COCOON_SERVLET_CLASS_NAME_PARAM = "cocoon-servlet-class-name";
    public static final String COCOON_SERVLET_CLASS_NAME_DEFAULT = "org.apache.cocoon.servlet.CocoonServlet";
    final String VERBOSE_PARAM = "verbose";
    final boolean VERBOSE_DEFAULT = true;
    private boolean verbose = false;
    private Servlet cocoon = null;
    private FilterConfig filterConfig;

    public void init(FilterConfig cfg) throws ServletException {
        this.setFilterConfig(cfg);
    }

    public void setFilterConfig(FilterConfig cfg) {
        this.filterConfig = cfg;
        this.logFilterConfig();
        String value = this.filterConfig.getInitParameter("verbose");
        this.verbose = value != null ? "true".compareToIgnoreCase(value) == 0 : true;
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void destroy() {
        if (this.cocoon != null) {
            this.cocoon.destroy();
            this.cocoon = null;
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain fc) throws IOException, ServletException {
        this.log("doFilter...");
        if (this.verbose) {
            this.logServletContext();
        }
        CocoonFilterGeneratorResponseWrapper res_wrapper1 = new CocoonFilterGeneratorResponseWrapper((HttpServletResponse)res);
        this.log("do filter pre-processing...");
        fc.doFilter(req, (ServletResponse)res_wrapper1);
        this.log("get xml-data...");
        byte[] res_wrapper_data = res_wrapper1.getData();
        if (this.verbose) {
            this.log("get xml-data: " + new String(res_wrapper_data));
            this.log("store xml-data in request-attr org.apache.cocoon.xml-data");
        }
        CocoonFilterGeneratorRequestWrapper cfgrw = new CocoonFilterGeneratorRequestWrapper((HttpServletRequest)req);
        cfgrw.setXMLData(res_wrapper_data);
        try {
            this.log("create Cocoon instance...");
            this.createCocoonInstance();
            this.log("service using Cocoon instance...");
            this.cocoon.service((ServletRequest)cfgrw, res);
        }
        catch (Exception e) {
            throw new ServletException("Cannot post-process using Cocoon", (Throwable)e);
        }
    }

    protected String getCocoonServletClassName() {
        String clazz_name = this.filterConfig.getInitParameter(COCOON_SERVLET_CLASS_NAME_PARAM);
        if (clazz_name == null) {
            clazz_name = COCOON_SERVLET_CLASS_NAME_DEFAULT;
        }
        return clazz_name;
    }

    protected boolean isVerbose() {
        return this.verbose;
    }

    protected Servlet createCocoonInstance() throws ClassNotFoundException, InstantiationException, IllegalAccessException, ServletException {
        String clazz_name = this.getCocoonServletClassName();
        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(clazz_name);
        if (this.cocoon == null) {
            this.cocoon = (Servlet)clazz.newInstance();
            this.cocoon.init((ServletConfig)new CocoonFilterGeneratorConfig(this.filterConfig.getServletContext()));
        }
        return this.cocoon;
    }

    protected void log(String s) {
        this.filterConfig.getServletContext().log("[" + this.getClass().getName() + "] " + String.valueOf(s));
    }

    protected void logFilterConfig() {
        this.log("filter config name " + this.filterConfig.getFilterName());
        Enumeration names = this.filterConfig.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = this.filterConfig.getInitParameter(name);
            this.log("filter config init parameter name " + String.valueOf(name) + ", " + "value " + String.valueOf(value));
        }
    }

    protected void logServletContext() {
        Object value;
        String name;
        ServletContext context = this.filterConfig.getServletContext();
        Enumeration names = context.getAttributeNames();
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            value = context.getAttribute(name);
            this.log("context attribute name " + String.valueOf(name) + ", " + "value " + String.valueOf(value));
        }
        names = context.getInitParameterNames();
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            value = context.getInitParameter(name);
            this.log("context init parameter name " + String.valueOf(name) + ", " + "value " + String.valueOf(value));
        }
    }

    class CocoonFilterGeneratorOutputStream
    extends ServletOutputStream {
        private DataOutputStream stream;

        public CocoonFilterGeneratorOutputStream(OutputStream output) {
            this.stream = new DataOutputStream(output);
        }

        public void write(int b) throws IOException {
            this.stream.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.stream.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.stream.write(b, off, len);
        }
    }

    class CocoonFilterGeneratorResponseWrapper
    extends HttpServletResponseWrapper {
        private ByteArrayOutputStream output;
        private int contentLength;
        private String contentType;

        CocoonFilterGeneratorResponseWrapper(HttpServletResponse response) {
            super(response);
            this.output = new ByteArrayOutputStream();
        }

        public void setContentType(String type) {
            this.contentType = type;
            super.setContentType(type);
        }

        public ServletOutputStream getOutputStream() {
            return new CocoonFilterGeneratorOutputStream(this.output);
        }

        public byte[] getData() {
            return this.output.toByteArray();
        }

        public PrintWriter getWriter() throws IOException {
            return new PrintWriter((OutputStream)this.getOutputStream(), true);
        }

        public int getContentLength() {
            return this.contentLength;
        }

        public String getContentType() {
            return this.contentType;
        }
    }

    class CocoonFilterGeneratorConfig
    implements ServletConfig {
        ServletContext c;

        public CocoonFilterGeneratorConfig(ServletContext c) {
            this.c = c;
        }

        public String getServletName() {
            return "CocoonFilterGeneratorImpl";
        }

        public Enumeration getInitParameterNames() {
            return this.c.getInitParameterNames();
        }

        public ServletContext getServletContext() {
            return this.c;
        }

        public String getInitParameter(String name) {
            return null;
        }
    }

    class CocoonFilterGeneratorRequestWrapper
    extends HttpServletRequestWrapper {
        public static final String XML_DATA_ATTR = "org.apache.cocoon.xml-data";

        public CocoonFilterGeneratorRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public void setXMLData(byte[] xmlData) {
            this.setAttribute(XML_DATA_ATTR, xmlData);
        }

        public byte[] getXMLData() {
            return (byte[])this.getAttribute(XML_DATA_ATTR);
        }
    }
}

