/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation.constrained;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.cocoon.transformation.constrained.ContainerElementEndEvent;
import org.apache.cocoon.transformation.constrained.ElementEventAdapter;
import org.apache.cocoon.transformation.constrained.ElementEventListener;
import org.apache.cocoon.transformation.constrained.ElementValueEvent;
import org.apache.cocoon.transformation.constrained.XmlTreeConstraint;
import org.apache.cocoon.xml.XMLConsumer;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractConstrainedTransformer
extends AbstractTransformer {
    private String my_uri;
    private String my_name;
    private List myUriOpenElements = new ArrayList();
    private List globalOpenElements = new ArrayList();
    private List globalOpenElementsAttributes = new ArrayList();
    private String lastOpenElementRaw = "";
    private List registeredListeners = new ArrayList();
    private List registeredListenerConstraints = new ArrayList();
    private StringBuffer current_value = new StringBuffer();
    public XMLConsumer xml_consumer;
    public LexicalHandler lexical_handler;

    public abstract void init(Parameters var1);

    public abstract String getUri();

    public abstract String getName();

    public final void setup(SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws ProcessingException, SAXException, IOException {
        this.my_uri = this.getUri();
        this.getLogger().debug(this.my_uri);
        this.my_name = this.getName();
        this.getLogger().debug(this.my_name);
        this.init(parameters);
    }

    public void addEventListener(ElementEventListener l, XmlTreeConstraint constraint) {
        this.registeredListeners.add(l);
        this.registeredListenerConstraints.add(constraint);
    }

    public void setDocumentLocator(Locator locator) {
        if (this.contentHandler != null) {
            this.contentHandler.setDocumentLocator(locator);
        }
    }

    public void startElement(String uri, String name, String raw, Attributes attributes) throws SAXException {
        System.out.println("Start Element " + uri + " " + name + " " + raw + " " + attributes);
        this.lastOpenElementRaw = raw;
        boolean isMyUri = false;
        if (uri.equals(this.my_uri)) {
            isMyUri = true;
            System.out.println(raw + " isMyUri!!!");
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(raw + " isMyUri!!!");
            }
            this.myUriOpenElements.add(name);
            this.current_value.delete(0, this.current_value.length());
            this.globalOpenElements.add(name);
            this.globalOpenElementsAttributes.add(attributes);
            ListIterator constraintsIter = this.registeredListenerConstraints.listIterator();
            while (constraintsIter.hasNext()) {
                if (!((XmlTreeConstraint)constraintsIter.next()).isAllowed(new Boolean(isMyUri), this.myUriOpenElements, this.globalOpenElements)) continue;
                return;
            }
        } else {
            System.out.println(raw + " is NOT MyUri!!!");
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(raw + " is NOT MyUri!!!");
            }
            super.startElement(uri, name, raw, attributes);
        }
    }

    public void endElement(String uri, String name, String raw) throws SAXException {
        try {
            boolean isMyUri = false;
            if (uri.equals(this.my_uri)) {
                isMyUri = true;
                ListIterator constraintsIter = this.registeredListenerConstraints.listIterator();
                boolean isElementTag = this.lastOpenElementRaw.equals(raw);
                while (constraintsIter.hasNext()) {
                    XmlTreeConstraint currentConstraint = (XmlTreeConstraint)constraintsIter.next();
                    boolean isAllowed = currentConstraint.isAllowed(new Boolean(isMyUri), this.myUriOpenElements, this.globalOpenElements);
                    if (!isAllowed) continue;
                    EventListener el = (EventListener)this.registeredListeners.get(constraintsIter.previousIndex());
                    if (isElementTag) {
                        ((ElementEventListener)el).elementValueRecieved(new ElementValueEvent((Object)this, name, this.current_value.toString(), (Attributes)this.globalOpenElementsAttributes.get(this.globalOpenElementsAttributes.size() - 1)));
                    } else {
                        ((ElementEventListener)el).containerElementEnded(new ContainerElementEndEvent((Object)this, name));
                    }
                    if (uri.equals(this.my_uri)) {
                        this.myUriOpenElements.remove(this.myUriOpenElements.size() - 1);
                    }
                    this.globalOpenElements.remove(this.globalOpenElements.size() - 1);
                    this.globalOpenElementsAttributes.remove(this.globalOpenElementsAttributes.size() - 1);
                    this.current_value.delete(0, this.current_value.length());
                    return;
                }
                if (this.globalOpenElements.size() > 0) {
                    this.globalOpenElements.remove(this.globalOpenElements.size() - 1);
                    this.globalOpenElementsAttributes.remove(this.globalOpenElementsAttributes.size() - 1);
                }
                if (uri.equals(this.my_uri) && this.myUriOpenElements.size() > 0) {
                    this.myUriOpenElements.remove(this.myUriOpenElements.size() - 1);
                }
            } else {
                super.endElement(uri, name, raw);
            }
            this.current_value.delete(0, this.current_value.length());
        }
        catch (Exception t) {
            throw new SAXException("Exception in transformer " + this.getName() + " with uri " + this.getUri() + " while ending element.", t);
        }
    }

    public void characters(char[] ary, int start, int length) throws SAXException {
        if (this.globalOpenElements.isEmpty()) {
            super.characters(ary, start, length);
        } else {
            this.current_value.append(ary, start, length);
        }
    }

    public void start(String name, AttributesImpl attr) throws SAXException {
        this.contentHandler.startElement(this.getUri(), name, name, attr);
        attr.clear();
    }

    public void start(String name) throws SAXException {
        this.contentHandler.startElement(this.getUri(), name, name, new AttributesImpl());
    }

    public void end(String name) throws SAXException {
        this.contentHandler.endElement(this.getUri(), name, name);
    }

    public void data(String data) throws SAXException {
        if (data != null) {
            this.contentHandler.characters(data.toCharArray(), 0, data.length());
        }
    }

    public static String getStringValue(Object object) {
        if (object instanceof byte[]) {
            return new String((byte[])object);
        }
        if (object instanceof char[]) {
            return new String((char[])object);
        }
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public class RipperListener
    extends ElementEventAdapter {
        public void elementValueRecieved(ElementValueEvent e) {
        }
    }
}

