/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.sax.XMLDeserializer;
import org.apache.cocoon.components.sax.XMLSerializer;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractSAXTransformer;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.excalibur.xml.sax.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class SQLTransformer
extends AbstractSAXTransformer
implements Disposable,
Configurable {
    public static final String NAMESPACE = "http://apache.org/cocoon/SQL/2.0";
    public static final String MAGIC_EXECUTE_QUERY = "execute-query";
    public static final String MAGIC_CONNECTION = "use-connection";
    public static final String MAGIC_DBURL = "dburl";
    public static final String MAGIC_USERNAME = "username";
    public static final String MAGIC_PASSWORD = "password";
    public static final String MAGIC_NR_OF_ROWS = "show-nr-of-rows";
    public static final String MAGIC_QUERY = "query";
    public static final String MAGIC_VALUE = "value";
    public static final String MAGIC_COLUMN_CASE = "column-case";
    public static final String MAGIC_DOC_ELEMENT = "doc-element";
    public static final String MAGIC_ROW_ELEMENT = "row-element";
    public static final String MAGIC_IN_PARAMETER = "in-parameter";
    public static final String MAGIC_IN_PARAMETER_NR_ATTRIBUTE = "nr";
    public static final String MAGIC_IN_PARAMETER_VALUE_ATTRIBUTE = "value";
    public static final String MAGIC_OUT_PARAMETER = "out-parameter";
    public static final String MAGIC_OUT_PARAMETER_NAME_ATTRIBUTE = "name";
    public static final String MAGIC_OUT_PARAMETER_NR_ATTRIBUTE = "nr";
    public static final String MAGIC_OUT_PARAMETER_TYPE_ATTRIBUTE = "type";
    public static final String MAGIC_ESCAPE_STRING = "escape-string";
    public static final String MAGIC_ERROR = "error";
    public static final String MAGIC_NS_URI_ELEMENT = "namespace-uri";
    public static final String MAGIC_NS_PREFIX_ELEMENT = "namespace-prefix";
    public static final String MAGIC_ANCESTOR_VALUE = "ancestor-value";
    public static final String MAGIC_ANCESTOR_VALUE_LEVEL_ATTRIBUTE = "level";
    public static final String MAGIC_ANCESTOR_VALUE_NAME_ATTRIBUTE = "name";
    public static final String MAGIC_SUBSTITUTE_VALUE = "substitute-value";
    public static final String MAGIC_SUBSTITUTE_VALUE_NAME_ATTRIBUTE = "name";
    public static final String MAGIC_NAME_ATTRIBUTE = "name";
    public static final String MAGIC_STORED_PROCEDURE_ATTRIBUTE = "isstoredprocedure";
    public static final String MAGIC_UPDATE_ATTRIBUTE = "isupdate";
    public static final String CLOB_ENCODING = "clob-encoding";
    protected static final int STATE_OUTSIDE = 0;
    protected static final int STATE_INSIDE_EXECUTE_QUERY_ELEMENT = 1;
    protected static final int STATE_INSIDE_VALUE_ELEMENT = 2;
    protected static final int STATE_INSIDE_QUERY_ELEMENT = 3;
    protected static final int STATE_INSIDE_ANCESTOR_VALUE_ELEMENT = 4;
    protected static final int STATE_INSIDE_SUBSTITUTE_VALUE_ELEMENT = 5;
    protected static final int STATE_INSIDE_IN_PARAMETER_ELEMENT = 6;
    protected static final int STATE_INSIDE_OUT_PARAMETER_ELEMENT = 7;
    protected static final int STATE_INSIDE_ESCAPE_STRING = 8;
    protected boolean oldDriver = false;
    protected int connectAttempts = 5;
    protected int connectWaittime = 5;
    protected Vector queries;
    protected int current_query_index;
    protected int current_state;
    protected boolean showNrOfRows;
    protected String outPrefix;
    protected String outUri;
    protected ServiceSelector dbSelector;
    protected Properties format = new Properties();
    protected XMLSerializer compiler;
    protected XMLDeserializer interpreter;
    protected SAXParser parser;
    protected String clobEncoding;
    protected String xmlDefaultEncoding;
    protected Connection conn;

    public SQLTransformer() {
        this.format.put("method", "text");
        this.format.put("omit-xml-declaration", "yes");
        this.namespaceURI = NAMESPACE;
    }

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this.queries = new Vector();
        try {
            this.dbSelector = (ServiceSelector)manager.lookup(DataSourceComponent.ROLE + "Selector");
        }
        catch (ServiceException cme) {
            this.getLogger().warn("Could not get the DataSource Selector", (Throwable)cme);
        }
    }

    public void recycle() {
        super.recycle();
        try {
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
        }
        catch (SQLException e) {
            this.getLogger().warn("Could not close the connection", (Throwable)e);
        }
        this.queries.clear();
        this.outUri = null;
        this.outPrefix = null;
        this.manager.release((Object)this.parser);
        this.parser = null;
        this.manager.release((Object)this.compiler);
        this.compiler = null;
        this.manager.release((Object)this.interpreter);
        this.interpreter = null;
    }

    public void dispose() {
        if (this.dbSelector != null) {
            this.manager.release((Object)this.dbSelector);
            this.dbSelector = null;
        }
    }

    public void configure(Configuration conf) throws ConfigurationException {
        super.configure(conf);
        this.oldDriver = conf.getChild("old-driver").getValueAsBoolean(false);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("old-driver is " + this.oldDriver + " for " + (Object)((Object)this));
        }
        this.connectAttempts = conf.getChild("connect-attempts").getValueAsInteger(5);
        this.connectWaittime = conf.getChild("connect-waittime").getValueAsInteger(5000);
        this.xmlDefaultEncoding = conf.getChild("xml-encoding").getValue("ISO-8859-1");
    }

    public void setup(SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, source, parameters);
        this.format.put("encoding", parameters.getParameter("xml-encoding", this.xmlDefaultEncoding));
        this.current_query_index = -1;
        this.current_state = 0;
        this.showNrOfRows = parameters.getParameterAsBoolean(MAGIC_NR_OF_ROWS, false);
        this.clobEncoding = parameters.getParameter(CLOB_ENCODING, "");
        if (this.getLogger().isDebugEnabled()) {
            if (this.parameters.getParameter(MAGIC_CONNECTION, null) != null) {
                this.getLogger().debug("CONNECTION: " + this.parameters.getParameter(MAGIC_CONNECTION, null));
            } else {
                this.getLogger().debug("DBURL: " + parameters.getParameter(MAGIC_DBURL, null));
                this.getLogger().debug("USERNAME: " + parameters.getParameter(MAGIC_USERNAME, null));
            }
            this.getLogger().debug("DOC-ELEMENT: " + parameters.getParameter(MAGIC_DOC_ELEMENT, "rowset"));
            this.getLogger().debug("ROW-ELEMENT: " + parameters.getParameter(MAGIC_ROW_ELEMENT, "row"));
            this.getLogger().debug("NS-URI: " + parameters.getParameter(MAGIC_NS_URI_ELEMENT, NAMESPACE));
            this.getLogger().debug("NS-PREFIX: " + parameters.getParameter(MAGIC_NS_PREFIX_ELEMENT, ""));
            this.getLogger().debug("CLOB_ENCODING: " + this.clobEncoding);
        }
    }

    protected void executeQuery(int index) throws SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("SQLTransformer executing query nr " + index);
        }
        this.outUri = this.getCurrentQuery().properties.getParameter(MAGIC_NS_URI_ELEMENT, NAMESPACE);
        this.outPrefix = this.getCurrentQuery().properties.getParameter(MAGIC_NS_PREFIX_ELEMENT, "");
        if (!"".equals(this.outUri)) {
            super.startPrefixMapping(this.outPrefix, this.outUri);
        }
        AttributesImpl attr = new AttributesImpl();
        Query query = (Query)this.queries.elementAt(index);
        boolean query_failure = false;
        Connection conn = null;
        try {
            try {
                if (index == 0) {
                    if (this.conn == null) {
                        this.conn = query.getConnection();
                    }
                    conn = this.conn;
                } else {
                    conn = query.getConnection();
                }
                query.setConnection(conn);
                query.execute();
            }
            catch (SQLException e) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("SQLTransformer:.executeQuery() query.execute failed ", (Throwable)e);
                }
                AttributesImpl my_attr = new AttributesImpl();
                this.start(query.rowset_name, my_attr);
                this.start(MAGIC_ERROR, my_attr);
                this.data(e.getMessage());
                this.end(MAGIC_ERROR);
                this.end(query.rowset_name);
                query_failure = true;
            }
            if (!query_failure) {
                String name;
                if (this.showNrOfRows) {
                    attr.addAttribute(NAMESPACE, query.nr_of_rows, query.nr_of_rows, "CDATA", String.valueOf(query.getNrOfRows()));
                }
                if ((name = query.getName()) != null) {
                    attr.addAttribute(NAMESPACE, query.name_attribute, query.name_attribute, "CDATA", name);
                }
                this.start(query.rowset_name, attr);
                attr = new AttributesImpl();
                if (!query.isStoredProcedure()) {
                    while (query.next()) {
                        this.start(query.row_name, attr);
                        query.serializeRow(this.manager);
                        if (index + 1 < this.queries.size()) {
                            this.executeQuery(index + 1);
                        }
                        this.end(query.row_name);
                    }
                } else {
                    query.serializeStoredProcedure(this.manager);
                }
                this.end(query.rowset_name);
            }
        }
        catch (SQLException e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("SQLTransformer.executeQuery()", (Throwable)e);
            }
            throw new SAXException(e);
        }
        finally {
            try {
                query.close();
                if (index > 0) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                this.getLogger().warn("SQLTransformer: Could not close JDBC connection", (Throwable)e);
            }
        }
        if (!"".equals(this.outUri)) {
            super.endPrefixMapping(this.outPrefix);
        }
    }

    protected static void throwIllegalStateException(String message) {
        throw new IllegalStateException("SQLTransformer: " + message);
    }

    protected void startExecuteQueryElement() {
        switch (this.current_state) {
            case 0: 
            case 1: {
                this.current_query_index = this.queries.size();
                Query query = new Query(this, this.current_query_index);
                this.queries.addElement(query);
                this.current_state = 1;
                break;
            }
            default: {
                SQLTransformer.throwIllegalStateException("Not expecting a start execute query element");
            }
        }
    }

    protected void startValueElement(String name) throws SAXException {
        switch (this.current_state) {
            case 1: {
                this.stack.push(name);
                this.startTextRecording();
                this.current_state = 2;
                break;
            }
            default: {
                SQLTransformer.throwIllegalStateException("Not expecting a start value element: " + name);
            }
        }
    }

    protected void startQueryElement(Attributes attributes) throws SAXException {
        switch (this.current_state) {
            case 1: {
                String name;
                String isstoredprocedure;
                this.startSerializedXMLRecording(this.format);
                Query q = this.getCurrentQuery();
                this.current_state = 3;
                String isupdate = attributes.getValue("", MAGIC_UPDATE_ATTRIBUTE);
                if (isupdate != null && !isupdate.equalsIgnoreCase("false")) {
                    q.setUpdate(true);
                }
                if ((isstoredprocedure = attributes.getValue("", MAGIC_STORED_PROCEDURE_ATTRIBUTE)) != null && !isstoredprocedure.equalsIgnoreCase("false")) {
                    q.setStoredProcedure(true);
                }
                if ((name = attributes.getValue("", "name")) == null) break;
                q.setName(name);
                break;
            }
            default: {
                SQLTransformer.throwIllegalStateException("Not expecting a start query element");
            }
        }
    }

    protected void endQueryElement() throws ProcessingException, SAXException {
        switch (this.current_state) {
            case 3: {
                String value = this.endSerializedXMLRecording();
                if (value.length() > 0) {
                    this.getCurrentQuery().addQueryPart(value);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("QUERY IS \"" + value + "\"");
                    }
                }
                this.current_state = 1;
                break;
            }
            default: {
                SQLTransformer.throwIllegalStateException("Not expecting a stop query element");
            }
        }
    }

    protected void endValueElement() throws SAXException {
        switch (this.current_state) {
            case 2: {
                String name = (String)this.stack.pop();
                String value = this.endTextRecording();
                this.getCurrentQuery().setParameter(name, value);
                this.current_state = 1;
                if (!this.getLogger().isDebugEnabled()) break;
                this.getLogger().debug("SETTING VALUE ELEMENT name {" + name + "} value {" + value + "}");
                break;
            }
            default: {
                SQLTransformer.throwIllegalStateException("Not expecting an end value element");
            }
        }
    }

    protected void endExecuteQueryElement() throws SAXException {
        switch (this.current_state) {
            case 1: {
                if (this.current_query_index == 0) {
                    this.executeQuery(0);
                    this.queries.removeAllElements();
                    this.current_state = 0;
                    break;
                }
                --this.current_query_index;
                this.current_state = 1;
                break;
            }
            default: {
                SQLTransformer.throwIllegalStateException("Not expecting an end execute query element");
            }
        }
    }

    protected void startAncestorValueElement(Attributes attributes) throws ProcessingException, SAXException {
        switch (this.current_state) {
            case 3: {
                String value;
                int level = 0;
                try {
                    level = Integer.parseInt(attributes.getValue(NAMESPACE, MAGIC_ANCESTOR_VALUE_LEVEL_ATTRIBUTE));
                }
                catch (Exception e) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("SQLTransformer", (Throwable)e);
                    }
                    SQLTransformer.throwIllegalStateException("Ancestor value elements must have a level attribute");
                }
                String name = attributes.getValue(NAMESPACE, "name");
                if (name == null) {
                    SQLTransformer.throwIllegalStateException("Ancestor value elements must have a name attribute");
                }
                AncestorValue av = new AncestorValue(level, name);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("ANCESTOR VALUE " + level + " " + name);
                }
                if ((value = this.endSerializedXMLRecording()).length() > 0) {
                    this.getCurrentQuery().addQueryPart(value);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("QUERY IS \"" + value + "\"");
                    }
                }
                this.getCurrentQuery().addQueryPart(av);
                this.startSerializedXMLRecording(this.format);
                this.current_state = 4;
                break;
            }
            default: {
                SQLTransformer.throwIllegalStateException("Not expecting a start ancestor value element");
            }
        }
    }

    protected void endAncestorValueElement() {
        this.current_state = 3;
    }

    protected void startSubstituteValueElement(Attributes attributes) throws ProcessingException, SAXException {
        switch (this.current_state) {
            case 3: {
                String value;
                String name = attributes.getValue(NAMESPACE, "name");
                if (name == null) {
                    SQLTransformer.throwIllegalStateException("Substitute value elements must have a name attribute");
                }
                String substitute = this.parameters.getParameter(name, null);
                substitute = StringEscapeUtils.escapeSql((String)substitute);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("SUBSTITUTE VALUE " + substitute);
                }
                if ((value = this.endSerializedXMLRecording()).length() > 0) {
                    this.getCurrentQuery().addQueryPart(value);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("QUERY IS \"" + value + "\"");
                    }
                }
                this.getCurrentQuery().addQueryPart(substitute);
                this.startSerializedXMLRecording(this.format);
                this.current_state = 5;
                break;
            }
            default: {
                SQLTransformer.throwIllegalStateException("Not expecting a start substitute value element");
            }
        }
    }

    protected void endSubstituteValueElement() {
        this.current_state = 3;
    }

    protected void startEscapeStringElement(Attributes attributes) throws ProcessingException, SAXException {
        switch (this.current_state) {
            case 3: {
                String value = this.endSerializedXMLRecording();
                if (value.length() > 0) {
                    this.getCurrentQuery().addQueryPart(value);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("QUERY IS \"" + value + "\"");
                    }
                }
                this.startTextRecording();
                this.current_state = 8;
                break;
            }
            default: {
                SQLTransformer.throwIllegalStateException("Not expecting a start escape-string element");
            }
        }
    }

    protected void endEscapeStringElement() throws SAXException {
        switch (this.current_state) {
            case 8: {
                String value = this.endTextRecording();
                if (value.length() > 0) {
                    value = StringEscapeUtils.escapeSql((String)value);
                    value = StringUtils.replace((String)value, (String)"\\", (String)"\\\\");
                    this.getCurrentQuery().addQueryPart(value);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("QUERY IS \"" + value + "\"");
                    }
                }
                this.startSerializedXMLRecording(this.format);
                this.current_state = 3;
                break;
            }
            default: {
                SQLTransformer.throwIllegalStateException("Not expecting a end escape-string element");
            }
        }
    }

    protected void startInParameterElement(Attributes attributes) {
        switch (this.current_state) {
            case 1: {
                String nr = attributes.getValue(NAMESPACE, "nr");
                String value = attributes.getValue(NAMESPACE, "value");
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("IN PARAMETER NR " + nr + "; VALUE " + value);
                }
                int position = Integer.parseInt(nr);
                this.getCurrentQuery().setInParameter(position, value);
                this.current_state = 6;
                break;
            }
            default: {
                SQLTransformer.throwIllegalStateException("Not expecting an in-parameter element");
            }
        }
    }

    protected void endInParameterElement() {
        this.current_state = 1;
    }

    protected void startOutParameterElement(Attributes attributes) {
        switch (this.current_state) {
            case 1: {
                String name = attributes.getValue(NAMESPACE, "name");
                String nr = attributes.getValue(NAMESPACE, "nr");
                String type = attributes.getValue(NAMESPACE, MAGIC_OUT_PARAMETER_TYPE_ATTRIBUTE);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("OUT PARAMETER NAME" + name + ";NR " + nr + "; TYPE " + type);
                }
                int position = Integer.parseInt(nr);
                this.getCurrentQuery().setOutParameter(position, type, name);
                this.current_state = 7;
                break;
            }
            default: {
                SQLTransformer.throwIllegalStateException("Not expecting an out-parameter element");
            }
        }
    }

    protected void endOutParameterElement() {
        this.current_state = 1;
    }

    protected Query getCurrentQuery() {
        return (Query)this.queries.elementAt(this.current_query_index);
    }

    protected Query getQuery(int i) {
        return (Query)this.queries.elementAt(i);
    }

    protected String nsQualify(String name, String prefix) {
        if (StringUtils.isEmpty((String)name)) {
            return name;
        }
        if (StringUtils.isNotEmpty((String)prefix)) {
            return prefix + ":" + name;
        }
        return name;
    }

    public void setDocumentLocator(Locator locator) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("PUBLIC ID: " + locator.getPublicId());
            this.getLogger().debug("SYSTEM ID: " + locator.getSystemId());
        }
        super.setDocumentLocator(locator);
    }

    public void startTransformingElement(String uri, String name, String raw, Attributes attributes) throws ProcessingException, SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("RECEIVED START ELEMENT " + name);
        }
        if (name.equals(MAGIC_EXECUTE_QUERY)) {
            this.startExecuteQueryElement();
        } else if (name.equals(MAGIC_QUERY)) {
            this.startQueryElement(attributes);
        } else if (name.equals(MAGIC_ANCESTOR_VALUE)) {
            this.startAncestorValueElement(attributes);
        } else if (name.equals(MAGIC_SUBSTITUTE_VALUE)) {
            this.startSubstituteValueElement(attributes);
        } else if (name.equals(MAGIC_IN_PARAMETER)) {
            this.startInParameterElement(attributes);
        } else if (name.equals(MAGIC_OUT_PARAMETER)) {
            this.startOutParameterElement(attributes);
        } else if (name.equals(MAGIC_ESCAPE_STRING)) {
            this.startEscapeStringElement(attributes);
        } else {
            this.startValueElement(name);
        }
    }

    public void endTransformingElement(String uri, String name, String raw) throws ProcessingException, IOException, SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("RECEIVED END ELEMENT " + name + "(" + uri + ")");
        }
        if (name.equals(MAGIC_EXECUTE_QUERY)) {
            this.endExecuteQueryElement();
        } else if (name.equals(MAGIC_QUERY)) {
            this.endQueryElement();
        } else if (name.equals(MAGIC_ANCESTOR_VALUE)) {
            this.endAncestorValueElement();
        } else if (name.equals(MAGIC_SUBSTITUTE_VALUE)) {
            this.endSubstituteValueElement();
        } else if (name.equals(MAGIC_IN_PARAMETER)) {
            this.endInParameterElement();
        } else if (name.equals(MAGIC_OUT_PARAMETER)) {
            this.endOutParameterElement();
        } else if (name.equals("value") || this.current_state == 2) {
            this.endValueElement();
        } else if (name.equals(MAGIC_ESCAPE_STRING)) {
            this.endEscapeStringElement();
        } else {
            super.endTransformingElement(uri, name, raw);
        }
    }

    protected void start(String name, AttributesImpl attr) throws SAXException {
        try {
            super.startTransformingElement(this.outUri, name, this.nsQualify(name, this.outPrefix), (Attributes)attr);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
        catch (ProcessingException pe) {
            throw new SAXException((Exception)((Object)pe));
        }
        attr.clear();
    }

    protected void end(String name) throws SAXException {
        try {
            super.endTransformingElement(this.outUri, name, this.nsQualify(name, this.outPrefix));
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
        catch (ProcessingException pe) {
            throw new SAXException((Exception)((Object)pe));
        }
    }

    protected void data(String data) throws SAXException {
        if (data != null) {
            super.characters(data.toCharArray(), 0, data.length());
        }
    }

    protected static String getStringValue(Object object) {
        if (object instanceof byte[]) {
            return new String((byte[])object);
        }
        if (object instanceof char[]) {
            return new String((char[])object);
        }
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public final Logger getTheLogger() {
        return this.getLogger();
    }

    private class AncestorValue {
        protected int level;
        protected String name;

        protected AncestorValue(int level, String name) {
            this.level = level;
            this.name = name;
        }
    }

    class Query {
        protected SQLTransformer transformer;
        protected int query_index;
        protected Parameters properties;
        protected String rowset_name;
        protected String row_name;
        protected String nr_of_rows = "nrofrows";
        protected String name_attribute = "name";
        protected Connection conn;
        protected PreparedStatement pst;
        protected CallableStatement cst;
        protected ResultSet rs = null;
        protected ResultSetMetaData md = null;
        protected boolean isupdate = false;
        protected boolean isstoredprocedure = false;
        protected String name = null;
        protected int rv = -1;
        protected Vector query_parts = new Vector();
        protected HashMap inParameters = null;
        protected HashMap outParameters = null;
        protected HashMap outParametersNames = null;
        protected String columnCase;

        protected Query(SQLTransformer transformer, int query_index) {
            this.transformer = transformer;
            this.query_index = query_index;
            this.properties = new Parameters();
            this.properties.merge(transformer.parameters);
        }

        protected void setParameter(String name, String value) {
            this.properties.setParameter(name, value);
        }

        protected void setUpdate(boolean flag) {
            this.isupdate = flag;
        }

        protected void setStoredProcedure(boolean flag) {
            this.isstoredprocedure = flag;
        }

        protected boolean isStoredProcedure() {
            return this.isstoredprocedure;
        }

        protected void setName(String name) {
            this.name = name;
        }

        protected String getName() {
            return this.name;
        }

        protected void setInParameter(int pos, String val) {
            if (this.inParameters == null) {
                this.inParameters = new HashMap();
            }
            this.inParameters.put(new Integer(pos), val);
        }

        protected void setOutParameter(int pos, String type, String name) {
            if (this.outParameters == null) {
                this.outParameters = new HashMap();
                this.outParametersNames = new HashMap();
            }
            this.outParameters.put(new Integer(pos), type);
            this.outParametersNames.put(new Integer(pos), name);
        }

        private void registerInParameters(PreparedStatement pst) throws SQLException {
            if (this.inParameters == null) {
                return;
            }
            Iterator itInKeys = this.inParameters.keySet().iterator();
            while (itInKeys.hasNext()) {
                Integer counter = (Integer)itInKeys.next();
                String value = (String)this.inParameters.get(counter);
                try {
                    pst.setObject(counter, value);
                }
                catch (SQLException e) {
                    this.transformer.getTheLogger().error("Caught a SQLException", (Throwable)e);
                    throw e;
                }
            }
        }

        private void registerOutParameters(CallableStatement cst) throws SQLException {
            if (this.outParameters == null) {
                return;
            }
            Iterator itOutKeys = this.outParameters.keySet().iterator();
            while (itOutKeys.hasNext()) {
                Integer counter = (Integer)itOutKeys.next();
                String type = (String)this.outParameters.get(counter);
                int index = type.lastIndexOf(".");
                if (index <= -1) {
                    this.transformer.getTheLogger().error("Invalid SQLType: " + type, null);
                    throw new SQLException("Invalid SQLType: " + type);
                }
                String className = type.substring(0, index);
                String fieldName = type.substring(index + 1, type.length());
                try {
                    Class<?> clss = Class.forName(className);
                    Field fld = clss.getField(fieldName);
                    cst.registerOutParameter((int)counter, fld.getInt(fieldName));
                }
                catch (Exception e) {
                    this.transformer.getTheLogger().error("Invalid SQLType: " + className + "." + fieldName, (Throwable)e);
                }
            }
        }

        protected void setConnection(Connection conn) {
            this.conn = conn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Connection getConnection() throws SQLException {
            Connection result = null;
            try {
                String connection = this.properties.getParameter(SQLTransformer.MAGIC_CONNECTION, null);
                if (connection != null) {
                    block14: {
                        if (this.transformer.dbSelector == null) {
                            this.transformer.getTheLogger().error("No DBSelector found, could not use connection: " + connection);
                            return result;
                        }
                        DataSourceComponent datasource = null;
                        try {
                            try {
                                datasource = (DataSourceComponent)this.transformer.dbSelector.select((Object)connection);
                                int i = 0;
                                while (i < this.transformer.connectAttempts && result == null) {
                                    try {
                                        result = datasource.getConnection();
                                    }
                                    catch (Exception e) {
                                        long waittime = this.transformer.connectWaittime;
                                        this.transformer.getTheLogger().debug("SQLTransformer$Query: could not acquire a Connection -- waiting " + waittime + " ms to try again.");
                                        try {
                                            Thread.sleep(waittime);
                                        }
                                        catch (InterruptedException ie) {
                                            // empty catch block
                                        }
                                    }
                                    ++i;
                                }
                            }
                            catch (ServiceException cme) {
                                this.transformer.getTheLogger().error("Could not use connection: " + connection, (Throwable)cme);
                                Object var10_14 = null;
                                if (datasource != null) {
                                    this.transformer.dbSelector.release((Object)datasource);
                                }
                                break block14;
                            }
                            Object var10_13 = null;
                            if (datasource == null) break block14;
                        }
                        catch (Throwable throwable) {
                            Object var10_15 = null;
                            if (datasource == null) throw throwable;
                            this.transformer.dbSelector.release((Object)datasource);
                            throw throwable;
                        }
                        this.transformer.dbSelector.release((Object)datasource);
                    }
                    if (result != null) return result;
                    throw new SQLException("Failed to obtain connection. Made " + this.transformer.connectAttempts + " attempts with " + this.transformer.connectWaittime + "ms interval");
                }
                String dburl = this.properties.getParameter(SQLTransformer.MAGIC_DBURL, null);
                String username = this.properties.getParameter(SQLTransformer.MAGIC_USERNAME, null);
                String password = this.properties.getParameter(SQLTransformer.MAGIC_PASSWORD, null);
                if (username == null) return DriverManager.getConnection(dburl);
                if (password == null) return DriverManager.getConnection(dburl);
                return DriverManager.getConnection(dburl, username, password);
            }
            catch (SQLException e) {
                this.transformer.getTheLogger().error("Caught a SQLException", (Throwable)e);
                throw e;
            }
        }

        protected void execute() throws SQLException {
            if (this.conn == null) {
                throw new SQLException("A connection must be set before executing a query");
            }
            this.rowset_name = this.properties.getParameter(SQLTransformer.MAGIC_DOC_ELEMENT, "rowset");
            this.row_name = this.properties.getParameter(SQLTransformer.MAGIC_ROW_ELEMENT, "row");
            this.columnCase = this.properties.getParameter(SQLTransformer.MAGIC_COLUMN_CASE, "lowercase");
            Enumeration enumeration = this.query_parts.elements();
            StringBuffer sb = new StringBuffer();
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                if (object instanceof String) {
                    sb.append((String)object);
                    continue;
                }
                if (!(object instanceof AncestorValue)) continue;
                AncestorValue av = (AncestorValue)object;
                Query query = this.transformer.getQuery(this.query_index - av.level);
                sb.append(query.getColumnValue(av.name));
            }
            String query = StringUtils.replace((String)sb.toString().trim(), (String)"\r", (String)" ", (int)-1);
            if (!(this.isstoredprocedure || this.isupdate || query.length() <= 6 || query.substring(0, 6).equalsIgnoreCase("SELECT"))) {
                this.isupdate = true;
            }
            if (this.transformer.getTheLogger().isDebugEnabled()) {
                this.transformer.getTheLogger().debug("EXECUTING " + query);
            }
            try {
                block12: {
                    try {
                        if (!this.isstoredprocedure) {
                            this.pst = SQLTransformer.this.oldDriver ? this.conn.prepareStatement(query) : this.conn.prepareStatement(query, 1004, 1007);
                        } else {
                            this.cst = SQLTransformer.this.oldDriver ? this.conn.prepareCall(query) : this.conn.prepareCall(query, 1004, 1007);
                            this.registerOutParameters(this.cst);
                            this.pst = this.cst;
                        }
                        this.registerInParameters(this.pst);
                        boolean result = this.pst.execute();
                        if (result) {
                            this.rs = this.pst.getResultSet();
                            this.md = this.rs.getMetaData();
                            break block12;
                        }
                        this.rv = this.pst.getUpdateCount();
                    }
                    catch (SQLException e) {
                        this.transformer.getTheLogger().error("Caught a SQLException", (Throwable)e);
                        throw e;
                    }
                }
                Object var7_8 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                throw throwable;
            }
        }

        protected int getNrOfRows() throws SQLException {
            int nr = 0;
            if (this.rs != null) {
                if (SQLTransformer.this.oldDriver) {
                    nr = -1;
                } else {
                    try {
                        this.rs.last();
                        nr = this.rs.getRow();
                        this.rs.beforeFirst();
                    }
                    catch (NullPointerException e) {
                        SQLTransformer.this.getTheLogger().error("NPE while getting the nr of rows", (Throwable)e);
                    }
                }
            } else if (this.outParameters != null) {
                nr = this.outParameters.size();
            }
            return nr;
        }

        protected String getColumnValue(int i) throws SQLException {
            int numberOfChar = 1024;
            String retval = SQLTransformer.getStringValue(this.rs.getObject(i));
            if (this.rs.getMetaData().getColumnType(i) == 8) {
                retval = SQLTransformer.getStringValue(this.rs.getBigDecimal(i));
            } else if (this.rs.getMetaData().getColumnType(i) == 2005) {
                Clob clob = this.rs.getClob(i);
                InputStream inputStream = clob.getAsciiStream();
                byte[] readByte = new byte[numberOfChar];
                StringBuffer buffer = new StringBuffer();
                try {
                    while (inputStream.read(readByte) > -1) {
                        String string = new String(readByte, SQLTransformer.this.clobEncoding);
                        buffer.append(string);
                    }
                }
                catch (IOException ioException) {
                    throw new SQLException("Error reading stream from CLOB");
                }
                retval = buffer.toString();
            }
            return retval;
        }

        protected String getColumnValue(String name) throws SQLException {
            String retval = SQLTransformer.getStringValue(this.rs.getObject(name));
            return retval;
        }

        protected boolean next() throws SQLException {
            if (this.rv != -1) {
                return false;
            }
            try {
                if (this.rs == null || !this.rs.next()) {
                    return false;
                }
            }
            catch (NullPointerException e) {
                SQLTransformer.this.getTheLogger().debug("NullPointerException, returning false.", (Throwable)e);
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void close() throws SQLException {
            try {
                if (this.rs != null) {
                    try {
                        this.rs.close();
                        this.rs = null;
                    }
                    catch (NullPointerException e) {
                        SQLTransformer.this.getTheLogger().debug("NullPointer while closing the resultset.", (Throwable)e);
                    }
                }
                if (this.pst != null) {
                    this.pst.close();
                }
                this.pst = null;
                if (this.cst != null) {
                    this.cst.close();
                }
                this.cst = null;
                Object var3_2 = null;
                this.conn = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.conn = null;
                throw throwable;
            }
        }

        protected void addQueryPart(Object object) {
            this.query_parts.addElement(object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void serializeData(ServiceManager manager, String value) throws SQLException, SAXException {
            if (value != null) {
                if ((value = value.trim()).length() > 0 && value.charAt(0) == '<') {
                    try {
                        String stripped = value;
                        if (stripped.startsWith("<?xml ")) {
                            stripped = stripped.substring(stripped.indexOf("?>") + 2);
                        }
                        if (this.transformer.parser == null) {
                            this.transformer.parser = (SAXParser)manager.lookup(SAXParser.ROLE);
                        }
                        if (this.transformer.compiler == null) {
                            this.transformer.compiler = (XMLSerializer)manager.lookup(XMLSerializer.ROLE);
                        }
                        if (this.transformer.interpreter == null) {
                            this.transformer.interpreter = (XMLDeserializer)manager.lookup(XMLDeserializer.ROLE);
                        }
                        this.transformer.parser.parse(new InputSource(new StringReader("<root>" + stripped + "</root>")), (ContentHandler)this.transformer.compiler);
                        IncludeXMLConsumer filter = new IncludeXMLConsumer((ContentHandler)((Object)this.transformer), (LexicalHandler)((Object)this.transformer));
                        filter.setIgnoreRootElement(true);
                        this.transformer.interpreter.setConsumer((XMLConsumer)filter);
                        this.transformer.interpreter.deserialize(this.transformer.compiler.getSAXFragment());
                    }
                    catch (Exception local) {
                        this.transformer.data(value);
                    }
                    finally {
                        if (this.transformer.compiler != null) {
                            manager.release((Object)this.transformer.compiler);
                            this.transformer.compiler = null;
                        }
                    }
                } else {
                    this.transformer.data(value);
                }
            }
        }

        protected void serializeRow(ServiceManager manager) throws SQLException, SAXException {
            AttributesImpl attr = new AttributesImpl();
            if (!this.isupdate && !this.isstoredprocedure) {
                int i = 1;
                while (i <= this.md.getColumnCount()) {
                    String columnName = this.getColumnName(this.md.getColumnName(i));
                    this.transformer.start(columnName, attr);
                    this.serializeData(manager, this.getColumnValue(i));
                    this.transformer.end(columnName);
                    ++i;
                }
            } else if (this.isupdate && !this.isstoredprocedure) {
                this.transformer.start("returncode", attr);
                this.serializeData(manager, String.valueOf(this.rv));
                this.transformer.end("returncode");
                this.rv = -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void serializeStoredProcedure(ServiceManager manager) throws SQLException, SAXException {
            if (this.outParametersNames == null || this.cst == null) {
                return;
            }
            Iterator itOutKeys = new TreeMap(this.outParameters).keySet().iterator();
            AttributesImpl attr = new AttributesImpl();
            while (true) {
                if (!itOutKeys.hasNext()) return;
                Integer counter = (Integer)itOutKeys.next();
                try {
                    Object var11_11;
                    Object obj;
                    if (this.cst == null) {
                        SQLTransformer.this.getTheLogger().debug("SQLTransformer: cst is null");
                    }
                    if (counter == null) {
                        SQLTransformer.this.getTheLogger().debug(" SQLTransformer: counter is null");
                    }
                    if (!((obj = this.cst.getObject(counter)) instanceof ResultSet)) {
                        this.transformer.start((String)this.outParametersNames.get(counter), attr);
                        this.serializeData(manager, SQLTransformer.getStringValue(obj));
                        this.transformer.end((String)this.outParametersNames.get(counter));
                        continue;
                    }
                    ResultSet rs = (ResultSet)obj;
                    try {
                        this.transformer.start((String)this.outParametersNames.get(counter), attr);
                        ResultSetMetaData md = rs.getMetaData();
                        while (rs.next()) {
                            this.transformer.start(this.row_name, attr);
                            int i = 1;
                            while (i <= md.getColumnCount()) {
                                String columnName = this.getColumnName(md.getColumnName(i));
                                this.transformer.start(columnName, attr);
                                if (md.getColumnType(i) == 8) {
                                    this.serializeData(manager, SQLTransformer.getStringValue(rs.getBigDecimal(i)));
                                } else {
                                    this.serializeData(manager, SQLTransformer.getStringValue(rs.getObject(i)));
                                }
                                this.transformer.end(columnName);
                                ++i;
                            }
                            this.transformer.end(this.row_name);
                        }
                        var11_11 = null;
                    }
                    catch (Throwable throwable) {
                        var11_11 = null;
                        rs.close();
                        rs = null;
                        throw throwable;
                    }
                    rs.close();
                    rs = null;
                    this.transformer.end((String)this.outParametersNames.get(counter));
                }
                catch (SQLException e) {
                    this.transformer.getTheLogger().error("Caught a SQLException", (Throwable)e);
                    throw e;
                }
                continue;
                break;
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                throw throwable;
            }
        }

        private String getColumnName(String tempColumnName) {
            if (this.columnCase.equals("lowercase")) {
                tempColumnName = tempColumnName.toLowerCase();
            } else if (this.columnCase.equals("uppercase")) {
                tempColumnName = tempColumnName.toUpperCase();
            } else if (!this.columnCase.equals("preserve")) {
                SQLTransformer.this.getTheLogger().warn("[" + this.columnCase + "] is not a valid value for <column-case>. " + "Column name retrieved from database will be used.");
            }
            return tempColumnName;
        }
    }
}

