/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.sax.XMLSerializer;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.apache.excalibur.store.Store;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FragmentExtractorTransformer
extends AbstractTransformer
implements CacheableProcessingComponent,
Configurable,
Serviceable,
Disposable,
Recyclable {
    public static final String FE_URI = "http://apache.org/cocoon/fragmentextractor/2.0";
    private static final String EXTRACT_URI_NAME = "extract-uri";
    private static final String EXTRACT_ELEMENT_NAME = "extract-element";
    private static final String EXTRACT_URI = "http://www.w3.org/2000/svg";
    private static final String EXTRACT_ELEMENT = "svg";
    private String extractURI;
    private String extractElement;
    protected ServiceManager manager;
    private XMLSerializer serializer;
    private Map prefixMap;
    private int extractLevel;
    private int fragmentID;
    private String requestURI;

    public void configure(Configuration conf) throws ConfigurationException {
        this.extractURI = conf.getChild(EXTRACT_URI_NAME).getValue(EXTRACT_URI);
        this.extractElement = conf.getChild(EXTRACT_ELEMENT_NAME).getValue(EXTRACT_ELEMENT);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Extraction URI is " + this.extractURI);
            this.getLogger().debug("Extraction element is " + this.extractElement);
        }
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void recycle() {
        if (this.manager != null) {
            this.manager.release((Object)this.serializer);
            this.serializer = null;
        }
        super.recycle();
    }

    public void dispose() {
        this.recycle();
        this.manager = null;
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        this.extractLevel = 0;
        this.fragmentID = 0;
        this.prefixMap = new HashMap();
        this.requestURI = ObjectModelHelper.getRequest((Map)objectModel).getSitemapURI();
    }

    public Serializable getKey() {
        return "1";
    }

    public SourceValidity getValidity() {
        return NOPValidity.SHARED_INSTANCE;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.extractLevel == 0) {
            super.startPrefixMapping(prefix, uri);
            this.prefixMap.put(prefix, uri);
        } else {
            this.serializer.startPrefixMapping(prefix, uri);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.extractLevel == 0) {
            super.endPrefixMapping(prefix);
            this.prefixMap.remove(prefix);
        } else {
            this.serializer.endPrefixMapping(prefix);
        }
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        if (this.extractURI.equals(uri) && this.extractElement.equals(loc)) {
            ++this.extractLevel;
            ++this.fragmentID;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("extractLevel now " + this.extractLevel + ".");
            }
            try {
                this.serializer = (XMLSerializer)this.manager.lookup(XMLSerializer.ROLE);
            }
            catch (ServiceException se) {
                throw new SAXException("Could not lookup for XMLSerializer.", (Exception)((Object)se));
            }
            this.serializer.startDocument();
            Iterator itt = this.prefixMap.entrySet().iterator();
            while (itt.hasNext()) {
                Map.Entry entry = itt.next();
                this.serializer.startPrefixMapping((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.extractLevel == 0) {
            super.startElement(uri, loc, raw, a);
        } else {
            this.serializer.startElement(uri, loc, raw, a);
        }
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        if (this.extractLevel == 0) {
            super.endElement(uri, loc, raw);
        } else {
            this.serializer.endElement(uri, loc, raw);
            if (this.extractURI.equals(uri) && this.extractElement.equals(loc)) {
                --this.extractLevel;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("extractLevel now " + this.extractLevel + ".");
                }
                if (this.extractLevel == 0) {
                    Iterator itt = this.prefixMap.entrySet().iterator();
                    while (itt.hasNext()) {
                        Map.Entry entry = itt.next();
                        this.serializer.endPrefixMapping((String)entry.getKey());
                    }
                    this.serializer.endDocument();
                    Store store = null;
                    String id = Long.toHexString(((long)((Object)((Object)this)).hashCode() ^ HashUtil.hash((String)this.requestURI)) + (long)this.fragmentID);
                    try {
                        store = (Store)this.manager.lookup(Store.TRANSIENT_STORE);
                        store.store((Object)id, this.serializer.getSAXFragment());
                    }
                    catch (ServiceException se) {
                        throw new SAXException("Could not lookup for transient store.", (Exception)((Object)se));
                    }
                    catch (IOException ioe) {
                        throw new SAXException("Could not store fragment.", ioe);
                    }
                    finally {
                        this.manager.release((Object)store);
                        this.manager.release((Object)this.serializer);
                        this.serializer = null;
                    }
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Stored document " + id + ".");
                    }
                    super.startPrefixMapping("fe", FE_URI);
                    AttributesImpl atts = new AttributesImpl();
                    atts.addAttribute("", "fragment-id", "fragment-id", "CDATA", id);
                    super.startElement(FE_URI, "fragment", "fe:fragment", (Attributes)atts);
                    super.endElement(FE_URI, "fragment", "fe:fragment");
                    super.endPrefixMapping("fe");
                }
            }
        }
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        if (this.extractLevel == 0) {
            super.characters(c, start, len);
        } else {
            this.serializer.characters(c, start, len);
        }
    }

    public void ignorableWhitespace(char[] c, int start, int len) throws SAXException {
        if (this.extractLevel == 0) {
            super.ignorableWhitespace(c, start, len);
        } else {
            this.serializer.ignorableWhitespace(c, start, len);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.extractLevel == 0) {
            super.processingInstruction(target, data);
        } else {
            this.serializer.processingInstruction(target, data);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        if (this.extractLevel == 0) {
            super.skippedEntity(name);
        } else {
            this.serializer.skippedEntity(name);
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.extractLevel != 0) {
            throw new SAXException("Recieved startDTD after beginning fragment extraction process.");
        }
        super.startDTD(name, publicId, systemId);
    }

    public void endDTD() throws SAXException {
        if (this.extractLevel != 0) {
            throw new SAXException("Recieved endDTD after beginning fragment extraction process.");
        }
        super.endDTD();
    }

    public void startEntity(String name) throws SAXException {
        if (this.extractLevel == 0) {
            super.startEntity(name);
        } else {
            this.serializer.startEntity(name);
        }
    }

    public void endEntity(String name) throws SAXException {
        if (this.extractLevel == 0) {
            super.endEntity(name);
        } else {
            this.serializer.endEntity(name);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.extractLevel == 0) {
            super.startCDATA();
        } else {
            this.serializer.startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        if (this.extractLevel == 0) {
            super.endCDATA();
        } else {
            this.serializer.endCDATA();
        }
    }

    public void comment(char[] ch, int start, int len) throws SAXException {
        if (this.extractLevel == 0) {
            super.comment(ch, start, len);
        } else {
            this.serializer.comment(ch, start, len);
        }
    }
}

