/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.modules.input.AbstractMetaModule;
import org.apache.cocoon.components.modules.input.ModuleHolder;

public class SelectMetaInputModule
extends AbstractMetaModule
implements ThreadSafe {
    private Map whenTest = null;
    private ModuleHolder expression = null;
    private ModuleHolder otherwise = null;
    private String parameter = null;

    public SelectMetaInputModule() {
        this.defaultInput = null;
    }

    public void configure(Configuration config) throws ConfigurationException {
        String name;
        Configuration[] expr = config.getChildren("input-module");
        if (expr == null || expr.length != 1) {
            throw new ConfigurationException("Need to have exactly one input-module element.");
        }
        this.parameter = config.getChild("parameter").getValue();
        Configuration[] whens = config.getChildren("when");
        Configuration[] others = config.getChildren("otherwise");
        if (whens == null && others == null || (whens == null || whens.length == 0) && (others == null || others.length == 0)) {
            throw new ConfigurationException("Need to have at least one when or otherwise element.");
        }
        if (others != null && others.length > 1) {
            throw new ConfigurationException("Need to have at most one otherwise element.");
        }
        this.whenTest = new TreeMap();
        int i = 0;
        while (i < expr.length) {
            String name2 = expr[i].getAttribute("name");
            this.expression = new ModuleHolder(name2, expr[i], null);
            ++i;
        }
        if (others != null) {
            int i2 = 0;
            while (i2 < others.length) {
                name = others[i2].getAttribute("name");
                this.otherwise = new ModuleHolder(name, others[i2], null);
                ++i2;
            }
        }
        if (whens != null) {
            int i3 = 0;
            while (i3 < whens.length) {
                name = whens[i3].getAttribute("name");
                this.whenTest.put(whens[i3].getAttribute("test"), new ModuleHolder(name, whens[i3], null));
                ++i3;
            }
        }
    }

    public Object getAttribute(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        Object result = this.getAttribute(name, modeConf, objectModel, false);
        return result;
    }

    public Object[] getAttributeValues(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        Object result = this.getAttribute(name, modeConf, objectModel, true);
        return result != null ? (Object[])result : null;
    }

    private Object getAttribute(String name, Configuration modeConf, Map objectModel, boolean getValues) throws ConfigurationException {
        Object[] result;
        boolean dynamicConfig;
        if (!this.initialized) {
            this.lazy_initialize();
        }
        ModuleHolder expression = this.expression;
        ModuleHolder otherwise = this.otherwise;
        ModuleHolder module = null;
        String parameter = this.parameter;
        boolean needRelease = false;
        boolean bl = dynamicConfig = modeConf != null && modeConf.getChildren().length > 0;
        if (dynamicConfig) {
            expression = null;
            otherwise = null;
            needRelease = true;
            Configuration[] expr = modeConf.getChildren("input-module");
            Configuration[] other = modeConf.getChildren("otherwise");
            if (expr != null && expr.length == 1) {
                expression = new ModuleHolder(expr[0].getAttribute("name"), expr[0]);
            }
            if (other != null && other.length == 1) {
                otherwise = new ModuleHolder(other[0].getAttribute("name"), other[0]);
            }
            parameter = modeConf.getChild("parameter").getValue();
        }
        String value = (String)this.getValue(parameter, objectModel, expression.input, expression.name, expression.config);
        if (needRelease) {
            this.releaseModule(expression.input);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((dynamicConfig ? "(dyn)" : "(static)") + " select (" + value + ") from " + expression.name + ":" + parameter);
        }
        if (dynamicConfig && value != null) {
            Configuration[] whens = modeConf.getChildren("when");
            if (whens != null && whens.length > 0) {
                int i = 0;
                boolean found = false;
                while (!found && i < whens.length) {
                    if (whens[i].getAttribute("test").equals(value)) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (found) {
                    module = new ModuleHolder(whens[i].getAttribute("name"), whens[i]);
                }
            }
        } else if (value != null) {
            module = (ModuleHolder)this.whenTest.get(value);
        }
        if (module != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("found matching when : " + module.name);
            }
        } else {
            module = otherwise;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("using otherwise : " + module.name);
            }
        }
        if (getValues) {
            result = module == null ? null : this.getValues(name, objectModel, module);
        } else {
            Object object = result = module == null ? null : this.getValue(name, objectModel, module);
        }
        if (needRelease && module != null) {
            this.releaseModule(module.input);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Obtained value : " + result);
        }
        return result;
    }

    public void compose(ComponentManager manager) throws ComponentException {
        super.compose(manager);
    }

    public void dispose() {
        this.releaseModule(this.expression.input);
        this.expression = null;
        if (this.otherwise != null) {
            this.releaseModule(this.otherwise.input);
            this.otherwise = null;
        }
        Iterator i = this.whenTest.values().iterator();
        while (i.hasNext()) {
            ModuleHolder holder = (ModuleHolder)i.next();
            this.releaseModule(holder.input);
        }
        this.whenTest = null;
        super.dispose();
    }

    public synchronized void lazy_initialize() {
        if (this.initialized) {
            return;
        }
        super.lazy_initialize();
        if (this.expression != null) {
            this.expression.input = this.obtainModule(this.expression.name);
        }
        if (this.otherwise != null) {
            this.otherwise.input = this.obtainModule(this.otherwise.name);
        }
        if (this.whenTest != null) {
            Iterator i = this.whenTest.values().iterator();
            while (i.hasNext()) {
                ModuleHolder moduleHolder = (ModuleHolder)i.next();
                moduleHolder.input = this.obtainModule(moduleHolder.name);
            }
        }
    }
}

