/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.modules.input.AbstractJXPathModule;
import org.apache.cocoon.components.modules.input.JXPathHelper;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.w3c.dom.Document;

public class XMLFileModule
extends AbstractJXPathModule
implements Composable,
ThreadSafe {
    String staticConfLocation;
    Map documents = null;
    boolean reloadAll = false;
    boolean cacheAll = true;
    boolean cacheExpressions = true;
    String src = null;
    SourceResolver resolver = null;
    ComponentManager manager = null;
    private Map expressionCache;
    private Map expressionValuesCache;

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        this.resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    public void dispose() {
        super.dispose();
        if (this.manager != null) {
            this.manager.release((Component)this.resolver);
            this.manager = null;
            this.resolver = null;
        }
    }

    public void configure(Configuration config) throws ConfigurationException {
        this.staticConfLocation = config.getLocation();
        super.configure(config);
        this.reloadAll = config.getChild("reloadable").getValueAsBoolean(this.reloadAll);
        if (config.getChild("cachable", false) != null) {
            throw new ConfigurationException("Bzzt! Wrong spelling at " + config.getChild("cachable").getLocation() + ": please use 'cacheable', not 'cachable'");
        }
        this.cacheAll = config.getChild("cacheable").getValueAsBoolean(this.cacheAll);
        Configuration[] files = config.getChildren("file");
        if (this.documents == null) {
            this.documents = Collections.synchronizedMap(new HashMap());
        }
        int i = 0;
        while (i < files.length) {
            boolean reload = files[i].getAttributeAsBoolean("reloadable", this.reloadAll);
            boolean cache = files[i].getAttributeAsBoolean("cacheable", this.cacheAll);
            this.src = files[i].getAttribute("src");
            this.documents.put(files[i], new DocumentHelper(reload, cache, this.src));
            ++i;
        }
        this.expressionCache = Collections.synchronizedMap(new ReferenceMap(1, 1));
        this.expressionValuesCache = Collections.synchronizedMap(new ReferenceMap(1, 1));
    }

    protected Object getContextObject(Configuration modeConf, Map objectModel) throws ConfigurationException {
        String src = this.src;
        boolean reload = this.reloadAll;
        boolean cache = this.cacheAll;
        boolean hasDynamicConf = false;
        Configuration fileConf = null;
        if (modeConf != null && modeConf.getChildren().length > 0) {
            fileConf = modeConf.getChild("file", false);
            if (fileConf == null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Missing 'file' child element at " + modeConf.getLocation());
                }
            } else {
                hasDynamicConf = true;
            }
        }
        if (hasDynamicConf) {
            src = fileConf.getAttribute("src");
        }
        if (this.documents == null) {
            this.documents = Collections.synchronizedMap(new HashMap());
        }
        if (src == null) {
            throw new ConfigurationException("No source specified" + (modeConf != null ? ", either dynamically in " + modeConf.getLocation() + ", or " : "") + " statically in " + this.staticConfLocation);
        }
        if (!this.documents.containsKey(src)) {
            if (hasDynamicConf) {
                reload = fileConf.getAttributeAsBoolean("reloadable", reload);
                cache = fileConf.getAttributeAsBoolean("cacheable", cache);
                if (fileConf.getAttribute("cachable", null) != null) {
                    throw new ConfigurationException("Bzzt! Wrong spelling at " + fileConf.getLocation() + ": please use 'cacheable', not 'cachable'");
                }
            }
            this.documents.put(src, new DocumentHelper(reload, cache, src));
        }
        Document dom = null;
        try {
            dom = ((DocumentHelper)this.documents.get(src)).getDocument(this.manager, this.resolver, this.getLogger());
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Error using source " + src + "\n" + e.getMessage(), (Throwable)e);
            }
            throw new ConfigurationException("Error using source " + src, (Throwable)e);
        }
        return dom;
    }

    public Object getAttribute(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        return this.getAttribute(name, modeConf, objectModel, false);
    }

    public Object[] getAttributeValues(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        Object result = this.getAttribute(name, modeConf, objectModel, true);
        return result != null ? (Object[])result : null;
    }

    public Object getAttribute(String name, Configuration modeConf, Map objectModel, boolean getValues) throws ConfigurationException {
        Object contextObj = this.getContextObject(modeConf, objectModel);
        if (modeConf != null) {
            name = modeConf.getChild("parameter").getValue(this.parameter != null ? this.parameter : name);
        }
        Object result = null;
        Map cache = null;
        boolean hasBeenCached = false;
        if (this.cacheExpressions && (hasBeenCached = (cache = getValues ? this.getValuesCache(contextObj) : this.getCache(contextObj)).containsKey(name))) {
            result = cache.get(name);
        }
        if (!hasBeenCached) {
            result = getValues ? JXPathHelper.getAttributeValues(name, modeConf, this.configuration, contextObj) : JXPathHelper.getAttribute(name, modeConf, this.configuration, contextObj);
            if (this.cacheExpressions) {
                cache.put(name, result);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("for " + name + " newly caching result " + result);
                }
            } else if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("for " + name + " result is " + result);
            }
        } else if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("for " + name + " using cached result " + result);
        }
        return result;
    }

    private Map getCache(Object key) {
        Map cache = (Map)this.expressionCache.get(key);
        if (cache == null) {
            cache = this.initSubExpressionCache(key);
        }
        return cache;
    }

    private Map getValuesCache(Object key) {
        Map cache = (Map)this.expressionValuesCache.get(key);
        if (cache == null) {
            cache = this.initSubExpressionCache(key);
        }
        return cache;
    }

    private synchronized Map initSubExpressionCache(Object key) {
        Map cache = (Map)this.expressionCache.get(key);
        if (cache == null) {
            cache = Collections.synchronizedMap(new HashMap());
            this.expressionCache.put(key, cache);
        }
        return cache;
    }

    protected class DocumentHelper {
        private boolean reloadable = true;
        private boolean cacheable = true;
        private String uri = null;
        private Document document = null;
        private SourceValidity srcVal = null;

        public DocumentHelper(boolean reload, boolean cache, String src) {
            this.reloadable = reload;
            this.cacheable = cache;
            this.uri = src;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Document getDocument(ComponentManager manager, SourceResolver resolver, Logger logger) throws Exception {
            Source src = null;
            Document dom = null;
            try {
                if (this.document == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Document not cached... reloading uri " + this.uri);
                    }
                    src = resolver.resolveURI(this.uri);
                    this.srcVal = src.getValidity();
                    dom = this.document = SourceUtil.toDOM(src);
                } else {
                    if (this.reloadable) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Document cached... checking validity of uri " + this.uri);
                        }
                        src = resolver.resolveURI(this.uri);
                        SourceValidity valid = src.getValidity();
                        if (this.srcVal != null && this.srcVal.isValid(valid) != 1) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("reloading document... uri " + this.uri);
                            }
                            this.srcVal = valid;
                            this.document = SourceUtil.toDOM(src);
                        }
                    }
                    dom = this.document;
                }
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                resolver.release(src);
                throw throwable;
            }
            resolver.release(src);
            if (!this.cacheable) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Not caching document cached... uri " + this.uri);
                }
                this.srcVal = null;
                this.document = null;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Done with document... uri " + this.uri);
            }
            return dom;
        }
    }
}

