/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.cocoon.xml.dom.DOMBuilder;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class AbstractExtractionTransformer
extends AbstractTransformer {
    protected DOMBuilder currentBuilder;
    private Map prefixMap;
    protected int extractLevel;

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        this.extractLevel = 0;
        this.prefixMap = new HashMap();
    }

    public void recycle() {
        this.extractLevel = 0;
        this.currentBuilder = null;
        this.prefixMap = null;
        super.recycle();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.extractLevel == 0) {
            super.startPrefixMapping(prefix, uri);
            this.prefixMap.put(prefix, uri);
        } else {
            this.currentBuilder.startPrefixMapping(prefix, uri);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.extractLevel == 0) {
            super.endPrefixMapping(prefix);
            this.prefixMap.remove(prefix);
        } else {
            this.currentBuilder.endPrefixMapping(prefix);
        }
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        if (!this.startExtracting(uri, loc, raw, a)) {
            if (this.extractLevel == 0) {
                super.startElement(uri, loc, raw, a);
            } else {
                this.currentBuilder.startElement(uri, loc, raw, a);
            }
        } else {
            ++this.extractLevel;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("extractLevel now " + this.extractLevel + ".");
            }
            if (this.extractLevel != 1) {
                this.currentBuilder.startElement(uri, loc, raw, a);
            } else {
                this.currentBuilder = new DOMBuilder();
                this.currentBuilder.startDocument();
                Iterator itt = this.prefixMap.entrySet().iterator();
                while (itt.hasNext()) {
                    Map.Entry entry = itt.next();
                    this.currentBuilder.startPrefixMapping((String)entry.getKey(), (String)entry.getValue());
                }
                this.startExtractingDocument(uri, loc, raw, a);
            }
        }
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        if (this.extractLevel == 0) {
            super.endElement(uri, loc, raw);
        } else if (this.endExtracting(uri, loc, raw)) {
            --this.extractLevel;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("extractLevel now " + this.extractLevel + ".");
            }
            if (this.extractLevel != 0) {
                this.currentBuilder.endElement(uri, loc, raw);
            } else {
                this.endExtractingDocument(uri, loc, raw);
                Iterator itt = this.prefixMap.entrySet().iterator();
                while (itt.hasNext()) {
                    Map.Entry entry = itt.next();
                    this.currentBuilder.endPrefixMapping((String)entry.getKey());
                }
                this.currentBuilder.endDocument();
                this.handleExtractedDocument(this.currentBuilder.getDocument());
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Stored document.");
                }
            }
        } else {
            this.currentBuilder.endElement(uri, loc, raw);
        }
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        if (this.extractLevel == 0) {
            super.characters(c, start, len);
        } else {
            this.currentBuilder.characters(c, start, len);
        }
    }

    public void ignorableWhitespace(char[] c, int start, int len) throws SAXException {
        if (this.extractLevel == 0) {
            super.ignorableWhitespace(c, start, len);
        } else {
            this.currentBuilder.ignorableWhitespace(c, start, len);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.extractLevel == 0) {
            super.processingInstruction(target, data);
        } else {
            this.currentBuilder.processingInstruction(target, data);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        if (this.extractLevel == 0) {
            super.skippedEntity(name);
        } else {
            this.currentBuilder.skippedEntity(name);
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.extractLevel != 0) {
            throw new SAXException("Recieved startDTD after beginning fragment extraction process.");
        }
        super.startDTD(name, publicId, systemId);
    }

    public void endDTD() throws SAXException {
        if (this.extractLevel != 0) {
            throw new SAXException("Recieved endDTD after beginning fragment extraction process.");
        }
        super.endDTD();
    }

    public void startEntity(String name) throws SAXException {
        if (this.extractLevel == 0) {
            super.startEntity(name);
        } else {
            this.currentBuilder.startEntity(name);
        }
    }

    public void endEntity(String name) throws SAXException {
        if (this.extractLevel == 0) {
            super.endEntity(name);
        } else {
            this.currentBuilder.endEntity(name);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.extractLevel == 0) {
            super.startCDATA();
        } else {
            this.currentBuilder.startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        if (this.extractLevel == 0) {
            super.endCDATA();
        } else {
            this.currentBuilder.endCDATA();
        }
    }

    public void comment(char[] ch, int start, int len) throws SAXException {
        if (this.extractLevel == 0) {
            super.comment(ch, start, len);
        } else {
            this.currentBuilder.comment(ch, start, len);
        }
    }

    abstract boolean startExtracting(String var1, String var2, String var3, Attributes var4);

    public void startExtractingDocument(String uri, String loc, String raw, Attributes a) throws SAXException {
        this.currentBuilder.startElement(uri, loc, raw, a);
    }

    abstract boolean endExtracting(String var1, String var2, String var3);

    public void endExtractingDocument(String uri, String loc, String raw) throws SAXException {
        this.currentBuilder.endElement(uri, loc, raw);
    }

    abstract void handleExtractedDocument(Document var1);
}

