/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation.pagination;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.cocoon.Modifiable;
import org.apache.cocoon.transformation.pagination.ItemGroup;
import org.apache.cocoon.transformation.pagination.PageRules;
import org.apache.cocoon.util.ResizableContainer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Pagesheet
extends DefaultHandler
implements Cloneable,
Modifiable {
    private int level = 0;
    private int pg = 0;
    private long lastModified;
    private PageRules rules;
    ResizableContainer pageRules;
    Map itemGroupsPerName;
    Map itemGroupsPerElement;
    Map itemListsPerName;
    Map itemListsPerElement;
    private ResizableContainer pages;
    private Page currentPage = null;
    private int pageCounter = 1;
    private int elementCounter = 0;
    private int descendant = 0;

    public Pagesheet() {
        this.pages = new ResizableContainer(2);
    }

    private Pagesheet(ResizableContainer rules, Map itemGroupsPerName, Map itemGroupsPerElement) {
        this.pageRules = rules;
        this.itemGroupsPerName = itemGroupsPerName;
        this.itemGroupsPerElement = itemGroupsPerElement;
        this.pages = new ResizableContainer(5);
        if (this.itemGroupsPerName != null && this.itemGroupsPerElement != null) {
            this.itemListsPerName = new HashMap(itemGroupsPerName.size());
            this.itemListsPerElement = new HashMap(itemGroupsPerName.size());
            Iterator iter = itemGroupsPerName.values().iterator();
            while (iter.hasNext()) {
                ItemGroup group = (ItemGroup)iter.next();
                ItemList list = new ItemList(10);
                this.itemListsPerName.put(group.getName(), list);
                this.itemListsPerElement.put(group.getElementURI() + group.getElementName(), list);
            }
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (!uri.equals("http://apache.org/cocoon/paginate/1.0")) {
            throw new SAXException("The pagesheet's namespace is not supported.");
        }
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        ++this.level;
        switch (this.level) {
            case 1: {
                if (!loc.equals("pagesheet")) break;
                return;
            }
            case 2: {
                if (loc.equals("rules")) {
                    String key;
                    if (this.pageRules == null) {
                        this.pageRules = new ResizableContainer(2);
                    }
                    if ((key = a.getValue("page")) != null) {
                        try {
                            this.pg = Integer.parseInt(key);
                        }
                        catch (NumberFormatException e) {
                            throw new SAXException("Syntax error: the attribute 'rules/@page' must contain a number");
                        }
                    } else {
                        this.pg = 0;
                    }
                    this.rules = new PageRules();
                    return;
                }
                if (!loc.equals("items")) break;
                if (this.itemGroupsPerName == null) {
                    this.itemGroupsPerName = new HashMap(2);
                }
                if (this.itemGroupsPerElement == null) {
                    this.itemGroupsPerElement = new HashMap(2);
                }
                return;
            }
            case 3: {
                if (loc.equals("count")) {
                    this.rules.elementName = a.getValue("name");
                    this.rules.elementURI = a.getValue("namespace");
                    if (a.getValue("type").equals("element")) {
                        try {
                            this.rules.elementCount = Integer.parseInt(a.getValue("num"));
                        }
                        catch (NumberFormatException e) {
                            throw new SAXException("Syntax error: the attribute 'count/@num' must contain a number");
                        }
                    } else if (a.getValue("type").equals("chars")) {
                        try {
                            this.rules.charCount = Integer.parseInt(a.getValue("num"));
                        }
                        catch (NumberFormatException e) {
                            throw new SAXException("Syntax error: the attribute 'count/@num' must contain a number.");
                        }
                    } else {
                        throw new SAXException("Syntax error: count type not supported.");
                    }
                    return;
                }
                if (loc.equals("link")) {
                    if (a.getValue("type").equals("unit")) {
                        try {
                            this.rules.unitLinks = Integer.parseInt(a.getValue("num"));
                        }
                        catch (NumberFormatException e) {
                            throw new SAXException("Syntax error: the attribute 'link/@num' must contain a number.");
                        }
                    } else if (a.getValue("type").equals("range")) {
                        try {
                            this.rules.addRangeLink(a.getValue("value"));
                        }
                        catch (NumberFormatException e) {
                            throw new SAXException("Syntax error: the attribute 'link/@value' must contain a number.");
                        }
                    } else {
                        throw new SAXException("Syntax error: link type not supported.");
                    }
                    return;
                }
                if (!loc.equals("group")) break;
                String name = a.getValue("name");
                if (name == null) {
                    throw new SAXException("Syntax error: the attribute 'group/@name' must be present.");
                }
                String elementName = a.getValue("element");
                if (elementName == null) {
                    throw new SAXException("Syntax error: the attribute 'group/@element' must be present.");
                }
                String elementURI = a.getValue("namespace");
                ItemGroup group = new ItemGroup(name, elementURI, elementName);
                this.itemGroupsPerName.put(name, group);
                this.itemGroupsPerElement.put(elementURI + elementName, group);
                return;
            }
        }
        throw new SAXException("Syntax error: element " + raw + " is not recognized or is misplaced.");
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        --this.level;
        if (loc.equals("rules")) {
            this.pageRules.set(this.pg, this.rules);
        }
    }

    public void endDocument() throws SAXException {
        if (this.pageRules.size() == 0) {
            throw new SAXException("Pagesheet must contain at least a set of pagination rules.");
        }
        if (this.pageRules.get(0) == null) {
            throw new SAXException("Pagesheet must contain the global pagination rules.");
        }
    }

    public void processStartElement(String uri, String name) {
        ItemList list;
        String qname;
        ItemGroup group;
        PageRules rules = this.getPageRules(this.pageCounter);
        if (rules.match(name, uri)) {
            ++this.elementCounter;
            ++this.descendant;
            if (this.currentPage == null) {
                this.currentPage = new Page(rules, 1);
            }
            if (this.elementCounter > this.currentPage.elementEnd) {
                ++this.pageCounter;
                this.currentPage = new Page(rules, this.currentPage.elementEnd + 1);
            }
            this.pages.set(this.pageCounter, this.currentPage);
        }
        if (this.itemGroupsPerElement != null && (group = (ItemGroup)this.itemGroupsPerElement.get(qname = uri + name)) != null && group.match(uri) && (list = (ItemList)this.itemListsPerElement.get(qname)) != null) {
            list.addItem(this.pageCounter);
        }
    }

    public void processEndElement(String uri, String name) {
        PageRules rules = this.getPageRules(this.pageCounter);
        if (rules.match(name, uri)) {
            --this.descendant;
            if (rules.charCount > 0 && this.currentPage.characters > rules.charCount) {
                this.currentPage.elementEnd = this.elementCounter;
            } else if (rules.elementCount == 0) {
                ++this.currentPage.elementEnd;
            }
        }
    }

    public void processCharacters(char[] ch, int index, int len) {
        if (this.descendant > 0) {
            this.currentPage.characters += len;
        }
    }

    public boolean isInPage(int page, int item, String itemGroup) {
        return this.descendant == 0 || this.valid(page, item, itemGroup);
    }

    public int getTotalPages() {
        return this.pageCounter;
    }

    public int getTotalItems(String itemGroup) {
        if (this.itemListsPerName == null) {
            return 0;
        }
        ItemList list = (ItemList)this.itemListsPerName.get(itemGroup);
        return list == null ? 0 : list.size();
    }

    public int getPageForItem(int item, String itemGroup) {
        if (this.itemListsPerName == null) {
            return 0;
        }
        ItemList list = (ItemList)this.itemListsPerName.get(itemGroup);
        return list == null ? 0 : list.getPageForItem(item);
    }

    public int itemCount(String elementURI, String elementName) {
        if (this.itemListsPerElement == null) {
            return 0;
        }
        ItemList list = (ItemList)this.itemListsPerElement.get(elementURI + elementName);
        return list == null ? 0 : list.size();
    }

    public String getItemGroupName(String elementURI, String elementName) {
        if (this.itemListsPerElement == null) {
            return null;
        }
        return ((ItemGroup)this.itemGroupsPerElement.get(elementURI + elementName)).getName();
    }

    private boolean valid(int page, int item, String itemGroup) {
        if (item == 0) {
            Page p = (Page)this.pages.get(page);
            return p != null && p.validInPage(this.elementCounter);
        }
        if (this.itemListsPerElement == null) {
            return false;
        }
        ItemList list = (ItemList)this.itemListsPerName.get(itemGroup);
        return list != null && list.valid(item);
    }

    public PageRules getPageRules(int page) {
        PageRules p = (PageRules)this.pageRules.get(page);
        return p != null ? p : (PageRules)this.pageRules.get(0);
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public boolean modifiedSince(long date) {
        return this.lastModified == 0L || date != this.lastModified;
    }

    public Object clone() {
        return new Pagesheet(this.pageRules, this.itemGroupsPerName, this.itemGroupsPerElement);
    }

    private static class ItemList
    extends ArrayList {
        public ItemList(int capacity) {
            super(capacity);
        }

        public void addItem(int page) {
            this.add(new Integer(page));
        }

        public int getPageForItem(int item) {
            Integer i = (Integer)this.get(item - 1);
            return i == null ? 0 : i;
        }

        public boolean valid(int item) {
            return item == this.size();
        }
    }

    private static class Page {
        public int elementStart;
        public int elementEnd;
        public int characters;

        public Page(PageRules rules, int elementStart) {
            this.elementStart = elementStart;
            this.elementEnd = rules.elementCount > 0 ? this.elementStart + rules.elementCount - 1 : this.elementStart + 1;
        }

        public boolean validInPage(int elementCounter) {
            return this.elementStart <= elementCounter && elementCounter <= this.elementEnd;
        }
    }
}

