/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.avalon.framework.CascadingThrowable;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log.ContextMap;
import org.apache.log.LogEvent;
import org.apache.log.format.Formatter;

public class XMLCocoonLogFormatter
implements Formatter {
    protected static final String TYPE_CLASS_STR = "class";
    protected static final String TYPE_CLASS_SHORT_STR = "short";
    protected static final int TYPE_REQUEST_URI = 0;
    protected static final int TYPE_CATEGORY = 1;
    protected static final int TYPE_MESSAGE = 2;
    protected static final int TYPE_TIME = 3;
    protected static final int TYPE_RELATIVE_TIME = 4;
    protected static final int TYPE_THROWABLE = 5;
    protected static final int TYPE_PRIORITY = 6;
    protected static final int TYPE_CLASS = 7;
    protected static final int TYPE_CLASS_SHORT = 8;
    protected static final int TYPE_THREAD = 9;
    protected static final int TYPE_HOST = 10;
    public static final String[] typeStrings = new String[]{"uri", "category", "message", "time", "rtime", "throwable", "priority", "class", "class:short", "thread", "host"};
    protected final SimpleDateFormat dateFormatter = new SimpleDateFormat("(yyyy-MM-dd) HH:mm.ss:SSS");
    protected int[] types;
    private Class loggerClass = class$org$apache$log$Logger == null ? (class$org$apache$log$Logger = XMLCocoonLogFormatter.class$("org.apache.log.Logger")) : class$org$apache$log$Logger;
    private CallStack callStack = new CallStack();
    static /* synthetic */ Class class$org$apache$log$Logger;

    public String format(LogEvent event) {
        StringBuffer sb = new StringBuffer();
        sb.append("<log-entry>").append(SystemUtils.LINE_SEPARATOR);
        String value = this.getRequestId(event.getContextMap());
        if (value != null) {
            sb.append("<request-id>").append(value).append("</request-id>").append(SystemUtils.LINE_SEPARATOR);
        }
        int i = 0;
        while (i < this.types.length) {
            switch (this.types[i]) {
                case 0: {
                    sb.append("<uri>");
                    sb.append(this.getURI(event.getContextMap()));
                    sb.append("</uri>").append(SystemUtils.LINE_SEPARATOR);
                    break;
                }
                case 7: {
                    sb.append("<class>");
                    sb.append(this.getClass(7));
                    sb.append("</class>").append(SystemUtils.LINE_SEPARATOR);
                    break;
                }
                case 8: {
                    sb.append("<class>");
                    sb.append(this.getClass(8));
                    sb.append("</class>").append(SystemUtils.LINE_SEPARATOR);
                    break;
                }
                case 9: {
                    sb.append("<thread>");
                    sb.append(this.getThread(event.getContextMap()));
                    sb.append("</thread>").append(SystemUtils.LINE_SEPARATOR);
                    break;
                }
                case 4: {
                    sb.append("<relative-time>");
                    sb.append(event.getRelativeTime());
                    sb.append("</relative-time>").append(SystemUtils.LINE_SEPARATOR);
                    break;
                }
                case 3: {
                    sb.append("<time>");
                    sb.append(this.dateFormatter.format(new Date(event.getTime())));
                    sb.append("</time>").append(SystemUtils.LINE_SEPARATOR);
                    break;
                }
                case 5: {
                    Throwable throwable = event.getThrowable();
                    if (throwable == null) break;
                    sb.append("<throwable><![CDATA[").append(SystemUtils.LINE_SEPARATOR);
                    while (throwable != null) {
                        StringWriter sw = new StringWriter();
                        throwable.printStackTrace(new PrintWriter(sw));
                        sb.append(sw.toString());
                        throwable = throwable instanceof CascadingThrowable ? ((CascadingThrowable)throwable).getCause() : null;
                    }
                    sb.append(SystemUtils.LINE_SEPARATOR).append("]]> </throwable>").append(SystemUtils.LINE_SEPARATOR);
                    break;
                }
                case 2: {
                    sb.append("<message><![CDATA[").append(SystemUtils.LINE_SEPARATOR);
                    sb.append(event.getMessage());
                    sb.append(SystemUtils.LINE_SEPARATOR).append("]]> </message>").append(SystemUtils.LINE_SEPARATOR);
                    break;
                }
                case 1: {
                    sb.append("<category>");
                    sb.append(event.getCategory());
                    sb.append("</category>").append(SystemUtils.LINE_SEPARATOR);
                    break;
                }
                case 6: {
                    sb.append("<priority>");
                    sb.append(event.getPriority().getName());
                    sb.append("</priority>").append(SystemUtils.LINE_SEPARATOR);
                    break;
                }
                case 10: {
                    sb.append("<host>");
                    sb.append(this.getHost(event.getContextMap()));
                    sb.append("</host>");
                }
            }
            ++i;
        }
        sb.append("</log-entry>");
        sb.append(SystemUtils.LINE_SEPARATOR);
        return sb.toString();
    }

    private String getURI(ContextMap ctxMap) {
        Request request;
        Object context;
        String result = "Unknown-URI";
        if (ctxMap != null && (context = ctxMap.get("objectModel")) != null && context instanceof Map && (request = ObjectModelHelper.getRequest((Map)context)) != null) {
            result = request.getRequestURI();
        }
        return result;
    }

    private String getHost(ContextMap ctxMap) {
        Request request;
        Object context;
        String result = "Unknown-host";
        if (ctxMap != null && (context = ctxMap.get("objectModel")) != null && context instanceof Map && (request = ObjectModelHelper.getRequest((Map)context)) != null) {
            result = request.getHeader("host");
        }
        return result;
    }

    private String getRequestId(ContextMap ctxMap) {
        Object context;
        String result = null;
        if (ctxMap != null && (context = ctxMap.get("request-id")) != null) {
            result = context.toString();
        }
        return result;
    }

    private String getClass(int format) {
        Class[] stack = this.callStack.get();
        int i = stack.length - 1;
        while (i >= 0) {
            if (this.loggerClass.isAssignableFrom(stack[i])) {
                String className = stack[i + 1].getName();
                if (format == 8) {
                    className = ClassUtils.getShortClassName((String)className);
                }
                return className;
            }
            --i;
        }
        return "Unknown-class";
    }

    private String getThread(ContextMap ctxMap) {
        if (ctxMap != null && ctxMap.get("threadName") != null) {
            return (String)ctxMap.get("threadName");
        }
        return "Unknown-thread";
    }

    protected int getTypeIdFor(String type) {
        int index = 0;
        while (index < typeStrings.length) {
            if (type.equalsIgnoreCase(typeStrings[index])) {
                return index;
            }
            ++index;
        }
        throw new IllegalArgumentException("Unknown Type - " + type);
    }

    public void setTypes(String[] typeStrings) {
        if (typeStrings != null) {
            this.types = new int[typeStrings.length];
            int i = 0;
            while (i < typeStrings.length) {
                this.types[i] = this.getTypeIdFor(typeStrings[i]);
                ++i;
            }
        } else {
            this.types = new int[0];
        }
    }

    public void setTypes(String typeString) {
        if (typeString == null) {
            this.types = new int[0];
        } else {
            StringTokenizer st = new StringTokenizer(typeString);
            this.types = new int[st.countTokens()];
            int i = 0;
            while (i < this.types.length) {
                this.types[i] = this.getTypeIdFor(st.nextToken());
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class CallStack
    extends SecurityManager {
        public Class[] get() {
            return this.getClassContext();
        }
    }
}

