/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.xml;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.cocoon.xml.AbstractXMLProducer;
import org.apache.cocoon.xml.NamespacesTable;
import org.apache.cocoon.xml.XMLConsumer;
import org.xml.sax.AttributeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DocumentHandlerAdapter
extends AbstractXMLProducer
implements DocumentHandler {
    private Hashtable stackedNS = new Hashtable();
    private NamespacesTable namespaces = new NamespacesTable();
    private int stack = 0;

    public DocumentHandlerAdapter() {
    }

    public DocumentHandlerAdapter(XMLConsumer consumer) {
        this();
        super.setConsumer(consumer);
    }

    public DocumentHandlerAdapter(ContentHandler content) {
        this();
        super.setContentHandler(content);
    }

    public void setDocumentLocator(Locator locator) {
        if (this.contentHandler == null) {
            return;
        }
        this.contentHandler.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        if (this.contentHandler == null) {
            throw new SAXException("ContentHandler not set");
        }
        this.contentHandler.startDocument();
    }

    public void endDocument() throws SAXException {
        if (this.contentHandler == null) {
            throw new SAXException("ContentHandler not set");
        }
        this.contentHandler.endDocument();
    }

    public void startElement(String name, AttributeList a) throws SAXException {
        if (this.contentHandler == null) {
            throw new SAXException("ContentHandler not set");
        }
        AttributesImpl a2 = new AttributesImpl();
        Vector<String> nslist = new Vector<String>();
        int x = 0;
        while (x < a.getLength()) {
            String att = a.getName(x);
            String uri = a.getValue(x);
            if (att.equals("xmlns") || att.startsWith("xmlns:")) {
                String pre = "";
                if (att.length() > 5) {
                    pre = att.substring(6);
                }
                this.namespaces.addDeclaration(pre, uri);
                nslist.addElement(pre);
                this.contentHandler.startPrefixMapping(pre, uri);
            }
            ++x;
        }
        if (nslist.size() > 0) {
            this.stackedNS.put(new Integer(this.stack), nslist);
        }
        NamespacesTable.Name w = this.namespaces.resolve(null, name, null, null);
        int x2 = 0;
        while (x2 < a.getLength()) {
            String att = a.getName(x2);
            if (!att.equals("xmlns") && !att.startsWith("xmlns:")) {
                NamespacesTable.Name k = this.namespaces.resolve(null, att, null, null);
                String val = a.getValue(x2);
                String typ = a.getType(x2);
                String uri = k.getPrefix().length() == 0 ? "" : k.getUri();
                a2.addAttribute(uri, k.getLocalName(), k.getQName(), typ, val);
            }
            ++x2;
        }
        this.contentHandler.startElement(w.getUri(), w.getLocalName(), w.getQName(), a2);
        ++this.stack;
    }

    public void endElement(String name) throws SAXException {
        if (this.contentHandler == null) {
            throw new SAXException("ContentHandler not set");
        }
        --this.stack;
        NamespacesTable.Name w = this.namespaces.resolve(null, name, null, null);
        this.contentHandler.endElement(w.getUri(), w.getLocalName(), w.getQName());
        Vector nslist = (Vector)this.stackedNS.remove(new Integer(this.stack));
        if (nslist == null) {
            return;
        }
        if (nslist.size() == 0) {
            return;
        }
        Enumeration e = nslist.elements();
        while (e.hasMoreElements()) {
            String prefix = (String)e.nextElement();
            NamespacesTable.Declaration d = this.namespaces.removeDeclaration(prefix);
            this.contentHandler.endPrefixMapping(d.getPrefix());
        }
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        if (this.contentHandler == null) {
            throw new SAXException("ContentHandler not set");
        }
        this.contentHandler.characters(ch, start, len);
    }

    public void ignorableWhitespace(char[] ch, int start, int len) throws SAXException {
        if (this.contentHandler == null) {
            throw new SAXException("ContentHandler not set");
        }
        this.contentHandler.ignorableWhitespace(ch, start, len);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.contentHandler == null) {
            throw new SAXException("ContentHandler not set");
        }
        this.contentHandler.processingInstruction(target, data);
    }
}

