/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements;

import java.io.IOException;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.Anchors;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.BaseElementProcessor;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.Direction;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.Offsets;
import org.apache.cocoon.components.elementprocessor.types.NumericConverter;
import org.apache.cocoon.components.elementprocessor.types.NumericResult;
import org.apache.cocoon.components.elementprocessor.types.Validator;

public class EPCheckbox
extends BaseElementProcessor {
    private String _input = null;
    private NumericResult _value = null;
    private String _object_bound = null;
    private Offsets _object_offset = null;
    private Anchors _object_anchor_type = null;
    private NumericResult _direction = null;
    private static final String _input_attribute = "Input";
    private static final String _value_attribute = "Value";
    private static final String _object_bound_attribute = "ObjectBound";
    private static final String _object_offset_attribute = "ObjectOffset";
    private static final String _object_anchor_type_attribute = "ObjectAnchorType";
    private static final String _direction_attribute = "Direction";
    private static final Validator _direction_validator = new Validator(){

        public IOException validate(Number number) {
            return Direction.isValid(number.intValue()) ? null : new IOException("\"" + number + "\" is not a legal value");
        }
    };

    public EPCheckbox() {
        super(null);
    }

    public String getInput() throws IOException {
        if (this._input == null) {
            this._input = this.getValue(_input_attribute);
            if (this._input == null) {
                throw new IOException("missing Input attribute");
            }
        }
        return this._input;
    }

    public int getValue() throws IOException {
        if (this._value == null) {
            this._value = NumericConverter.extractInteger(this.getValue(_value_attribute));
        }
        return this._value.intValue();
    }

    public String getObjectBound() throws IOException {
        if (this._object_bound == null) {
            this._object_bound = this.getValue(_object_bound_attribute);
            if (this._object_bound == null) {
                throw new IOException("missing ObjectBound attribute");
            }
        }
        return this._object_bound;
    }

    public Offsets getOffsets() throws IOException {
        if (this._object_offset == null) {
            this._object_offset = new Offsets(this.getValue(_object_offset_attribute));
        }
        return this._object_offset;
    }

    public Anchors getAnchors() throws IOException {
        if (this._object_anchor_type == null) {
            this._object_anchor_type = new Anchors(this.getValue(_object_anchor_type_attribute));
        }
        return this._object_anchor_type;
    }

    public int getDirection() throws IOException {
        if (this._direction == null) {
            this._direction = NumericConverter.extractInteger(this.getValue(_direction_attribute), _direction_validator);
        }
        return this._direction.intValue();
    }
}

