/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements;

import java.io.IOException;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.Anchors;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.BaseElementProcessor;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.ColorCode;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.Direction;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.ObjectFill;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.Offsets;
import org.apache.cocoon.components.elementprocessor.types.NumericConverter;
import org.apache.cocoon.components.elementprocessor.types.NumericResult;
import org.apache.cocoon.components.elementprocessor.types.Validator;

public class EPSheetObjectFilled
extends BaseElementProcessor {
    private String _object_bound = null;
    private Offsets _object_offset = null;
    private Anchors _object_anchor_type = null;
    private NumericResult _direction = null;
    private ColorCode _outline_color = null;
    private ColorCode _fill_color = null;
    private NumericResult _type = null;
    private NumericResult _width = null;
    private NumericResult _arrow_shape_a = null;
    private NumericResult _arrow_shape_b = null;
    private NumericResult _arrow_shape_c = null;
    private boolean _arrow_shape_a_fetched = false;
    private boolean _arrow_shape_b_fetched = false;
    private boolean _arrow_shape_c_fetched = false;
    private static final String _object_bound_attribute = "ObjectBound";
    private static final String _object_offset_attribute = "ObjectOffset";
    private static final String _object_anchor_type_attribute = "ObjectAnchorType";
    private static final String _direction_attribute = "Direction";
    private static final String _outline_color_attribute = "OutlineColor";
    private static final String _fill_color_attribute = "FillColor";
    private static final String _type_attribute = "Type";
    private static final String _width_attribute = "Width";
    private static final String _arrow_shape_a_attribute = "ArrowShapeA";
    private static final String _arrow_shape_b_attribute = "ArrowShapeB";
    private static final String _arrow_shape_c_attribute = "ArrowShapeC";
    private static final Validator _direction_validator = new Validator(){

        public IOException validate(Number number) {
            return Direction.isValid(number.intValue()) ? null : new IOException("\"" + number + "\" is not a legal value");
        }
    };
    private static final Validator _object_fill_validator = new Validator(){

        public IOException validate(Number number) {
            return ObjectFill.isValid(number.intValue()) ? null : new IOException("\"" + number + "\" is not a legal value");
        }
    };

    public EPSheetObjectFilled() {
        super(null);
    }

    public String getObjectBound() throws IOException {
        if (this._object_bound == null) {
            this._object_bound = this.getValue(_object_bound_attribute);
            if (this._object_bound == null) {
                throw new IOException("missing ObjectBound attribute");
            }
        }
        return this._object_bound;
    }

    public Offsets getOffsets() throws IOException {
        if (this._object_offset == null) {
            this._object_offset = new Offsets(this.getValue(_object_offset_attribute));
        }
        return this._object_offset;
    }

    public Anchors getAnchors() throws IOException {
        if (this._object_anchor_type == null) {
            this._object_anchor_type = new Anchors(this.getValue(_object_anchor_type_attribute));
        }
        return this._object_anchor_type;
    }

    public int getDirection() throws IOException {
        if (this._direction == null) {
            this._direction = NumericConverter.extractInteger(this.getValue(_direction_attribute), _direction_validator);
        }
        return this._direction.intValue();
    }

    public ColorCode getOutlineColor() throws IOException {
        if (this._outline_color == null) {
            this._outline_color = new ColorCode(this.getValue(_outline_color_attribute));
        }
        return this._outline_color;
    }

    public ColorCode getFillColor() throws IOException {
        if (this._fill_color == null) {
            this._fill_color = new ColorCode(this.getValue(_fill_color_attribute));
        }
        return this._fill_color;
    }

    public int getType() throws IOException {
        if (this._type == null) {
            this._type = NumericConverter.extractInteger(this.getValue(_type_attribute), _object_fill_validator);
        }
        return this._type.intValue();
    }

    public int getWidth() throws IOException {
        if (this._width == null) {
            this._width = NumericConverter.extractPositiveInteger(this.getValue(_width_attribute));
        }
        return this._width.intValue();
    }

    public double getArrowShapeA() throws IOException, NullPointerException {
        if (!this._arrow_shape_a_fetched) {
            this._arrow_shape_a_fetched = true;
            String arrowShapeString = this.getValue(_arrow_shape_a_attribute);
            if (arrowShapeString != null) {
                this._arrow_shape_a = NumericConverter.extractDouble(arrowShapeString);
            } else {
                throw new NullPointerException("attribute ArrowShapeA is absent");
            }
        }
        return this._arrow_shape_a.doubleValue();
    }

    public double getArrowShapeB() throws IOException, NullPointerException {
        if (!this._arrow_shape_b_fetched) {
            this._arrow_shape_b_fetched = true;
            String arrowShapeString = this.getValue(_arrow_shape_b_attribute);
            if (arrowShapeString != null) {
                this._arrow_shape_b = NumericConverter.extractDouble(arrowShapeString);
            } else {
                throw new NullPointerException("attribute ArrowShapeB is absent");
            }
        }
        return this._arrow_shape_b.doubleValue();
    }

    public double getArrowShapeC() throws IOException, NullPointerException {
        if (!this._arrow_shape_c_fetched) {
            this._arrow_shape_c_fetched = true;
            String arrowShapeString = this.getValue(_arrow_shape_c_attribute);
            if (arrowShapeString != null) {
                this._arrow_shape_c = NumericConverter.extractDouble(arrowShapeString);
            } else {
                throw new NullPointerException("attribute ArrowShapeC is absent");
            }
        }
        return this._arrow_shape_c.doubleValue();
    }
}

