/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements;

import java.io.IOException;
import java.util.Hashtable;
import org.apache.cocoon.components.elementprocessor.ElementProcessor;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.BaseElementProcessor;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.EPStyles;
import org.apache.cocoon.components.elementprocessor.types.Attribute;
import org.apache.cocoon.components.elementprocessor.types.NumericConverter;
import org.apache.cocoon.components.elementprocessor.types.NumericResult;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.util.Region;

public class EPStyleRegion
extends BaseElementProcessor {
    private static final String _start_col_attribute = "startCol";
    private static final String _start_row_attribute = "startRow";
    private static final String _end_col_attribute = "endCol";
    private static final String _end_row_attribute = "endRow";
    private NumericResult _start_col = null;
    private NumericResult _start_row = null;
    private NumericResult _end_col = null;
    private NumericResult _end_row = null;
    private HSSFCellStyle _style;
    private Hashtable colorhash;
    private boolean invalid;
    private int MAX_AREA = 2001;

    public EPStyleRegion() {
        super(null);
    }

    public void initialize(Attribute[] attributes, ElementProcessor parent) throws IOException {
        super.initialize(attributes, parent);
        Region region = new Region(this.getStartRow(), (short)this.getStartCol(), this.getEndRow(), (short)this.getEndCol());
        this.getLogger().debug("region area is " + region.getArea());
        if (region.getArea() < this.MAX_AREA) {
            this.getLogger().debug("region added");
            this._style = this.getSheet().addStyleRegion(region);
        } else {
            this.invalid = true;
        }
        this.colorhash = ((EPStyles)parent).getColorHash();
    }

    public int getStartRow() throws IOException {
        if (this._start_row == null) {
            this._start_row = NumericConverter.extractNonNegativeInteger(this.getValue(_start_row_attribute));
        }
        return this._start_row.intValue();
    }

    public int getStartCol() throws IOException {
        if (this._start_col == null) {
            this._start_col = NumericConverter.extractNonNegativeInteger(this.getValue(_start_col_attribute));
        }
        return this._start_col.intValue();
    }

    public int getEndRow() throws IOException {
        if (this._end_row == null) {
            this._end_row = NumericConverter.extractNonNegativeInteger(this.getValue(_end_row_attribute));
        }
        return this._end_row.intValue();
    }

    public int getEndCol() throws IOException {
        if (this._end_col == null) {
            this._end_col = NumericConverter.extractNonNegativeInteger(this.getValue(_end_col_attribute));
        }
        return this._end_col.intValue();
    }

    public HSSFCellStyle getStyle() {
        return this._style;
    }

    public Hashtable getColorHash() {
        return this.colorhash;
    }

    public boolean isValid() {
        return !this.invalid;
    }
}

