/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.monitor;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.avalon.excalibur.monitor.Resource;

public class DirectoryResource
extends Resource {
    public static final String ADDED = "AddedFiles";
    public static final String REMOVED = "DeletedFiles";
    public static final String MODIFIED = "ModifiedFiles";
    private final File m_dir;
    private Set m_files;
    private Map m_times;

    public DirectoryResource(String resourceKey) throws Exception {
        super(resourceKey);
        this.m_dir = new File(resourceKey);
        if (!this.m_dir.isDirectory()) {
            String message = this.m_dir + " is not a directory.";
            throw new IllegalArgumentException(message);
        }
        this.m_files = new HashSet();
        this.m_times = new HashMap();
        File[] files = this.m_dir.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            this.m_files.add(file);
            this.m_times.put(file, new Long(file.lastModified()));
            ++i;
        }
        this.setPreviousModified(System.currentTimeMillis());
    }

    public void testModifiedAfter(long time) {
        int deletedCount;
        if (this.getPreviousModified() > time) {
            return;
        }
        HashSet<File> existingFiles = new HashSet<File>();
        HashSet<File> modifiedFiles = new HashSet<File>();
        HashSet<File> addedFiles = new HashSet<File>();
        File[] files = this.m_dir.listFiles();
        int fileCount = 0;
        if (null != files) {
            fileCount = files.length;
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                long newModTime = file.lastModified();
                if (this.m_files.contains(file)) {
                    existingFiles.add(file);
                    Long oldModTime = (Long)this.m_times.get(file);
                    if (oldModTime != newModTime) {
                        modifiedFiles.add(file);
                    }
                } else {
                    addedFiles.add(file);
                }
                this.m_times.put(file, new Long(newModTime));
                ++i;
            }
        }
        int lastCount = this.m_files.size();
        int addedCount = addedFiles.size();
        int modifiedCount = modifiedFiles.size();
        if (fileCount == lastCount && 0 == addedCount && 0 == modifiedCount) {
            return;
        }
        HashSet<File> deletedFiles = new HashSet<File>();
        if (fileCount != lastCount + addedCount) {
            Iterator iterator = this.m_files.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                if (existingFiles.contains(file)) continue;
                deletedFiles.add(file);
                this.m_times.remove(file);
            }
        }
        if (0 != (deletedCount = deletedFiles.size())) {
            this.getEventSupport().firePropertyChange(REMOVED, Collections.EMPTY_SET, deletedFiles);
        }
        if (0 != addedCount) {
            this.getEventSupport().firePropertyChange(ADDED, Collections.EMPTY_SET, addedFiles);
        }
        if (0 != modifiedCount) {
            this.getEventSupport().firePropertyChange(MODIFIED, Collections.EMPTY_SET, modifiedFiles);
        }
        existingFiles.addAll(addedFiles);
        this.m_files = existingFiles;
    }

    public long lastModified() {
        return this.getPreviousModified();
    }
}

