/*
 * Decompiled with CFR 0.152.
 */
package net.sf.pizzacompiler.compiler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import net.sf.pizzacompiler.compiler.AST;
import net.sf.pizzacompiler.compiler.ASTgen;
import net.sf.pizzacompiler.compiler.Attr;
import net.sf.pizzacompiler.compiler.ByteCodeGen;
import net.sf.pizzacompiler.compiler.ClassReader;
import net.sf.pizzacompiler.compiler.ClassWriter;
import net.sf.pizzacompiler.compiler.CompilerOutput;
import net.sf.pizzacompiler.compiler.Constants;
import net.sf.pizzacompiler.compiler.Continuations;
import net.sf.pizzacompiler.compiler.Enter;
import net.sf.pizzacompiler.compiler.FileCompilerOutput;
import net.sf.pizzacompiler.compiler.FileSourceReader;
import net.sf.pizzacompiler.compiler.Gen;
import net.sf.pizzacompiler.compiler.Mangle;
import net.sf.pizzacompiler.compiler.Name;
import net.sf.pizzacompiler.compiler.Parser;
import net.sf.pizzacompiler.compiler.Pretty;
import net.sf.pizzacompiler.compiler.Report;
import net.sf.pizzacompiler.compiler.ResolveError;
import net.sf.pizzacompiler.compiler.Scanner;
import net.sf.pizzacompiler.compiler.SourceReader;
import net.sf.pizzacompiler.compiler.Switches;
import net.sf.pizzacompiler.compiler.Symbol;
import net.sf.pizzacompiler.compiler.Symtab;
import net.sf.pizzacompiler.compiler.TransClosures;
import net.sf.pizzacompiler.compiler.TransInner;
import net.sf.pizzacompiler.compiler.TransPatterns;
import net.sf.pizzacompiler.compiler.TransTypes;
import net.sf.pizzacompiler.compiler.Type;
import net.sf.pizzacompiler.lang.ListBuffer;
import net.sf.pizzacompiler.pizzadoc.Doc;
import net.sf.pizzacompiler.pizzadoc.DocCollector;
import net.sf.pizzacompiler.pizzadoc.DocSwitches;
import pizza.support.ObjectArray;
import pizza.support.array;

public class Main
implements Constants {
    private static CompilerOutput s_output;
    private static String s_userClassPath;
    private static String s_bootClassPath;
    static boolean justJava;

    static void help() {
        if (Switches.pizzadoc) {
            DocSwitches.help();
            return;
        }
        System.out.println("Usage: pc [ options ] file[s]\n");
        System.out.println("where options include:");
        System.out.println("  -classpath pathname     use given classpath");
        System.out.println("  -bootclasspath pathname use given boot classpath");
        System.out.println("  -d filename             redirect classfile output");
        System.out.println("  -experimental           enable experimental features");
        System.out.println("  -g                      include debug information");
        System.out.println("  -java                   accept only standard Java input");
        System.out.println("  -nowarn                 suppress warning messages");
        System.out.println("  -pizza                  accept standard Pizza input");
        System.out.println("  -printsearch            print information where classfiles are searched");
        System.out.println("  -prompt                 stop after each error");
        System.out.println("  -s                      emit java sources instead of classfiles");
        System.out.println("  -scramble               scramble private identifiers in bytecode");
        System.out.println("  -scrambleall            scramble package visible identifiers in bytecode");
        System.out.println("  -source <release>       provide source compatibility with specified release");
        System.out.println("  -switchcheck            warn about fall-through in switches");
        System.out.println("  -target <release>       generate class files for specific VM version");
        System.out.println("  -verbose                print detailed log");
        System.out.println("  -version                version information");
        System.out.println("  -pizzadoc               run pizzadoc");
        System.out.println();
    }

    public static boolean argument(String string) {
        if (string.equals("-diagnostics")) {
            Switches.diagnostics = true;
        } else if (string.equals("-experimental")) {
            Switches.experimental = true;
        } else if (string.equals("-g")) {
            Switches.debugInfo = true;
        } else if (string.equals("-java")) {
            justJava = true;
        } else if (string.equals("-moreinfo")) {
            Switches.moreInfo = true;
        } else if (string.equals("-O")) {
            Switches.optimize = true;
        } else if (string.equals("-nowarn")) {
            Switches.nowarn = true;
        } else if (string.equals("-pizza")) {
            Switches.pizza = true;
        } else if (string.equals("-printsearch")) {
            Switches.printSearch = true;
        } else if (string.equals("-printtree")) {
            Switches.printTree = true;
        } else if (string.equals("-prompt")) {
            Switches.promptOnError = true;
        } else if (string.equals("-s")) {
            Switches.emitSource = true;
        } else if (string.equals("-scramble")) {
            Switches.scramble = true;
        } else if (string.equals("-scrambleall")) {
            Switches.scrambleAll = true;
        } else if (string.equals("-switchcheck")) {
            Switches.switchCheck = true;
        } else if (string.equals("-verbose")) {
            Switches.verbose = true;
        } else if (string.equals("-pizzadoc")) {
            Switches.pizzadoc = true;
        } else if (!Switches.pizzadoc || !DocSwitches.argument(string)) {
            return false;
        }
        return true;
    }

    public static void setDestinationDir(String string) {
        Doc.setDestinationDir(string);
        s_output = new FileCompilerOutput(string == null ? null : new File(string));
    }

    public static void setClassPath(String string) {
        s_userClassPath = string;
    }

    public static void setBootClassPath(String string) {
        s_bootClassPath = string;
    }

    private static int option(String[] stringArray, int n) {
        String string = stringArray[n];
        stringArray[n] = null;
        if (string.equals("-classpath") && n + 1 < stringArray.length) {
            Main.setClassPath(stringArray[n + 1]);
            stringArray[++n] = null;
        } else if (string.equals("-bootclasspath") && n + 1 < stringArray.length) {
            Main.setBootClassPath(stringArray[n + 1]);
            stringArray[++n] = null;
        } else if (string.equals("-d") && n + 1 < stringArray.length) {
            Main.setDestinationDir(stringArray[n + 1]);
            stringArray[++n] = null;
        } else if (string.equals("-source") && n + 1 < stringArray.length) {
            Switches.setSource(stringArray[n + 1]);
            stringArray[++n] = null;
        } else if (string.equals("-target") && n + 1 < stringArray.length) {
            Switches.setTarget(stringArray[n + 1]);
            stringArray[++n] = null;
        } else if (string.equals("-version")) {
            System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Pizza ").concat(String.valueOf(Main.version()))).concat(String.valueOf(", "))).concat(String.valueOf(Main.date()))).concat(String.valueOf(", Copyright (c) 1996-98 Martin Odersky.")));
            System.out.println("further information at http://pizzacompiler.sourceforge.net");
        } else if (!Main.argument(string)) {
            System.out.println(String.valueOf("unrecognized option: ").concat(String.valueOf(string)));
        }
        return n + 1;
    }

    static AST.TopLevel parse(String string, SourceReader sourceReader) {
        AST[] aSTArray;
        long l = System.currentTimeMillis();
        InputStream inputStream = null;
        try {
            inputStream = sourceReader.getInputStream(string);
        }
        catch (IOException iOException) {
            Report.error(0, String.valueOf("can't read: ").concat(String.valueOf(string)));
        }
        if (inputStream != null) {
            if (Switches.verbose) {
                System.out.print(String.valueOf(String.valueOf("[parsing ").concat(String.valueOf(string))).concat(String.valueOf(" ")));
                System.out.flush();
            }
            Name name = Report.useSource(Name.fromString(string));
            Scanner scanner = new Scanner(inputStream);
            Parser parser = new Parser(scanner);
            aSTArray = parser.compilationUnit();
            if (Switches.pizzadoc) {
                DocCollector.hash(aSTArray);
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (Switches.verbose) {
                System.out.println(String.valueOf(System.currentTimeMillis() - l).concat(String.valueOf("ms]")));
            }
            Report.useSource(name);
        } else {
            aSTArray = new AST[]{};
        }
        return ASTgen.at(1025).TopLevel(Name.fromString(string), aSTArray);
    }

    static AST.TopLevel translate(AST.TopLevel topLevel) {
        if (Switches.verbose) {
            System.out.println(String.valueOf(String.valueOf("[translating ").concat(String.valueOf(topLevel.sourcefile))).concat(String.valueOf("]")));
        }
        topLevel = new TransPatterns().translate(topLevel);
        topLevel = new TransClosures().translate(topLevel);
        topLevel = new TransTypes().translate(topLevel);
        return topLevel;
    }

    static void process(AST.TopLevel[] topLevelArray, SourceReader sourceReader, CompilerOutput compilerOutput) {
        ListBuffer listBuffer = new ListBuffer();
        Enter.compiled.clear();
        for (int i = 0; i < topLevelArray.length; ++i) {
            Enter.classEnter(topLevelArray[i]);
        }
        if (Symtab.init()) {
            for (int i = 0; i < topLevelArray.length; ++i) {
                Enter.prologue(topLevelArray[i]);
            }
            for (int i = 0; i < topLevelArray.length; ++i) {
                Enter.memberEnter(topLevelArray[i]);
            }
            if (!Switches.pizzadoc) {
                int n;
                for (int i = 0; i < topLevelArray.length; ++i) {
                    n = Attr.attribute(topLevelArray[i]);
                    if (Report.getNrErrors() != 0) continue;
                    if (Switches.pizza) {
                        topLevelArray[i] = Main.translate(topLevelArray[i]);
                        if (!Switches.emitSource) continue;
                        Pretty.output(topLevelArray[i], sourceReader, compilerOutput);
                        continue;
                    }
                    if (n != 0) {
                        listBuffer.net$sf$pizzacompiler$lang$ListBuffer$append(topLevelArray[i]);
                        continue;
                    }
                    boolean bl = Switches.errorsPossible;
                    Switches.errorsPossible = true;
                    ByteCodeGen.generate(topLevelArray[i], compilerOutput);
                    Switches.errorsPossible = bl;
                }
                Switches.errorsPossible = false;
                if (Report.getNrErrors() == 0) {
                    if (Switches.pizza) {
                        if (!Switches.emitSource) {
                            Switches.pizza = false;
                            Main.process(topLevelArray, sourceReader, compilerOutput);
                            Switches.pizza = true;
                        }
                    } else {
                        n = listBuffer.length();
                        if (n > 0) {
                            AST.TopLevel[] topLevelArray2 = (AST.TopLevel[])array.asObject(listBuffer.net$sf$pizzacompiler$lang$ListBuffer$toList().net$sf$pizzacompiler$lang$List$copy(ObjectArray.make(new AST.TopLevel[n])).ObjectElems());
                            for (int i = 0; i < n; ++i) {
                                topLevelArray2[i] = new TransInner().translate(topLevelArray2[i]);
                                if (!Switches.printTree) continue;
                                Pretty.output(topLevelArray2[i], sourceReader, compilerOutput);
                            }
                            Switches.classesNest = false;
                            Main.process(topLevelArray2, sourceReader, compilerOutput);
                            Switches.classesNest = true;
                        }
                    }
                }
                Switches.errorsPossible = true;
            }
        }
    }

    public static void init() {
        Main.setDestinationDir(null);
        Switches.resetToDefaults();
        Symbol.init();
        Symtab.writer = new ClassWriter();
        Report.init();
    }

    public static void setClassReader(ClassReader classReader) {
        Symtab.reader = classReader;
        Type.init();
    }

    public static void compile(String[] stringArray, SourceReader sourceReader, CompilerOutput compilerOutput, PrintStream printStream) {
        long l = System.currentTimeMillis();
        Enter.init();
        Report.init();
        Mangle.init();
        Continuations.init();
        Report.setOut(printStream);
        AST.TopLevel[] topLevelArray = new AST.TopLevel[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            topLevelArray[i] = Main.parse(stringArray[i], sourceReader);
        }
        try {
            Main.process(topLevelArray, sourceReader, compilerOutput);
        }
        catch (ResolveError resolveError) {
            // empty catch block
        }
        if (Switches.pizzadoc) {
            Doc.process(topLevelArray);
        }
        if (Switches.verbose) {
            System.out.println(String.valueOf(String.valueOf("[total ").concat(String.valueOf(System.currentTimeMillis() - l))).concat(String.valueOf("ms]")));
        }
        Main.printCount("error", Report.getNrErrors(), printStream);
        Main.printCount("warning", Report.getNrWarnings(), printStream);
        if (Gen.statistics) {
            Gen.stats();
        }
    }

    static void printCount(String string, int n, PrintStream printStream) {
        if (printStream == null) {
            printStream = System.out;
        }
        if (n != 0) {
            printStream.print(n);
            printStream.println(String.valueOf(String.valueOf(" ").concat(String.valueOf(string))).concat(String.valueOf(n == 1 ? "" : "s")));
        }
    }

    static void bugMessage() {
        System.out.println(String.valueOf(String.valueOf("\n\nAn exception has occurred in the compiler. (").concat(String.valueOf(Main.version()))).concat(String.valueOf(")")));
        Report.inviteBugReport();
    }

    public static String version() {
        return "v1.0g";
    }

    public static String date() {
        return "1-October-2001";
    }

    public static void main(String[] stringArray) throws Throwable {
        int n = 0;
        try {
            Main.init();
            int n2 = 0;
            justJava = false;
            while (n2 < stringArray.length) {
                if (stringArray[n2].startsWith("-")) {
                    n2 = Main.option(stringArray, n2);
                    continue;
                }
                if (!stringArray[n2].endsWith(".java") && !justJava) {
                    Switches.pizza = true;
                }
                ++n;
                ++n2;
            }
            Main.setClassReader(new ClassReader(s_userClassPath, s_bootClassPath));
            if (n > 0) {
                String[] stringArray2 = new String[n];
                n = 0;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] == null) continue;
                    stringArray2[n++] = stringArray[i];
                }
                Main.compile(stringArray2, new FileSourceReader(), s_output, null);
            } else {
                Main.help();
            }
        }
        catch (Throwable throwable) {
            System.out.flush();
            Main.bugMessage();
            throw throwable;
        }
        if (Report.getNrErrors() > 0 || n == 0) {
            System.exit(1);
        } else {
            System.exit(0);
        }
    }

    static {
        s_userClassPath = null;
        s_bootClassPath = null;
    }
}

