/*
 * Decompiled with CFR 0.152.
 */
package net.sf.pizzacompiler.util;

import java.io.Serializable;
import net.sf.pizzacompiler.util.Dictionary;
import net.sf.pizzacompiler.util.Enumeration;
import net.sf.pizzacompiler.util.NoSuchElementException;

public class Hashtable
extends Dictionary
implements Serializable,
Cloneable {
    private EntryList[] data;
    private int elementCount;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private float loadFactor;
    private static final int DEFAULT_CAPACITY = 107;

    public Hashtable(int n, float f) {
        if (n <= 0) {
            throw new IllegalArgumentException("illegal initialCapacity");
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("illegal loadFactor");
        }
        this.loadFactor = f;
        this.data = new EntryList[n];
    }

    public Hashtable(int n) {
        this(n, 0.75f);
    }

    public Hashtable() {
        this(107, 0.75f);
    }

    public int size() {
        return this.elementCount;
    }

    int pizzaInternalGetTableSize() {
        return this.data.length;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public synchronized Enumeration net$sf$pizzacompiler$util$Hashtable$keys() {
        return new KeyEnumeration(this.data);
    }

    public synchronized Enumeration net$sf$pizzacompiler$util$Hashtable$elements() {
        return new ValueEnumeration(this.data);
    }

    public synchronized boolean net$sf$pizzacompiler$util$Hashtable$contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < this.data.length; ++i) {
            EntryList entryList = this.data[i];
            while (entryList != null) {
                if (entryList.value.equals(object)) {
                    return true;
                }
                entryList = entryList.tail;
            }
        }
        return false;
    }

    public synchronized boolean net$sf$pizzacompiler$util$Hashtable$containsKey(Object object) {
        int n = object.hashCode();
        return this.getEntry(object, n).net$sf$pizzacompiler$util$Hashtable$EntryList$containsKey(object);
    }

    private EntryList getEntry(Object object, int n) {
        EntryList entryList = this.data[this.getDataIndex(n, this.data.length)];
        if (entryList == null) {
            return new NullEntryList();
        }
        return entryList;
    }

    private int getDataIndex(int n, int n2) {
        int n3 = n % n2;
        if (n3 < 0) {
            return n3 + n2;
        }
        return n3;
    }

    public synchronized Object net$sf$pizzacompiler$util$Hashtable$get(Object object) {
        int n = object.hashCode();
        return this.getEntry(object, n).net$sf$pizzacompiler$util$Hashtable$EntryList$getValue(object, n);
    }

    protected void rehash() {
        EntryList[] entryListArray = new EntryList[this.data.length * 2 + 1];
        for (int i = 0; i < this.data.length; ++i) {
            EntryList entryList = this.data[i];
            while (entryList != null) {
                EntryList entryList2 = entryList.tail;
                entryList.tail = entryListArray[this.getDataIndex(entryList.hashValue, entryListArray.length)];
                entryListArray[this.getDataIndex((int)entryList.hashValue, (int)entryListArray.length)] = entryList;
                entryList = entryList2;
            }
        }
        this.data = entryListArray;
    }

    public synchronized Object net$sf$pizzacompiler$util$Hashtable$put(Object object, Object object2) {
        Object object3;
        int n = object.hashCode();
        EntryList entryList = this.data[this.getDataIndex(n, this.data.length)];
        if (entryList != null && (object3 = entryList.net$sf$pizzacompiler$util$Hashtable$EntryList$getValue(object, n)) != null) {
            return object3;
        }
        if (this.elementCount >= (int)((float)this.data.length * this.loadFactor)) {
            this.rehash();
        }
        this.data[this.getDataIndex((int)n, (int)this.data.length)] = new EntryList(object, object2, n, this.data[this.getDataIndex(n, this.data.length)]);
        ++this.elementCount;
        return null;
    }

    public synchronized Object net$sf$pizzacompiler$util$Hashtable$remove(Object object) {
        int n = object.hashCode();
        EntryList entryList = this.data[this.getDataIndex(n, this.data.length)];
        if (entryList != null) {
            if (entryList.hashValue == n && entryList.key.equals(object)) {
                this.data[this.getDataIndex((int)n, (int)this.data.length)] = entryList.tail;
                --this.elementCount;
                return entryList.value;
            }
            EntryList entryList2 = entryList;
            entryList = entryList.tail;
            while (entryList != null) {
                if (entryList.key.hashCode() == n && entryList.key.equals(object)) {
                    entryList2.tail = entryList.tail;
                    --this.elementCount;
                    return entryList.value;
                }
                entryList2 = entryList;
                entryList = entryList.tail;
            }
        }
        return null;
    }

    public synchronized void clear() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = null;
        }
        this.elementCount = 0;
    }

    public synchronized Object clone() {
        Hashtable hashtable = new Hashtable(this.data.length, this.loadFactor);
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == null) continue;
            hashtable.data[i] = this.data[i].net$sf$pizzacompiler$util$Hashtable$EntryList$copy();
        }
        hashtable.elementCount = this.elementCount;
        return hashtable;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer("[pizza.util.Hashtable ");
        boolean bl = false;
        for (int i = 0; i < this.data.length; ++i) {
            EntryList entryList = this.data[i];
            while (entryList != null) {
                if (bl) {
                    stringBuffer.append(", ");
                }
                bl = true;
                stringBuffer.append(entryList.key).append("=").append(entryList.value);
                entryList = entryList.tail;
            }
        }
        return stringBuffer.append("]").toString();
    }

    public Enumeration net$sf$pizzacompiler$util$Dictionary$keys() {
        return this.net$sf$pizzacompiler$util$Hashtable$keys();
    }

    public Enumeration net$sf$pizzacompiler$util$Dictionary$elements() {
        return this.net$sf$pizzacompiler$util$Hashtable$elements();
    }

    public Object net$sf$pizzacompiler$util$Dictionary$get(Object object) {
        return this.net$sf$pizzacompiler$util$Hashtable$get(object);
    }

    public Object net$sf$pizzacompiler$util$Dictionary$put(Object object, Object object2) {
        return this.net$sf$pizzacompiler$util$Hashtable$put(object, object2);
    }

    public Object net$sf$pizzacompiler$util$Dictionary$remove(Object object) {
        return this.net$sf$pizzacompiler$util$Hashtable$remove(object);
    }

    private class ValueEnumeration
    implements Enumeration {
        private EntryList[] data;
        private EntryList entry;
        private int index;

        ValueEnumeration(EntryList[] entryListArray) {
            this.data = entryListArray;
        }

        public boolean hasMoreElements() {
            while (this.index < this.data.length && this.entry == null) {
                this.entry = this.data[this.index];
                ++this.index;
            }
            return this.entry != null;
        }

        public Object net$sf$pizzacompiler$util$Hashtable$ValueEnumeration$nextElement() {
            while (this.index < this.data.length && this.entry == null) {
                this.entry = this.data[this.index];
                ++this.index;
            }
            if (this.entry != null) {
                Object object = this.entry.value;
                this.entry = this.entry.tail;
                return object;
            }
            throw new NoSuchElementException();
        }

        public Object net$sf$pizzacompiler$util$Enumeration$nextElement() {
            return this.net$sf$pizzacompiler$util$Hashtable$ValueEnumeration$nextElement();
        }
    }

    private class KeyEnumeration
    implements Enumeration {
        private EntryList[] data;
        private EntryList entry;
        private int index;

        KeyEnumeration(EntryList[] entryListArray) {
            this.data = entryListArray;
        }

        public boolean hasMoreElements() {
            while (this.index < this.data.length && this.entry == null) {
                this.entry = this.data[this.index];
                ++this.index;
            }
            return this.entry != null;
        }

        public Object net$sf$pizzacompiler$util$Hashtable$KeyEnumeration$nextElement() {
            while (this.index < this.data.length && this.entry == null) {
                this.entry = this.data[this.index];
                ++this.index;
            }
            if (this.entry != null) {
                Object object = this.entry.key;
                this.entry = this.entry.tail;
                return object;
            }
            throw new NoSuchElementException();
        }

        public Object net$sf$pizzacompiler$util$Enumeration$nextElement() {
            return this.net$sf$pizzacompiler$util$Hashtable$KeyEnumeration$nextElement();
        }
    }

    private static class NullEntryList
    extends EntryList {
        public NullEntryList() {
            super(null, null, 0, null);
        }

        boolean net$sf$pizzacompiler$util$Hashtable$NullEntryList$containsKey(Object object) {
            return false;
        }

        Object net$sf$pizzacompiler$util$Hashtable$NullEntryList$getValue(Object object, int n) {
            return null;
        }

        EntryList net$sf$pizzacompiler$util$Hashtable$NullEntryList$copy() {
            throw new NullPointerException("shouldn't copy null entry");
        }

        boolean net$sf$pizzacompiler$util$Hashtable$EntryList$containsKey(Object object) {
            return this.net$sf$pizzacompiler$util$Hashtable$NullEntryList$containsKey(object);
        }

        Object net$sf$pizzacompiler$util$Hashtable$EntryList$getValue(Object object, int n) {
            return this.net$sf$pizzacompiler$util$Hashtable$NullEntryList$getValue(object, n);
        }

        EntryList net$sf$pizzacompiler$util$Hashtable$EntryList$copy() {
            return this.net$sf$pizzacompiler$util$Hashtable$NullEntryList$copy();
        }
    }

    private static class EntryList {
        Object key;
        Object value;
        int hashValue;
        EntryList tail;

        EntryList(Object object, Object object2, int n, EntryList entryList) {
            this.key = object;
            this.value = object2;
            this.hashValue = n;
            this.tail = entryList;
        }

        EntryList net$sf$pizzacompiler$util$Hashtable$EntryList$copy() {
            return new EntryList(this.key, this.value, this.hashValue, this.tail != null ? this.tail.net$sf$pizzacompiler$util$Hashtable$EntryList$copy() : null);
        }

        boolean net$sf$pizzacompiler$util$Hashtable$EntryList$containsKey(Object object) {
            return this.key.equals(object) || (this.tail != null ? this.tail.net$sf$pizzacompiler$util$Hashtable$EntryList$containsKey(object) : false);
        }

        Object net$sf$pizzacompiler$util$Hashtable$EntryList$getValue(Object object, int n) {
            if (this.hashValue == n && this.key.equals(object)) {
                return this.value;
            }
            if (this.tail != null) {
                return this.tail.net$sf$pizzacompiler$util$Hashtable$EntryList$getValue(object, n);
            }
            return null;
        }
    }
}

