/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.excalibur.logger.LogTargetFactory;
import org.apache.avalon.excalibur.logger.LogTargetFactoryManageable;
import org.apache.avalon.excalibur.logger.LogTargetFactoryManager;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;

public class DefaultLogTargetFactoryManager
extends AbstractLogEnabled
implements LogTargetFactoryManager,
Contextualizable,
Configurable {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$excalibur$logger$DefaultLogTargetFactoryManager == null ? (class$org$apache$avalon$excalibur$logger$DefaultLogTargetFactoryManager = DefaultLogTargetFactoryManager.class$("org.apache.avalon.excalibur.logger.DefaultLogTargetFactoryManager")) : class$org$apache$avalon$excalibur$logger$DefaultLogTargetFactoryManager));
    private final Map m_factories = new HashMap();
    private Context m_context;
    private ClassLoader m_classLoader;
    static /* synthetic */ Class class$org$apache$avalon$excalibur$logger$DefaultLogTargetFactoryManager;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public final LogTargetFactory getLogTargetFactory(String factoryName) {
        return (LogTargetFactory)this.m_factories.get(factoryName);
    }

    public final void contextualize(Context context) {
        this.m_context = context;
        try {
            this.m_classLoader = (ClassLoader)this.m_context.get((Object)(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = DefaultLogTargetFactoryManager.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getName());
        }
        catch (ContextException ce) {
            try {
                this.m_classLoader = (ClassLoader)this.m_context.get((Object)"classloader");
            }
            catch (ContextException e) {
                this.m_classLoader = Thread.currentThread().getContextClassLoader();
            }
        }
    }

    public final void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] confs = configuration.getChildren("factory");
        int i = 0;
        while (i < confs.length) {
            LogTargetFactory logTargetFactory;
            String factoryClass = confs[i].getAttribute("class");
            String factoryType = confs[i].getAttribute("type");
            try {
                Class<?> clazz = null;
                try {
                    clazz = this.m_classLoader.loadClass(factoryClass);
                }
                catch (ClassNotFoundException cnfe) {
                    clazz = this.getClass().getClassLoader().loadClass(factoryClass);
                }
                logTargetFactory = (LogTargetFactory)clazz.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                String message = REZ.getString("target-factory.error.find-class", (Object)factoryClass);
                throw new ConfigurationException(message, (Throwable)cnfe);
            }
            catch (InstantiationException ie) {
                String message = REZ.getString("target-factory.error.instantiate-class", (Object)factoryClass);
                throw new ConfigurationException(message, (Throwable)ie);
            }
            catch (IllegalAccessException iae) {
                String message = REZ.getString("target-factory.error.access-class", (Object)factoryClass);
                throw new ConfigurationException(message, (Throwable)iae);
            }
            ContainerUtil.enableLogging((Object)logTargetFactory, (Logger)this.getLogger());
            try {
                ContainerUtil.contextualize((Object)logTargetFactory, (Context)this.m_context);
            }
            catch (ContextException ce) {
                String message = REZ.getString("target-factory.error.contextualize", (Object)factoryClass);
                throw new ConfigurationException(message, (Throwable)ce);
            }
            ContainerUtil.configure((Object)logTargetFactory, (Configuration)confs[i]);
            if (logTargetFactory instanceof LogTargetFactoryManageable) {
                ((LogTargetFactoryManageable)((Object)logTargetFactory)).setLogTargetFactoryManager(this);
            }
            if (this.getLogger().isDebugEnabled()) {
                String message = REZ.getString("target-factory.notice.add", (Object)factoryType);
                this.getLogger().debug(message);
            }
            this.m_factories.put(factoryType, logTargetFactory);
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

