/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.ant;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.Project;

public final class AntLog
implements Log {
    private final Project project;
    private boolean use_level = false;
    private int antMsgLevel = 0;

    public AntLog(Project project) {
        this.project = project;
    }

    public AntLog(Project project, int antMsgLevel) {
        this.project = project;
        this.antMsgLevel = antMsgLevel;
        this.use_level = true;
    }

    public void trace(Object message) {
        if (this.use_level && this.antMsgLevel == 4) {
            this.project.log(message.toString());
        }
        this.project.log(message.toString(), 4);
    }

    public void trace(Object message, Throwable t) {
        if (this.use_level && this.antMsgLevel == 4) {
            this.project.log(message + ":" + this.toString(t));
        }
        this.project.log(message + ":" + this.toString(t), 4);
    }

    public boolean isTraceEnabled() {
        if (this.use_level) {
            return this.antMsgLevel == 4;
        }
        return true;
    }

    public void debug(Object message) {
        if (this.use_level && this.antMsgLevel == 4) {
            this.project.log(message.toString());
        }
        this.project.log(message.toString(), 4);
    }

    public void debug(Object message, Throwable t) {
        if (this.use_level && this.antMsgLevel == 4) {
            this.project.log(message + ":" + this.toString(t));
        }
        this.project.log(message + ":" + this.toString(t), 4);
    }

    public boolean isDebugEnabled() {
        if (this.use_level) {
            return this.antMsgLevel == 4;
        }
        return true;
    }

    public void info(Object message) {
        if (this.use_level && this.antMsgLevel == 2) {
            this.project.log(message.toString());
        }
        this.project.log(message.toString(), 2);
    }

    public void info(Object message, Throwable t) {
        if (this.use_level && this.antMsgLevel == 2) {
            this.project.log(message + ":" + this.toString(t));
        }
        this.project.log(message + ":" + this.toString(t), 2);
    }

    public boolean isInfoEnabled() {
        if (this.use_level) {
            return this.antMsgLevel == 2;
        }
        return true;
    }

    public void warn(Object message) {
        if (this.use_level && this.antMsgLevel == 1) {
            this.project.log(message.toString());
        }
        this.project.log(message.toString(), 1);
    }

    public void warn(Object message, Throwable t) {
        if (this.use_level && this.antMsgLevel == 1) {
            this.project.log(message + ":" + this.toString(t));
        }
        this.project.log(message + ":" + this.toString(t), 1);
    }

    public boolean isWarnEnabled() {
        if (this.use_level) {
            return this.antMsgLevel == 1;
        }
        return true;
    }

    public void error(Object message) {
        if (this.use_level && this.antMsgLevel == 0) {
            this.project.log(message.toString());
        }
        this.project.log(message.toString(), 0);
    }

    public void error(Object message, Throwable t) {
        if (this.use_level && this.antMsgLevel == 0) {
            this.project.log(message + ":" + this.toString(t));
        }
        this.project.log(message + ":" + this.toString(t), 0);
    }

    public boolean isErrorEnabled() {
        if (this.use_level) {
            return this.antMsgLevel == 0;
        }
        return true;
    }

    public void fatal(Object message) {
        if (this.use_level && this.antMsgLevel == 0) {
            this.project.log(message.toString());
        }
        this.project.log(message.toString(), 0);
    }

    public void fatal(Object message, Throwable t) {
        if (this.use_level && this.antMsgLevel == 0) {
            this.project.log(message + ":" + this.toString(t));
        }
        this.project.log(message + ":" + this.toString(t), 0);
    }

    public boolean isFatalEnabled() {
        if (this.use_level) {
            return this.antMsgLevel == 0;
        }
        return true;
    }

    private String toString(Throwable t) {
        StringBuffer buffer = new StringBuffer();
        if (t != null) {
            buffer.append(" <");
            buffer.append(t.toString());
            buffer.append(">");
            StringWriter sw = new StringWriter(1024);
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            buffer.append(sw.toString());
        }
        return buffer.toString();
    }
}

