/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.common;

import org.apache.commons.logging.Log;

public final class ConsoleLog
implements Log {
    public static final int TRACE = 0;
    public static final int DEBUG = 1;
    public static final int INFO = 2;
    public static final int WARN = 3;
    public static final int ERROR = 4;
    public static final int FATAL = 5;
    private int level = 1;

    public ConsoleLog() {
    }

    public ConsoleLog(int level) {
        this.level = level;
    }

    public void trace(Object message) {
        if (this.isTraceEnabled()) {
            System.out.print("[TRACE] ");
            System.out.println(message);
        }
    }

    public void trace(Object message, Throwable t) {
        if (this.isTraceEnabled()) {
            System.out.print("[TRACE] ");
            System.out.println(message);
            t.printStackTrace(System.out);
        }
    }

    public boolean isTraceEnabled() {
        return this.level <= 0;
    }

    public void debug(Object message) {
        if (this.isDebugEnabled()) {
            System.out.print("[DEBUG] ");
            System.out.println(message);
        }
    }

    public void debug(Object message, Throwable t) {
        if (this.isDebugEnabled()) {
            System.out.print("[DEBUG] ");
            System.out.println(message);
            t.printStackTrace(System.out);
        }
    }

    public boolean isDebugEnabled() {
        return this.level <= 1;
    }

    public void info(Object message) {
        if (this.isInfoEnabled()) {
            System.out.print("[INFO] ");
            System.out.println(message);
        }
    }

    public void info(Object message, Throwable t) {
        if (this.isInfoEnabled()) {
            System.out.print("[INFO] ");
            System.out.println(message);
            t.printStackTrace(System.out);
        }
    }

    public boolean isInfoEnabled() {
        return this.level <= 2;
    }

    public void warn(Object message) {
        if (this.isWarnEnabled()) {
            System.out.print("[WARN] ");
            System.out.println(message);
        }
    }

    public void warn(Object message, Throwable t) {
        if (this.isWarnEnabled()) {
            System.out.print("[WARN] ");
            System.out.println(message);
            t.printStackTrace(System.out);
        }
    }

    public boolean isWarnEnabled() {
        return this.level <= 3;
    }

    public void error(Object message) {
        if (this.isErrorEnabled()) {
            System.out.print("[ERROR] ");
            System.out.println(message);
        }
    }

    public void error(Object message, Throwable t) {
        if (this.isErrorEnabled()) {
            System.out.print("[ERROR] ");
            System.out.println(message);
            t.printStackTrace(System.out);
        }
    }

    public boolean isErrorEnabled() {
        return this.level <= 4;
    }

    public void fatal(Object message) {
        if (this.isFatalEnabled()) {
            System.out.print("[FATAL] ");
            System.out.println(message);
        }
    }

    public void fatal(Object message, Throwable t) {
        if (this.isFatalEnabled()) {
            System.out.print("[FATAL] ");
            System.out.println(message);
            t.printStackTrace(System.out);
        }
    }

    public boolean isFatalEnabled() {
        return this.level <= 5;
    }
}

