/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.excalibur.xml.sax.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class HttpProxyGenerator
extends ServiceableGenerator
implements Configurable {
    private HttpMethodBase method = null;
    private HttpURL url = null;
    private ArrayList reqParams = null;
    private ArrayList qryParams = null;
    private boolean debug = false;

    public void configure(Configuration configuration) throws ConfigurationException {
        String method = configuration.getChild("method").getValue("GET");
        if ("GET".equalsIgnoreCase(method)) {
            this.method = new GetMethod();
        } else if ("POST".equalsIgnoreCase(method)) {
            this.method = new PostMethod();
            ((PostMethod)this.method).setRequestBody("");
        } else {
            throw new ConfigurationException("Invalid method \"" + method + "\" specified" + " at " + configuration.getChild("method").getLocation());
        }
        String url = configuration.getChild("url").getValue(null);
        try {
            if (url != null) {
                this.url = new HttpURL(url);
            }
        }
        catch (URIException e) {
            throw new ConfigurationException("Cannot process URL \"" + url + "\" specified" + " at " + configuration.getChild("url").getLocation());
        }
        this.reqParams = this.getParams(configuration.getChildren("param"));
        this.qryParams = this.getParams(configuration.getChildren("query"));
    }

    public void setup(SourceResolver sourceResolver, Map objectModel, String source, Parameters parameters) throws ProcessingException, SAXException, IOException {
        NameValuePair[] nvpa;
        HttpURL src;
        ArrayList req;
        super.setup(sourceResolver, objectModel, source, parameters);
        ArrayList qry = req = new ArrayList();
        if (this.method instanceof PostMethod) {
            qry = new ArrayList();
        }
        req.addAll(this.reqParams);
        qry.addAll(this.qryParams);
        String[] names = parameters.getNames();
        int x = 0;
        while (x < names.length) {
            String name = names[x];
            String value = parameters.getParameter(name, null);
            if (value != null) {
                if (name.startsWith("query:")) {
                    name = name.substring("query:".length());
                    qry.add(new NameValuePair(name, value));
                } else if (name.startsWith("param:")) {
                    name = name.substring("param:".length());
                    req.add(new NameValuePair(name, value));
                } else if (name.startsWith("query-override:")) {
                    name = name.substring("query-override:".length());
                    qry = this.overrideParams(qry, name, value);
                } else if (name.startsWith("param-override:")) {
                    name = name.substring("param-override:".length());
                    req = this.overrideParams(req, name, value);
                }
            }
            ++x;
        }
        HttpURL httpURL = src = this.source == null ? null : new HttpURL(this.source);
        if (this.url != null) {
            HttpURL httpURL2 = src = src == null ? this.url : new HttpURL(this.url, src);
        }
        if (src == null) {
            throw new ProcessingException("No URL specified");
        }
        if (src.isRelativeURI()) {
            throw new ProcessingException("Invalid URL \"" + src.toString() + "\"");
        }
        HostConfiguration hc = new HostConfiguration();
        hc.setHost((URI)src);
        this.method.setHostConfiguration(hc);
        this.method.setPath(src.getPath());
        this.method.setQueryString(src.getQuery());
        if (qry.size() > 0) {
            String qs = this.method.getQueryString();
            nvpa = new NameValuePair[qry.size()];
            this.method.setQueryString(qry.toArray(nvpa));
            if (qs != null) {
                this.method.setQueryString(qs + "&" + this.method.getQueryString());
            }
        }
        if (this.method instanceof PostMethod && req.size() > 0) {
            PostMethod post = (PostMethod)this.method;
            nvpa = new NameValuePair[req.size()];
            post.setRequestBody(req.toArray(nvpa));
        }
        this.debug = parameters.getParameterAsBoolean("debug", false);
    }

    public void recycle() {
        this.method.recycle();
        if (this.method instanceof PostMethod) {
            ((PostMethod)this.method).setRequestBody("");
        }
        super.recycle();
    }

    public void generate() throws ResourceNotFoundException, ProcessingException, SAXException, IOException {
        if (this.debug) {
            this.generateDebugOutput();
            return;
        }
        HttpConnection connection = new HttpConnection(this.method.getHostConfiguration());
        HttpState state = new HttpState();
        this.method.setFollowRedirects(true);
        int status = this.method.execute(state, connection);
        if (status == 404) {
            throw new ResourceNotFoundException("Unable to access \"" + this.method.getURI() + "\" (HTTP 404 Error)");
        }
        if (status < 200 || status > 299) {
            throw new IOException("Unable to access HTTP resource at \"" + this.method.getURI().toString() + "\" (status=" + status + ")");
        }
        InputStream response = this.method.getResponseBodyAsStream();
        SAXParser parser = null;
        try {
            try {
                InputSource inputSource = new InputSource(response);
                parser = (SAXParser)this.manager.lookup(SAXParser.ROLE);
                parser.parse(inputSource, (ContentHandler)this.xmlConsumer);
            }
            catch (ServiceException ex) {
                throw new ProcessingException("Unable to get parser", (Throwable)ex);
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.manager.release(parser);
            this.method.releaseConnection();
            connection.close();
            throw throwable;
        }
        this.manager.release((Object)parser);
        this.method.releaseConnection();
        connection.close();
    }

    private void generateDebugOutput() throws SAXException, IOException {
        this.xmlConsumer.startDocument();
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", "method", "method", "CDATA", this.method.getName());
        attributes.addAttribute("", "url", "url", "CDATA", this.method.getURI().toString());
        attributes.addAttribute("", "protocol", "protocol", "CDATA", this.method.isHttp11() ? "HTTP/1.1" : "HTTP/1.0");
        this.xmlConsumer.startElement("", "request", "request", (Attributes)attributes);
        if (this.method instanceof PostMethod) {
            String body = ((PostMethod)this.method).getRequestBodyAsString();
            attributes = new AttributesImpl();
            attributes.addAttribute("", "name", "name", "CDATA", "Content-Type");
            attributes.addAttribute("", "value", "value", "CDATA", "application/x-www-form-urlencoded");
            this.xmlConsumer.startElement("", "header", "header", (Attributes)attributes);
            this.xmlConsumer.endElement("", "header", "header");
            attributes = new AttributesImpl();
            attributes.addAttribute("", "name", "name", "CDATA", "Content-Length");
            attributes.addAttribute("", "value", "value", "CDATA", Integer.toString(body.length()));
            this.xmlConsumer.startElement("", "header", "header", (Attributes)attributes);
            this.xmlConsumer.endElement("", "header", "header");
            attributes = new AttributesImpl();
            this.xmlConsumer.startElement("", "body", "body", (Attributes)attributes);
            this.xmlConsumer.characters(body.toCharArray(), 0, body.length());
            this.xmlConsumer.endElement("", "body", "body");
        }
        this.xmlConsumer.endElement("", "request", "request");
        this.xmlConsumer.endDocument();
    }

    private ArrayList getParams(Configuration[] configurations) throws ConfigurationException {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        if (configurations.length < 1) {
            return list;
        }
        int x = 0;
        while (x < configurations.length) {
            Configuration configuration = configurations[x];
            String name = configuration.getAttribute("name", null);
            if (name == null) {
                throw new ConfigurationException("No name specified for parameter at " + configuration.getLocation());
            }
            String value = configuration.getAttribute("value", null);
            if (value != null) {
                list.add(new NameValuePair(name, value));
            }
            Configuration[] subconfigurations = configuration.getChildren("value");
            int y = 0;
            while (y < subconfigurations.length) {
                value = subconfigurations[y].getValue(null);
                if (value != null) {
                    list.add(new NameValuePair(name, value));
                }
                ++y;
            }
            ++x;
        }
        return list;
    }

    private ArrayList overrideParams(ArrayList list, String name, String value) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NameValuePair param = (NameValuePair)iterator.next();
            if (!param.getName().equals(name)) continue;
            iterator.remove();
            break;
        }
        list.add(new NameValuePair(name, value));
        return list;
    }
}

