/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.document;

import java.text.ParseException;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

import fr.gouv.culture.oai.OAIObject;
import fr.gouv.culture.oai.util.OAIUtilities;
import fr.gouv.culture.sdx.search.lucene.DateField;
import fr.gouv.culture.sdx.utils.Utilities;

/**
 * OAI document properties. Attach the haverst date and the OAI identifier of the document. 
 * @author mpichot
 */
public class OAIDocument extends XMLDocument implements OAIObject {

  private String dateString;
  private String identifier;
  public static final String INTERNAL_FIELD_NAME_SDXOAIDATE = "sdxoaidate";
  public static final String INTERNAL_FIELD_NAME_SDXOAIID = "sdxoaiid";


    public OAIDocument() {
        dateString = null;
        identifier = null;
    }

    /**
     * Attach system fields of the OAI document :
     * sdxoaidate : harvest date
     * sdxoaiid : OAI identifier 
     */
    public void addAdditionalSystemFields(Document doc) {
    	
    	//The date
    	if(Utilities.checkString(dateString)){
    		
    		java.util.Date myDate = null;
    		java.util.TimeZone gmtZone = java.util.TimeZone.getTimeZone("GMT");
    		
    		//Try seconds granularity "YYYY-DD-MMThh:mm:ssZ"
    		try{
    			java.text.SimpleDateFormat _sdf = new java.text.SimpleDateFormat(OAIObject.STRING_DATEFORMAT_GRANULARITY_SECOND);
    			_sdf.setTimeZone(gmtZone);
    			myDate = _sdf.parse(dateString);
    		} catch (ParseException e) {
    			
    			//Try day granularity "YYYY-DD-MM"
    			try{
    				java.text.SimpleDateFormat _sdf = new java.text.SimpleDateFormat(OAIObject.STRING_DATEFORMAT_GRANULARITY_DAY);
        			_sdf.setTimeZone(gmtZone);
    				myDate = _sdf.parse(dateString);
    			} catch (ParseException ee) {
    				ee.printStackTrace();
    			}
    			
    		}
    		
    		if(myDate!=null){
	    		long oaidate = myDate.getTime();
	    		Field dateField = Field.Keyword(OAIDocument.INTERNAL_FIELD_NAME_SDXOAIDATE, DateField.timeToString(oaidate));
	    		if(dateField != null) doc.add(dateField);
    		} else{
    			String message = "Impossible de parser la date " + dateString + " du document OAI " + identifier;
    			OAIUtilities.logError(_logger, message, null);
    		}
    	}
        
        //The identifier
        if(Utilities.checkString(identifier)){
            Field idField = Field.Keyword(OAIDocument.INTERNAL_FIELD_NAME_SDXOAIID, identifier);
            if(idField != null) doc.add(idField);
        }
    }

    public String getDateString()
    {
        return dateString;
    }

    public void setDateString(String dateString)
    {
        this.dateString = dateString;
    }

    public String getIdentifier()
    {
        return identifier;
    }

    public void setIdentifier(String identifier)
    {
        this.identifier = identifier;
    }

}
