/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/

package fr.gouv.culture.sdx.resolver.entity;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.exception.SDXExceptionCode;
import org.apache.cocoon.components.resolver.DefaultResolver;
//import org.apache.excalibur.xml.DefaultEntityResolver;

import java.io.IOException;
import java.net.URL;

/**A simple extension of Cocoon's ResolverImpl which facilitates the addition of
 * entity catlogs files based upon configuration data from our application.xconf files.
 * The current usage of this class in the code specifies that these catalogs will
 * only be added if and only if the cocoon.xconf is changed  to specify our this
 * resolver with the role set to the value of ROLE in
 * org.apache.avalon.excalibur.xml.EntityResolver from and we can acquire
 * this resolver from Cocoon's component manager based upon that role.
 */
public class SDXResolver extends DefaultResolver{

	public SDXResolver() {
		super();
	}

    /**Adds a Entity Catalog to the CatalogResolver
     *
     * <p>This catalog should be in one of the formats supported by
     * org.apache.xml.resolver.tools.CatalogResolver
     *
     * @param url   The url of the catalog to add
     * @throws SDXException
     */
    public void addCatalog(URL url) throws SDXException {
        try {
            super.catalogResolver.getCatalog().parseCatalog(url.toExternalForm());
        } catch (IOException e) {
            String[] args = new String[2];
            args[0] = url.toExternalForm();
            args[1] = e.getMessage();
            throw new SDXException(super.getLogger(), SDXExceptionCode.ERROR_ENTITY_CATALOG_ADD, args, e);
        }
    }

}
