/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/

package fr.gouv.culture.sdx.search.lucene.filter;

import org.apache.excalibur.xml.sax.XMLizable;
import org.apache.lucene.index.IndexReader;

import java.util.BitSet;

/*
 *	Interface pour les classes permettant de d�finir des filtres.
 *
 *	Essentiellement, cette interface d�finit une m�thode permettant
 *	de retourner un BitSet des documents admis en fonction de
 *	ce crit�re.
 */

/**Interface for the classes which define filters.
 *
 * Primarily, this interface defines a method making it
 * possible to turn over BitSet of the documents admitted
 * according to this criteria.
 *
 */
public interface FilterCriteria extends XMLizable {

    /**
     *	Applies the criteria and turns over the documents which satisfy it
     *
     *	@param	r		The reader of the index.
     */
    public BitSet bits(IndexReader r);

}

