/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.user;

/**
 * Represents a superuser, which is a user who can manage the SDX
 * server. This class extends overrides UserInformation by returning
 * true for the isAdmin() and isSuperuser() methods.
 */
public class SuperuserInformation extends UserInformation {
	/**
	 * Returns whether this user can admin an application.
	 *
	 * <p>For the superuser, it always returns <code>true</code>.
	 *
	 * @param   app     The application id.
	 */
	public boolean isAdmin(String app) {
		return true;
	}

	/**
	 * Returns whether this user is a superuser.
	 *
	 * <p>Always return <code>true</code>.
	 */
	public boolean isSuperuser() {
		return true;
	}

	/**
	 * Return whether this user is member of some groups.
	 *
	 * <p>Returns <code>false</code>.
	 * @param   groupnames      The list of groups.
	 * @param   all             If <code>true</code>, the user must be a member of each groups ; otherwise a member of at least one of them.
	 */
	public boolean isMember(String[] groupnames, boolean all) {
		return false;
	}

	/**
	 * Returns whether this user is a member of at least one of the groups. This method
	 * is a shortcut for isMember(groupnames, false).
	 *
	 * <p>Returns false.
	 *
	 * @param   groupnames      The list of group names.
	 */
	public boolean isMember(String[] groupnames) {
		return false;
	}

	/**
	 * Returns whether this user is a member of a group.
	 *
	 * <p>Returns <code>false</code>.
	 *
	 * @param   groupname       The name of the group.
	 */
	public boolean isMember(String groupname) {
		return false;
	}
}
