/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.datasource;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;

public class InformixDataSource
extends AbstractLogEnabled
implements DataSourceComponent {
    private DataSource m_dataSource;
    private boolean m_autocommit;
    private static boolean INIT_FACTORY = false;

    public InformixDataSource() {
        if (!INIT_FACTORY) {
            System.setProperty("java.naming.factory.initial", "org.codehaus.spice.jndikit.memory.MemoryInitialContextFactory");
        }
    }

    public Connection getConnection() throws SQLException {
        Connection conn = this.m_dataSource.getConnection();
        if (conn.getAutoCommit() != this.m_autocommit) {
            conn.setAutoCommit(this.m_autocommit);
        }
        return conn;
    }

    public void configure(Configuration conf) throws ConfigurationException {
        Configuration poolController = conf.getChild("pool-controller");
        String dbname = conf.getChild("dbname").getValue("ifx");
        ConnectionPoolDataSource pooledDataSource = (ConnectionPoolDataSource)this.getInstance("com.informix.jdbcx.IfxConnectionPoolDataSource");
        this.m_autocommit = conf.getChild("autocommit").getValueAsBoolean(true);
        this.setProperty(pooledDataSource, "IfxCPMInitPoolSize", new Integer(poolController.getAttributeAsInteger("init", 5)));
        this.setProperty(pooledDataSource, "IfxCPMMinPoolSize", new Integer(poolController.getAttributeAsInteger("min", 5)));
        this.setProperty(pooledDataSource, "IfxCPMMaxPoolSize", new Integer(poolController.getAttributeAsInteger("max", 10)));
        this.setProperty(pooledDataSource, "IfxCPMServiceInterval", new Long(100L));
        this.setProperty(pooledDataSource, "ServerName", conf.getChild("servername").getValue());
        this.setProperty(pooledDataSource, "DatabaseName", conf.getChild("dbname").getValue());
        this.setProperty(pooledDataSource, "IfxIFXHOST", conf.getChild("host").getValue());
        this.setProperty(pooledDataSource, "PortNumber", new Integer(conf.getChild("host").getAttributeAsInteger("port")));
        this.setProperty(pooledDataSource, "User", conf.getChild("user").getValue());
        this.setProperty(pooledDataSource, "Password", conf.getChild("password").getValue());
        try {
            InitialContext context = new InitialContext();
            context.bind(dbname + "pool", (Object)pooledDataSource);
            this.m_dataSource = (DataSource)this.getInstance("com.informix.jdbcx.IfxDataSource");
            this.setProperty(this.m_dataSource, "DataSourceName", dbname + "pool");
            this.setProperty(this.m_dataSource, "ServerName", conf.getChild("servername").getValue());
            this.setProperty(this.m_dataSource, "DatabaseName", conf.getChild("dbname").getValue());
            this.setProperty(this.m_dataSource, "IfxIFXHOST", conf.getChild("host").getValue());
            this.setProperty(this.m_dataSource, "PortNumber", new Integer(conf.getChild("host").getAttributeAsInteger("port")));
            this.setProperty(this.m_dataSource, "User", conf.getChild("user").getValue());
            this.setProperty(this.m_dataSource, "Password", conf.getChild("password").getValue());
            this.configureTracing(conf.getChild("tracing", false));
            context.bind(dbname, (Object)this.m_dataSource);
        }
        catch (Exception e) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("There was an error trying to bind the connection pool", (Throwable)e);
            }
            throw new ConfigurationException("There was an error trying to bind the connection pool", (Throwable)e);
        }
    }

    private void configureTracing(Configuration config) throws ConfigurationException {
        if (config != null) {
            Configuration child = config.getChild("jdbc", false);
            if (child != null) {
                this.setProperty(this.m_dataSource, "IfxTRACE", new Integer(child.getAttributeAsInteger("level")));
                this.setProperty(this.m_dataSource, "IfxTRACEFILE", child.getAttribute("file"));
            }
            if ((child = config.getChild("sqli", false)) != null) {
                this.setProperty(this.m_dataSource, "IfxPROTOCOLTRACE", new Integer(child.getAttributeAsInteger("level")));
                this.setProperty(this.m_dataSource, "IfxPROTOCOLTRACEFILE", child.getAttribute("file"));
            }
        }
    }

    private Object getInstance(String className) throws ConfigurationException {
        Object instance = null;
        try {
            instance = Thread.currentThread().getContextClassLoader().loadClass(className).newInstance();
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not load class", (Throwable)e);
        }
        return instance;
    }

    private void setProperty(Object obj, String propertyName, Object value) throws ConfigurationException {
        Class<Object> valueClass = value.getClass();
        if (value instanceof Integer) {
            valueClass = Integer.TYPE;
        } else if (value instanceof Long) {
            valueClass = Long.TYPE;
        }
        try {
            Method meth = obj.getClass().getMethod("set" + propertyName, valueClass);
            meth.invoke(obj, value);
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not set property", (Throwable)e);
        }
    }
}

