/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.jxpath.NodeSet;
import org.apache.commons.jxpath.Pointer;

public class BasicNodeSet
implements NodeSet {
    private List pointers = new ArrayList();
    private List readOnlyPointers;
    private List nodes;
    private List values;

    public void add(Pointer pointer) {
        this.pointers.add(pointer);
        this.readOnlyPointers = null;
    }

    public void remove(Pointer pointer) {
        this.pointers.remove(pointer);
        this.readOnlyPointers = null;
    }

    public List getPointers() {
        if (this.readOnlyPointers == null) {
            this.readOnlyPointers = Collections.unmodifiableList(this.pointers);
        }
        return this.readOnlyPointers;
    }

    public List getNodes() {
        if (this.nodes == null) {
            this.nodes = new ArrayList();
            for (int i = 0; i < this.pointers.size(); ++i) {
                Pointer pointer = (Pointer)this.pointers.get(i);
                this.nodes.add(pointer.getValue());
            }
            this.nodes = Collections.unmodifiableList(this.nodes);
        }
        return this.nodes;
    }

    public List getValues() {
        if (this.values == null) {
            this.values = new ArrayList();
            for (int i = 0; i < this.pointers.size(); ++i) {
                Pointer pointer = (Pointer)this.pointers.get(i);
                this.values.add(pointer.getValue());
            }
            this.values = Collections.unmodifiableList(this.values);
        }
        return this.values;
    }

    public String toString() {
        return this.pointers.toString();
    }
}

