/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements;

import java.io.IOException;
import java.util.Locale;
import org.apache.cocoon.components.elementprocessor.ElementProcessor;
import org.apache.cocoon.components.elementprocessor.LocaleAware;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.BaseElementProcessor;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.Cell;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.CellType;
import org.apache.cocoon.components.elementprocessor.types.Attribute;
import org.apache.cocoon.components.elementprocessor.types.NumericConverter;
import org.apache.cocoon.components.elementprocessor.types.NumericResult;
import org.apache.cocoon.components.elementprocessor.types.Validator;

public class EPCell
extends BaseElementProcessor
implements LocaleAware {
    private Cell _cell = null;
    private NumericResult _col = null;
    private NumericResult _row = null;
    private NumericResult _expr_id = null;
    private NumericResult _cols = null;
    private NumericResult _rows = null;
    private NumericResult _value_type = null;
    private String _value_format = null;
    private boolean _expr_id_fetched = false;
    private boolean _cols_fetched = false;
    private boolean _rows_fetched = false;
    private boolean _value_type_fetched = false;
    private boolean _value_format_fetched = false;
    private static final String _col_attribute = "Col";
    private static final String _row_attribute = "Row";
    private static final String _expr_id_attribute = "ExprID";
    private static final String _cols_attribute = "Cols";
    private static final String _rows_attribute = "Rows";
    private static final String _value_type_attribute = "ValueType";
    private static final String _value_format_attribute = "ValueFormat";
    private String locale;
    private static final Validator _cell_type_validator = new Validator(){

        public IOException validate(Number number) {
            return CellType.isValid(number.intValue()) ? null : new IOException("\"" + number + "\" is not a legal value");
        }
    };

    public EPCell() {
        super(null);
    }

    public int getColumn() throws IOException {
        if (this._col == null) {
            this._col = NumericConverter.extractNonNegativeInteger(this.getValue(_col_attribute));
        }
        return this._col.intValue();
    }

    public int getRow() throws IOException {
        if (this._row == null) {
            this._row = NumericConverter.extractNonNegativeInteger(this.getValue(_row_attribute));
        }
        return this._row.intValue();
    }

    public int getExpressionId() throws IOException, NullPointerException {
        if (!this._expr_id_fetched) {
            String valueString = this.getValue(_expr_id_attribute);
            if (valueString != null) {
                this._expr_id = NumericConverter.extractPositiveInteger(valueString);
            }
            this._expr_id_fetched = true;
        }
        return this._expr_id.intValue();
    }

    public int getColumns() throws IOException, NullPointerException {
        if (!this._cols_fetched) {
            String valueString = this.getValue(_cols_attribute);
            if (valueString != null) {
                this._cols = NumericConverter.extractPositiveInteger(valueString);
            }
            this._cols_fetched = true;
        }
        return this._cols.intValue();
    }

    public int getRows() throws IOException, NullPointerException {
        if (!this._rows_fetched) {
            String valueString = this.getValue(_rows_attribute);
            if (valueString != null) {
                this._rows = NumericConverter.extractPositiveInteger(valueString);
            }
            this._rows_fetched = true;
        }
        return this._rows.intValue();
    }

    public int getCellType() throws IOException, NullPointerException {
        if (!this._value_type_fetched) {
            String valueString = this.getValue(_value_type_attribute);
            if (valueString != null) {
                this._value_type = NumericConverter.extractInteger(valueString, _cell_type_validator);
            }
            this._value_type_fetched = true;
        }
        return this._value_type.intValue();
    }

    public String getFormat() throws IOException {
        if (!this._value_format_fetched) {
            this._value_format = this.getValue(_value_format_attribute);
            this._value_format_fetched = true;
        }
        return this._value_format;
    }

    public void initialize(Attribute[] attributes, ElementProcessor parent) throws IOException {
        super.initialize(attributes, parent);
        int cellType = -1;
        try {
            cellType = this.getCellType();
        }
        catch (NullPointerException ignored) {
            // empty catch block
        }
        this._cell = this.getSheet().getRow(this.getRow()).createCell(this.getColumn(), cellType);
    }

    public String getContent() {
        String content = this.getData();
        return content;
    }

    public void endProcessing() throws IOException {
        String content = this.getContent();
        if (content != null && this.locale != null) {
            this.getCell().setLocale(new Locale(this.locale, this.locale.toUpperCase()));
        }
        if (content != null && !content.trim().equals("")) {
            this.getCell().setContent(this.getContent());
        }
    }

    protected Cell getCell() {
        return this._cell;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }
}

