/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfElement;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfString;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfText;

class WhitespaceCollapser {
    private static final String SPACE = " ";
    private boolean lastEndSpace = true;

    WhitespaceCollapser(RtfContainer c) {
        Iterator it = c.getChildren().iterator();
        while (it.hasNext()) {
            RtfElement current;
            Object kid = it.next();
            if (kid instanceof RtfText) {
                current = (RtfText)kid;
                this.processText((RtfText)current);
                continue;
            }
            if (kid instanceof RtfString) {
                current = (RtfString)kid;
                this.processString((RtfString)current);
                continue;
            }
            this.lastEndSpace = true;
        }
    }

    private void processText(RtfText txt) {
        String newString = this.processString(txt.getText());
        if (newString != null) {
            txt.setText(newString);
        }
    }

    private void processString(RtfString txt) {
        String newString = this.processString(txt.getText());
        if (newString != null) {
            txt.setText(newString);
        }
    }

    private String processString(String txt) {
        String orig = txt;
        if (orig == null) {
            return null;
        }
        if (orig.length() > 0) {
            boolean allSpaces = orig.trim().length() == 0;
            boolean endSpace = allSpaces || Character.isWhitespace(orig.charAt(orig.length() - 1));
            boolean beginSpace = Character.isWhitespace(orig.charAt(0));
            StringBuffer sb = new StringBuffer(orig.length());
            if (allSpaces) {
                if (!this.lastEndSpace) {
                    sb.append(SPACE);
                }
            } else {
                boolean first = true;
                StringTokenizer stk = new StringTokenizer(txt, " \t\n\r");
                while (stk.hasMoreTokens()) {
                    if (first && beginSpace && !this.lastEndSpace) {
                        sb.append(SPACE);
                    }
                    first = false;
                    sb.append(stk.nextToken());
                    if (!stk.hasMoreTokens() && !endSpace) continue;
                    sb.append(SPACE);
                }
            }
            this.lastEndSpace = endSpace;
            return sb.toString();
        }
        return "";
    }
}

