/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.RangeIterator;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public class RangeExpression
extends BinaryExpression {
    public RangeExpression(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand0 = this.operand0.typeCheck(staticContext, itemType);
        this.operand1 = this.operand1.typeCheck(staticContext, itemType);
        RoleLocator roleLocator = new RoleLocator(1, "to", 0, null);
        roleLocator.setSourceLocator(this);
        this.operand0 = TypeChecker.staticTypeCheck(this.operand0, SequenceType.OPTIONAL_INTEGER, false, roleLocator, staticContext);
        RoleLocator roleLocator2 = new RoleLocator(1, "to", 1, null);
        roleLocator2.setSourceLocator(this);
        this.operand1 = TypeChecker.staticTypeCheck(this.operand1, SequenceType.OPTIONAL_INTEGER, false, roleLocator2, staticContext);
        return this.makeConstantRange();
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand0 = this.operand0.optimize(optimizer, staticContext, itemType);
        this.operand1 = this.operand1.optimize(optimizer, staticContext, itemType);
        return this.makeConstantRange();
    }

    private Expression makeConstantRange() {
        if (this.operand0 instanceof Literal && this.operand1 instanceof Literal) {
            Value value = ((Literal)this.operand0).getValue();
            Value value2 = ((Literal)this.operand1).getValue();
            if (value instanceof Int64Value && value2 instanceof Int64Value) {
                long l;
                long l2 = ((Int64Value)value).longValue();
                if (l2 > (l = ((Int64Value)value2).longValue())) {
                    return Literal.makeLiteral(EmptySequence.getInstance());
                }
                if (l2 == l) {
                    return Literal.makeLiteral(Int64Value.makeIntegerValue(l2));
                }
                return Literal.makeLiteral(new IntegerRange(l2, l));
            }
        }
        return this;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return BuiltInAtomicType.INTEGER;
    }

    public int computeCardinality() {
        return 57344;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.operand0.evaluateItem(xPathContext);
        if (atomicValue == null) {
            return new EmptyIterator();
        }
        NumericValue numericValue = (NumericValue)atomicValue;
        AtomicValue atomicValue2 = (AtomicValue)this.operand1.evaluateItem(xPathContext);
        if (atomicValue2 == null) {
            return new EmptyIterator();
        }
        NumericValue numericValue2 = (NumericValue)atomicValue2;
        if (numericValue.compareTo(numericValue2) > 0) {
            return new EmptyIterator();
        }
        return new RangeIterator(numericValue.longValue(), numericValue2.longValue());
    }
}

