/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Err;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.EscapeURI;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.GenericAtomicComparer;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public abstract class CollatingFunction
extends SystemFunction {
    protected StringCollator stringCollator = null;
    private URI expressionBaseURI = null;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        if (this.stringCollator == null) {
            this.saveBaseURI(staticContext, false);
            this.preEvaluateCollation(staticContext);
        }
        super.checkArguments(staticContext);
    }

    private void saveBaseURI(StaticContext staticContext, boolean bl) throws StaticError {
        block8: {
            if (this.expressionBaseURI == null) {
                String string = null;
                try {
                    string = staticContext.getBaseURI();
                    if (string == null) {
                        string = this.getCurrentDirectory();
                    }
                    if (string != null) {
                        this.expressionBaseURI = new URI(string);
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    Object object;
                    if (string != null) {
                        object = ((Object)EscapeURI.iriToUri(string)).toString();
                        try {
                            this.expressionBaseURI = new URI((String)object);
                        }
                        catch (URISyntaxException uRISyntaxException2) {
                            this.expressionBaseURI = null;
                        }
                    }
                    if (this.expressionBaseURI != null || !bl) break block8;
                    object = new StaticError("The base URI " + Err.wrap(staticContext.getBaseURI(), 7) + " is not a valid URI");
                    ((TransformerException)object).setLocator(this);
                    throw object;
                }
            }
        }
    }

    public URI getExpressionBaseURI() {
        return this.expressionBaseURI;
    }

    public StringCollator getStringCollator() {
        return this.stringCollator;
    }

    private String getCurrentDirectory() {
        String string;
        try {
            string = System.getProperty("user.dir");
        }
        catch (Exception exception) {
            return null;
        }
        if (!string.endsWith("/")) {
            string = string + '/';
        }
        try {
            URL uRL = new File(string).toURL();
            return uRL.toString();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private void preEvaluateCollation(StaticContext staticContext) throws XPathException {
        if (this.getNumberOfArguments() == this.getDetails().maxArguments) {
            Value value;
            Expression expression = this.argument[this.getNumberOfArguments() - 1];
            Value value2 = value = expression instanceof Literal ? ((Literal)expression).getValue() : null;
            if (value instanceof AtomicValue) {
                Serializable serializable;
                String string = value.getStringValue();
                try {
                    URI uRI = new URI(string);
                    if (!uRI.isAbsolute()) {
                        this.saveBaseURI(staticContext, true);
                        if (this.expressionBaseURI == null) {
                            StaticError staticError = new StaticError("The collation name is a relative URI, but the base URI is unknown");
                            staticError.setErrorCode("XPST0001");
                            staticError.setLocator(this);
                            throw staticError;
                        }
                        serializable = this.expressionBaseURI;
                        uRI = ((URI)serializable).resolve(uRI);
                        string = uRI.toString();
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    StaticError staticError = new StaticError("Collation name '" + string + "' is not a valid URI");
                    staticError.setErrorCode("FOCH0002");
                    staticError.setLocator(this);
                    throw staticError;
                }
                serializable = staticContext.getCollation(string);
                if (serializable == null) {
                    StaticError staticError = new StaticError("Unknown collation " + Err.wrap(string, 7));
                    staticError.setErrorCode("FOCH0002");
                    staticError.setLocator(this);
                    throw staticError;
                }
                this.stringCollator = serializable;
            }
        } else {
            String string = staticContext.getDefaultCollationName();
            this.stringCollator = staticContext.getCollation(string);
        }
    }

    protected GenericAtomicComparer getAtomicComparer(int n, XPathContext xPathContext) throws XPathException {
        return new GenericAtomicComparer(this.getCollator(n, xPathContext), xPathContext);
    }

    protected StringCollator getCollator(int n, XPathContext xPathContext) throws XPathException {
        if (this.stringCollator != null) {
            return this.stringCollator;
        }
        int n2 = this.argument.length;
        if (n2 > n) {
            AtomicValue atomicValue = (AtomicValue)this.argument[n].evaluateItem(xPathContext);
            StringValue stringValue = (StringValue)atomicValue;
            String string = stringValue.getStringValue();
            try {
                URI uRI = new URI(string);
                if (!uRI.isAbsolute()) {
                    if (this.expressionBaseURI == null) {
                        DynamicError dynamicError = new DynamicError("Cannot resolve relative collation URI '" + string + "': unknown or invalid base URI");
                        dynamicError.setErrorCode("FOCH0002");
                        dynamicError.setXPathContext(xPathContext);
                        dynamicError.setLocator(this);
                        throw dynamicError;
                    }
                    uRI = this.expressionBaseURI.resolve(uRI);
                    string = uRI.toString();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                DynamicError dynamicError = new DynamicError("Collation name '" + string + "' is not a valid URI");
                dynamicError.setErrorCode("FOCH0002");
                dynamicError.setXPathContext(xPathContext);
                dynamicError.setLocator(this);
                throw dynamicError;
            }
            return xPathContext.getCollation(string);
        }
        StringCollator stringCollator = xPathContext.getDefaultCollation();
        return stringCollator == null ? CodepointCollator.getInstance() : stringCollator;
    }
}

