/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class Substring
extends SystemFunction {
    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        if (atomicValue == null) {
            return StringValue.EMPTY_STRING;
        }
        StringValue stringValue = (StringValue)atomicValue;
        if (stringValue.isZeroLength()) {
            return StringValue.EMPTY_STRING;
        }
        AtomicValue atomicValue2 = (AtomicValue)this.argument[1].evaluateItem(xPathContext);
        NumericValue numericValue = (NumericValue)atomicValue2;
        if (this.argument.length == 2) {
            return StringValue.makeStringValue(Substring.substring(stringValue, numericValue));
        }
        AtomicValue atomicValue3 = (AtomicValue)this.argument[2].evaluateItem(xPathContext);
        NumericValue numericValue2 = (NumericValue)atomicValue3;
        return StringValue.makeStringValue(Substring.substring(stringValue, numericValue, numericValue2, xPathContext));
    }

    public static CharSequence substring(StringValue stringValue, NumericValue numericValue) {
        long l;
        CharSequence charSequence = stringValue.getStringValueCS();
        int n = charSequence.length();
        if (numericValue instanceof Int64Value) {
            l = ((Int64Value)numericValue).longValue();
            if (l > (long)n) {
                return "";
            }
            if (l <= 0L) {
                l = 1L;
            }
        } else {
            NumericValue numericValue2 = numericValue.round();
            if (numericValue2.isNaN()) {
                return "";
            }
            if (numericValue2.signum() <= 0.0) {
                return charSequence;
            }
            if (numericValue2.compareTo(n) > 0) {
                return "";
            }
            try {
                l = numericValue2.longValue();
            }
            catch (XPathException xPathException) {
                throw new AssertionError((Object)"string length out of permissible range");
            }
        }
        if (!stringValue.containsSurrogatePairs()) {
            return charSequence.subSequence((int)l - 1, charSequence.length());
        }
        int n2 = 1;
        int n3 = 0;
        while (n3 < n) {
            char c;
            if ((long)n2 >= l) {
                return charSequence.subSequence(n3, charSequence.length());
            }
            if ((c = charSequence.charAt(n3++)) >= '\ud800' && c <= '\udbff') continue;
            ++n2;
        }
        return "";
    }

    public static CharSequence substring(StringValue stringValue, NumericValue numericValue, NumericValue numericValue2, XPathContext xPathContext) {
        long l;
        NumericValue numericValue3;
        long l2;
        CharSequence charSequence = stringValue.getStringValueCS();
        int n = charSequence.length();
        if (numericValue instanceof Int64Value) {
            l2 = ((Int64Value)numericValue).longValue();
            if (l2 > (long)n) {
                return "";
            }
        } else {
            if ((numericValue = numericValue.round()).isNaN()) {
                return "";
            }
            if (numericValue.signum() <= 0.0) {
                l2 = 0L;
            } else {
                if (numericValue.compareTo(n) > 0) {
                    return "";
                }
                try {
                    l2 = numericValue.longValue();
                }
                catch (XPathException xPathException) {
                    throw new AssertionError((Object)"string length out of permissible range");
                }
            }
        }
        try {
            numericValue3 = numericValue.arithmetic(15, numericValue2.round(), xPathContext);
        }
        catch (XPathException xPathException) {
            throw new AssertionError((Object)"Unexpected arithmetic failure in substring");
        }
        if (numericValue3 instanceof Int64Value) {
            l = ((Int64Value)numericValue3).longValue();
        } else {
            if (numericValue3.isNaN()) {
                return "";
            }
            if (numericValue3.signum() <= 0.0) {
                return "";
            }
            if (numericValue3.compareTo(n) > 0) {
                l = n + 1;
            } else {
                try {
                    l = numericValue3.ceiling().longValue();
                }
                catch (XPathException xPathException) {
                    throw new AssertionError((Object)"string length out of permissible range");
                }
            }
        }
        if (l < l2) {
            return "";
        }
        if (!stringValue.containsSurrogatePairs()) {
            return charSequence.subSequence(Math.max((int)l2 - 1, 0), Math.min(n, (int)l - 1));
        }
        int n2 = -1;
        int n3 = -1;
        int n4 = 1;
        int n5 = 0;
        while (n5 < n) {
            char c;
            if ((long)n4 >= l2) {
                if ((long)n4 < l) {
                    if (n2 < 0) {
                        n2 = n5;
                    }
                } else {
                    n3 = n5;
                    break;
                }
            }
            if ((c = charSequence.charAt(n5++)) >= '\ud800' && c <= '\udbff') continue;
            ++n4;
        }
        if (n2 < 0 || n2 == n3) {
            return "";
        }
        if (n3 < 0) {
            return charSequence.subSequence(n2, charSequence.length());
        }
        return charSequence.subSequence(n2, n3);
    }
}

