/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.repository.impl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.repository.helpers.CredentialsToken;
import org.apache.cocoon.components.repository.helpers.RepositoryPropertyHelper;
import org.apache.cocoon.components.repository.impl.WebDAVRepository;
import org.apache.cocoon.components.source.helpers.SourceProperty;
import org.apache.cocoon.components.webdav.WebDAVUtil;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.httpclient.HttpException;
import org.w3c.dom.Node;

public class WebDAVRepositoryPropertyHelper
extends AbstractLogEnabled
implements RepositoryPropertyHelper,
Serviceable,
Disposable,
Component {
    private ServiceManager manager;
    private WebDAVRepository repo;
    private CredentialsToken credentials;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void dispose() {
        this.manager = null;
    }

    public WebDAVRepositoryPropertyHelper(CredentialsToken credentials, WebDAVRepository repo) {
        this.credentials = credentials;
        this.repo = repo;
    }

    public SourceProperty getProperty(String uri, String name, String namespace) {
        try {
            return WebDAVUtil.getProperty(this.repo.getAbsoluteURI(uri), name, namespace);
        }
        catch (HttpException he) {
            this.getLogger().error("HTTP Error getting property " + namespace + ":" + name + " for " + uri, (Throwable)he);
        }
        catch (IOException ioe) {
            this.getLogger().error("IO Error getting property " + namespace + ":" + name + " for " + uri, (Throwable)ioe);
        }
        return null;
    }

    public Map getProperties(String uri, Set propNames) {
        try {
            return WebDAVUtil.getProperties(this.repo.getAbsoluteURI(uri), propNames);
        }
        catch (HttpException he) {
            this.getLogger().error("HTTP Error getting properties for " + uri, (Throwable)he);
        }
        catch (IOException ioe) {
            this.getLogger().error("IO Error getting properties for " + uri, (Throwable)ioe);
        }
        return null;
    }

    public List getAllProperties(String uri) {
        try {
            return WebDAVUtil.getAllProperties(this.repo.getAbsoluteURI(uri));
        }
        catch (HttpException he) {
            this.getLogger().error("HTTP Error getting properties for " + uri, (Throwable)he);
        }
        catch (IOException ioe) {
            this.getLogger().error("IO Error getting properties for " + uri, (Throwable)ioe);
        }
        return null;
    }

    public boolean setProperty(String uri, String name, String namespace, String value) {
        try {
            WebDAVUtil.setProperty(this.repo.getAbsoluteURI(uri), name, namespace, value);
            return true;
        }
        catch (HttpException he) {
            this.getLogger().error("HTTP Error setting property " + namespace + ":" + name + " for " + uri, (Throwable)he);
        }
        catch (IOException ioe) {
            this.getLogger().error("IO Error setting property " + namespace + ":" + name + " for " + uri, (Throwable)ioe);
        }
        return false;
    }

    public boolean setProperty(String uri, String name, String namespace, Node value) {
        try {
            Properties format = new Properties();
            format.put("method", "xml");
            format.put("omit-xml-declaration", "yes");
            return this.setProperty(uri, name, namespace, XMLUtils.serializeNode((Node)value, (Properties)format));
        }
        catch (ProcessingException pe) {
            this.getLogger().error("Error serializing node " + value, (Throwable)pe);
            return false;
        }
    }

    public boolean setProperties(String uri, Map properties) {
        try {
            WebDAVUtil.setProperties(this.repo.getAbsoluteURI(uri), properties);
            return true;
        }
        catch (HttpException he) {
            this.getLogger().error("HTTP Error setting properties for " + uri, (Throwable)he);
        }
        catch (IOException ioe) {
            this.getLogger().error("IO Error setting properties for " + uri, (Throwable)ioe);
        }
        return false;
    }
}

