/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence.core;

import de.regnis.q.sequence.core.QSequenceDeePathExtenderArray;
import de.regnis.q.sequence.core.QSequenceException;
import de.regnis.q.sequence.core.QSequenceMedia;

abstract class QSequenceDeePathExtender {
    private final QSequenceDeePathExtenderArray xs;
    private int snakeStartLeft;
    private int snakeStartRight;

    protected abstract int getNextX(QSequenceDeePathExtenderArray var1, int var2, int var3);

    protected abstract int getSnakeX(QSequenceMedia var1, int var2, int var3) throws QSequenceException;

    protected abstract void reset(QSequenceMedia var1, QSequenceDeePathExtenderArray var2);

    public abstract int getProgress(int var1);

    protected QSequenceDeePathExtender(QSequenceDeePathExtenderArray xs) {
        this.xs = xs;
    }

    public final int getLeft(int diagonal) {
        return this.xs.get(diagonal);
    }

    public final int getRight(int diagonal) {
        return this.xs.get(diagonal) - diagonal;
    }

    public final int getSnakeStartLeft() {
        return this.snakeStartLeft;
    }

    public final int getSnakeStartRight() {
        return this.snakeStartRight;
    }

    public final void extendDeePath(QSequenceMedia media, int dee, int diagonal) throws QSequenceException {
        int x = this.getNextX(this.xs, diagonal, dee);
        int y = x - diagonal;
        this.snakeStartLeft = x;
        this.snakeStartRight = y;
        x = this.getSnakeX(media, x, y);
        y = x - diagonal;
        this.xs.set(diagonal, x);
    }

    public final void reset(QSequenceMedia media) {
        this.reset(media, this.xs);
    }

    public final void print(QSequenceMedia media, int fromDiagonal, int toDiagonal) {
        StringBuffer[] lines = new StringBuffer[media.getRightLength() + 1];
        for (int line = 0; line < lines.length; ++line) {
            lines[line] = new StringBuffer(media.getLeftLength() + 1);
            lines[line].append('.');
            for (int ch = 0; ch < media.getLeftLength(); ++ch) {
                lines[line].append((char)(line >= 1 && line <= media.getRightLength() ? 42 : 46));
            }
        }
        for (int diagonal = fromDiagonal; diagonal <= toDiagonal; ++diagonal) {
            int left = this.getLeft(diagonal);
            int right = this.getRight(diagonal);
            if (left < 0 || right < 0 || right >= lines.length || left >= lines[right].length()) continue;
            lines[right].setCharAt(left, String.valueOf(Math.abs(diagonal % 9)).charAt(0));
        }
    }
}

