/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.transformation;

import java.util.Locale;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.cocoon.forms.formmodel.ContainerWidget;
import org.apache.cocoon.forms.formmodel.Repeater;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.transformation.FormsPipelineConfig;
import org.apache.cocoon.i18n.I18nUtils;
import org.apache.cocoon.xml.AbstractXMLPipe;
import org.apache.cocoon.xml.SaxBuffer;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.jxpath.JXPathException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class WidgetReplacingPipe
extends AbstractXMLPipe {
    private static final String REPEATER_SIZE = "repeater-size";
    private static final String REPEATER_WIDGET_LABEL = "repeater-widget-label";
    private static final String WIDGET_LABEL = "widget-label";
    private static final String WIDGET = "widget";
    private static final String LOCATION = "location";
    private static final String REPEATER_WIDGET = "repeater-widget";
    private static final String CONTINUATION_ID = "continuation-id";
    private static final String FORM_TEMPLATE_EL = "form-template";
    private static final String STYLING_EL = "styling";
    protected Widget contextWidget;
    protected boolean inWidgetElement;
    protected SaxBuffer saxBuffer;
    protected int elementNestingCounter;
    protected int widgetElementNesting;
    protected Widget widget;
    protected boolean repeaterWidget;
    protected InsertStylingContentHandler stylingHandler = new InsertStylingContentHandler();
    protected FormsPipelineConfig pipeContext;
    protected boolean gotStylingElement;
    protected String namespacePrefix;

    public void init(Widget newContextWidget, FormsPipelineConfig newPipeContext) {
        this.contextWidget = newContextWidget;
        this.inWidgetElement = false;
        this.elementNestingCounter = 0;
        this.pipeContext = newPipeContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        ++this.elementNestingCounter;
        if (this.inWidgetElement) {
            if (this.elementNestingCounter == this.widgetElementNesting + 1 && "http://apache.org/cocoon/forms/1.0#instance".equals(namespaceURI) && STYLING_EL.equals(localName)) {
                this.gotStylingElement = true;
            }
            this.saxBuffer.startElement(namespaceURI, localName, qName, attributes);
            return;
        }
        if ("http://apache.org/cocoon/forms/1.0#template".equals(namespaceURI)) {
            if (localName.equals(WIDGET) || localName.equals(REPEATER_WIDGET)) {
                this.checkContextWidgetAvailable(qName);
                this.inWidgetElement = true;
                this.widgetElementNesting = this.elementNestingCounter;
                this.gotStylingElement = false;
                this.saxBuffer = new SaxBuffer();
                this.widget = this.getWidget(attributes);
                this.repeaterWidget = localName.equals(REPEATER_WIDGET);
                if (!this.repeaterWidget || this.widget instanceof Repeater) return;
                throw new SAXException("FormsTemplateTransformer: the element \"repeater-widget\" can only be used for repeater widgets.");
            }
            if (localName.equals(WIDGET_LABEL)) {
                this.checkContextWidgetAvailable(qName);
                Widget widget = this.getWidget(attributes);
                widget.generateLabel(this.contentHandler);
                return;
            }
            if (localName.equals(REPEATER_WIDGET_LABEL)) {
                this.checkContextWidgetAvailable(qName);
                Widget widget = this.getWidget(attributes);
                if (!(widget instanceof Repeater)) {
                    throw new SAXException("FormsTemplateTransformer: the element \"repeater-widget-label\" can only be used for repeater widgets.");
                }
                String widgetId = attributes.getValue("widget-id");
                if (widgetId == null || widgetId.equals("")) {
                    throw new SAXException("FormsTemplateTransformer: the element \"repeater-widget-label\" requires a \"widget-id\" attribute.");
                }
                ((Repeater)widget).generateWidgetLabel(widgetId, this.contentHandler);
                return;
            }
            if (localName.equals(REPEATER_SIZE)) {
                this.checkContextWidgetAvailable(qName);
                Widget widget = this.getWidget(attributes);
                if (!(widget instanceof Repeater)) {
                    throw new SAXException("FormsTemplateTransformer: the element \"repeater-size\" can only be used for repeater widgets.");
                }
                this.contentHandler.startPrefixMapping("fi", "http://apache.org/cocoon/forms/1.0#instance");
                ((Repeater)widget).generateSize(this.contentHandler);
                this.contentHandler.endPrefixMapping("fi");
                return;
            }
            if (localName.equals(FORM_TEMPLATE_EL)) {
                if (this.contextWidget != null) {
                    throw new SAXException("Detected nested ft:form-template elements, this is not allowed.");
                }
                this.contentHandler.startPrefixMapping("fi", "http://apache.org/cocoon/forms/1.0#instance");
                String formJXPath = attributes.getValue(LOCATION);
                if (formJXPath != null) {
                    AttributesImpl attrsCopy = new AttributesImpl(attributes);
                    attrsCopy.removeAttribute(attributes.getIndex(LOCATION));
                    attributes = attrsCopy;
                }
                this.contextWidget = this.pipeContext.findForm(formJXPath);
                String localeAttr = attributes.getValue("locale");
                if (localeAttr != null) {
                    localeAttr = this.pipeContext.translateText(localeAttr);
                    this.pipeContext.setLocale(I18nUtils.parseLocale((String)localeAttr));
                } else if (this.pipeContext.getLocaleParameter() != null) {
                    this.pipeContext.setLocale(this.pipeContext.getLocaleParameter());
                } else {
                    Object locale = null;
                    try {
                        locale = this.pipeContext.evaluateExpression("/locale");
                    }
                    catch (JXPathException e) {
                        // empty catch block
                    }
                    if (locale != null) {
                        this.pipeContext.setLocale((Locale)locale);
                    } else {
                        this.pipeContext.setLocale(Locale.getDefault());
                    }
                }
                String[] namesToTranslate = new String[]{"action"};
                Attributes transAtts = this.translateAttributes(attributes, namesToTranslate);
                this.contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", FORM_TEMPLATE_EL, "fi:form-template", transAtts);
                return;
            }
            if (!localName.equals(CONTINUATION_ID)) throw new SAXException("FormsTemplateTransformer: Unsupported element: " + localName);
            Object idObj = this.pipeContext.evaluateExpression("$continuation/id");
            if (idObj == null) {
                throw new SAXException("No continuation found");
            }
            String id = idObj.toString();
            this.contentHandler.startPrefixMapping("fi", "http://apache.org/cocoon/forms/1.0#instance");
            this.contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", CONTINUATION_ID, "fi:continuation-id", attributes);
            this.contentHandler.characters(id.toCharArray(), 0, id.length());
            this.contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", CONTINUATION_ID, "fi:continuation-id");
            this.contentHandler.endPrefixMapping("fi");
            return;
        }
        super.startElement(namespaceURI, localName, qName, attributes);
    }

    private void checkContextWidgetAvailable(String widgetElementName) throws SAXException {
        if (this.contextWidget == null) {
            throw new SAXException(widgetElementName + " cannot be used outside a wt:form-template element");
        }
    }

    private Attributes translateAttributes(Attributes attributes, String[] names) {
        AttributesImpl newAtts = new AttributesImpl(attributes);
        if (names != null) {
            int i = 0;
            while (i < names.length) {
                String name = names[i];
                int position = newAtts.getIndex(name);
                String newValue = this.pipeContext.translateText(newAtts.getValue(position));
                newAtts.setValue(position, newValue);
                ++i;
            }
        }
        return newAtts;
    }

    protected Widget getWidget(Attributes attributes) throws SAXException {
        String widgetId = attributes.getValue("id");
        if (widgetId == null || widgetId.equals("")) {
            throw new SAXException("FormsTemplateTransformer: missing id attribute on a Cocoon Forms element.");
        }
        Widget widget = ((ContainerWidget)this.contextWidget).getChild(widgetId);
        if (widget == null) {
            throw new SAXException("FormsTemplateTransformer: widget with id \"" + widgetId + "\" does not exist in the container " + this.contextWidget.getRequestParameterName());
        }
        return widget;
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.inWidgetElement) {
            if (this.elementNestingCounter == this.widgetElementNesting && "http://apache.org/cocoon/forms/1.0#template".equals(namespaceURI) && (localName.equals(WIDGET) || localName.equals(REPEATER_WIDGET))) {
                if (this.repeaterWidget) {
                    Repeater repeater = (Repeater)this.widget;
                    WidgetReplacingPipe rowPipe = new WidgetReplacingPipe();
                    int rowCount = repeater.getSize();
                    int i = 0;
                    while (i < rowCount) {
                        Repeater.RepeaterRow row = repeater.getRow(i);
                        rowPipe.init(row, this.pipeContext);
                        rowPipe.setContentHandler(this.contentHandler);
                        rowPipe.setLexicalHandler(this.lexicalHandler);
                        this.saxBuffer.toSAX((ContentHandler)((Object)rowPipe));
                        rowPipe.recycle();
                        ++i;
                    }
                } else {
                    this.stylingHandler.recycle();
                    this.stylingHandler.setSaxFragment(this.saxBuffer);
                    this.stylingHandler.setContentHandler(this.contentHandler);
                    this.stylingHandler.setLexicalHandler(this.lexicalHandler);
                    this.contentHandler.startPrefixMapping("fi", "http://apache.org/cocoon/forms/1.0#instance");
                    this.widget.generateSaxFragment((ContentHandler)((Object)this.stylingHandler), this.pipeContext.getLocale());
                    this.contentHandler.endPrefixMapping("fi");
                }
                this.inWidgetElement = false;
                this.widget = null;
            } else {
                this.saxBuffer.endElement(namespaceURI, localName, qName);
            }
        } else if ("http://apache.org/cocoon/forms/1.0#template".equals(namespaceURI)) {
            if (!(localName.equals(WIDGET_LABEL) || localName.equals(REPEATER_WIDGET_LABEL) || localName.equals(REPEATER_SIZE) || localName.equals(CONTINUATION_ID))) {
                if (localName.equals(FORM_TEMPLATE_EL)) {
                    this.contextWidget = null;
                    this.contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", FORM_TEMPLATE_EL, "fi:form-template");
                    this.contentHandler.endPrefixMapping("fi");
                } else {
                    super.endElement(namespaceURI, localName, qName);
                }
            }
        } else {
            super.endElement(namespaceURI, localName, qName);
        }
        --this.elementNestingCounter;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.inWidgetElement) {
            this.saxBuffer.startPrefixMapping(prefix, uri);
        } else {
            super.startPrefixMapping(prefix, uri);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.inWidgetElement) {
            this.saxBuffer.endPrefixMapping(prefix);
        } else {
            super.endPrefixMapping(prefix);
        }
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        if (this.inWidgetElement) {
            this.saxBuffer.characters(c, start, len);
        } else {
            super.characters(c, start, len);
        }
    }

    public void ignorableWhitespace(char[] c, int start, int len) throws SAXException {
        if (this.inWidgetElement) {
            this.saxBuffer.ignorableWhitespace(c, start, len);
        } else {
            super.ignorableWhitespace(c, start, len);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.inWidgetElement) {
            this.saxBuffer.processingInstruction(target, data);
        } else {
            super.processingInstruction(target, data);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        if (this.inWidgetElement) {
            this.saxBuffer.skippedEntity(name);
        } else {
            super.skippedEntity(name);
        }
    }

    public void startEntity(String name) throws SAXException {
        if (this.inWidgetElement) {
            this.saxBuffer.startEntity(name);
        } else {
            super.startEntity(name);
        }
    }

    public void endEntity(String name) throws SAXException {
        if (this.inWidgetElement) {
            this.saxBuffer.endEntity(name);
        } else {
            super.endEntity(name);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.inWidgetElement) {
            this.saxBuffer.startCDATA();
        } else {
            super.startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        if (this.inWidgetElement) {
            this.saxBuffer.endCDATA();
        } else {
            super.endCDATA();
        }
    }

    public void comment(char[] ch, int start, int len) throws SAXException {
        if (this.inWidgetElement) {
            this.saxBuffer.comment(ch, start, len);
        } else {
            super.comment(ch, start, len);
        }
    }

    public void recycle() {
        super.recycle();
        this.contextWidget = null;
        this.widget = null;
        this.namespacePrefix = null;
    }

    public class InsertStylingContentHandler
    extends AbstractXMLPipe
    implements Recyclable {
        private int elementNesting;
        private SaxBuffer saxBuffer;

        public void setSaxFragment(SaxBuffer saxFragment) {
            this.saxBuffer = saxFragment;
        }

        public void recycle() {
            super.recycle();
            this.elementNesting = 0;
            this.saxBuffer = null;
        }

        public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
            ++this.elementNesting;
            super.startElement(uri, loc, raw, a);
        }

        public void endElement(String uri, String loc, String raw) throws SAXException {
            --this.elementNesting;
            if (this.elementNesting == 0 && this.saxBuffer != null) {
                if (WidgetReplacingPipe.this.gotStylingElement) {
                    this.saxBuffer.toSAX(this.contentHandler);
                } else {
                    this.contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", WidgetReplacingPipe.STYLING_EL, "fi:styling", (Attributes)XMLUtils.EMPTY_ATTRIBUTES);
                    this.saxBuffer.toSAX(this.contentHandler);
                    this.contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", WidgetReplacingPipe.STYLING_EL, "fi:styling");
                }
            }
            super.endElement(uri, loc, raw);
        }
    }
}

