/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.util;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.cocoon.xml.SaxBuffer;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.apache.commons.lang.BooleanUtils;
import org.apache.excalibur.xml.sax.XMLizable;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;

public class DomHelper {
    public static String getLocation(Element element) {
        String location = null;
        if (element instanceof NodeImpl) {
            location = (String)((NodeImpl)element).getUserData("location");
        }
        if (location != null) {
            return location;
        }
        return "(location unknown)";
    }

    public static String getSystemIdLocation(Element element) {
        int start;
        int end;
        String loc = DomHelper.getLocation(element);
        if (loc.charAt(0) != '(' && (end = loc.lastIndexOf(58)) > 0 && (start = loc.lastIndexOf(58, end - 1)) >= 0) {
            return loc.substring(0, start);
        }
        return null;
    }

    public static int getLineLocation(Element element) {
        int start;
        int end;
        String loc = DomHelper.getLocation(element);
        if (loc.charAt(0) != '(' && (end = loc.lastIndexOf(58)) > 0 && (start = loc.lastIndexOf(58, end - 1)) >= 0) {
            return Integer.parseInt(loc.substring(start + 1, end));
        }
        return -1;
    }

    public static int getColumnLocation(Element element) {
        int end;
        String loc = DomHelper.getLocation(element);
        if (loc.charAt(0) != '(' && (end = loc.lastIndexOf(58)) > 0) {
            return Integer.parseInt(loc.substring(end));
        }
        return -1;
    }

    public static Element[] getChildElements(Element element, String namespace) {
        ArrayList<Node> elements = new ArrayList<Node>();
        NodeList nodeList = element.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node instanceof Element && namespace.equals(node.getNamespaceURI())) {
                elements.add(node);
            }
            ++i;
        }
        return elements.toArray(new Element[0]);
    }

    public static Element[] getChildElements(Element element, String namespace, String localName) {
        ArrayList<Node> elements = new ArrayList<Node>();
        NodeList nodeList = element.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node instanceof Element && namespace.equals(node.getNamespaceURI()) && localName.equals(node.getLocalName())) {
                elements.add(node);
            }
            ++i;
        }
        return elements.toArray(new Element[0]);
    }

    public static Element getChildElement(Element element, String namespace, String localName) {
        Element node = null;
        try {
            node = DomHelper.getChildElement(element, namespace, localName, false);
        }
        catch (Exception e) {
            node = null;
        }
        return node;
    }

    public static Element getChildElement(Element element, String namespace, String localName, boolean required) throws Exception {
        NodeList nodeList = element.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node instanceof Element && namespace.equals(node.getNamespaceURI()) && localName.equals(node.getLocalName())) {
                return (Element)node;
            }
            ++i;
        }
        if (required) {
            throw new Exception("Missing element \"" + localName + "\" as child of element \"" + element.getTagName() + "\" at " + DomHelper.getLocation(element));
        }
        return null;
    }

    public static String getAttribute(Element element, String attributeName) throws Exception {
        String attrValue = element.getAttribute(attributeName);
        if (attrValue.equals("")) {
            throw new Exception("Missing attribute \"" + attributeName + "\" on element \"" + element.getTagName() + "\" at " + DomHelper.getLocation(element));
        }
        return attrValue;
    }

    public static String getAttribute(Element element, String attributeName, String defaultValue) throws Exception {
        String attrValue = element.getAttribute(attributeName);
        if (attrValue.equals("")) {
            return defaultValue;
        }
        return attrValue;
    }

    public static int getAttributeAsInteger(Element element, String attributeName) throws Exception {
        String attrValue = DomHelper.getAttribute(element, attributeName);
        try {
            return Integer.parseInt(attrValue);
        }
        catch (NumberFormatException e) {
            throw new Exception("Cannot parse the value \"" + attrValue + "\" as an integer in the attribute \"" + attributeName + "\" on the element \"" + element.getTagName() + "\" at " + DomHelper.getLocation(element));
        }
    }

    public static int getAttributeAsInteger(Element element, String attributeName, int defaultValue) throws Exception {
        String attrValue = element.getAttribute(attributeName);
        if (attrValue.equals("")) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(attrValue);
        }
        catch (NumberFormatException e) {
            throw new Exception("Cannot parse the value \"" + attrValue + "\" as an integer in the attribute \"" + attributeName + "\" on the element \"" + element.getTagName() + "\" at " + DomHelper.getLocation(element));
        }
    }

    public static boolean getAttributeAsBoolean(Element element, String attributeName, boolean defaultValue) {
        Boolean result;
        String attrValue = element.getAttribute(attributeName);
        try {
            result = BooleanUtils.toBooleanObject((String)attrValue, (String)"true", (String)"false", null);
        }
        catch (IllegalArgumentException iae) {
            result = null;
        }
        if (result != null) {
            return result;
        }
        try {
            result = BooleanUtils.toBooleanObject((String)attrValue, (String)"yes", (String)"no", null);
        }
        catch (IllegalArgumentException iae) {
            result = null;
        }
        if (result != null) {
            return result;
        }
        return defaultValue;
    }

    public static String getElementText(Element element) {
        StringBuffer value = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node instanceof Text || node instanceof CDATASection) {
                value.append(node.getNodeValue());
            }
            ++i;
        }
        return value.toString();
    }

    public static XMLizable compileElementContent(Element element) {
        SaxBuffer saxBuffer = new SaxBuffer();
        DOMStreamer domStreamer = new DOMStreamer();
        domStreamer.setContentHandler((ContentHandler)saxBuffer);
        NodeList childNodes = element.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            try {
                domStreamer.stream(childNodes.item(i));
            }
            catch (SAXException e) {
                throw new RuntimeException("Error in DomHelper.compileElementContent: " + e.toString());
            }
            ++i;
        }
        return saxBuffer;
    }

    public static Document parse(InputSource inputSource) throws SAXException, SAXNotSupportedException, IOException {
        LocationTrackingDOMParser domParser = new LocationTrackingDOMParser();
        domParser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        domParser.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", false);
        domParser.parse(inputSource);
        return domParser.getDocument();
    }

    public static class LocationTrackingDOMParser
    extends DOMParser {
        XMLLocator locator;

        public void startDocument(XMLLocator xmlLocator, String s, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
            super.startDocument(xmlLocator, s, namespaceContext, augmentations);
            this.locator = xmlLocator;
            this.setLocation();
        }

        public void startElement(QName qName, XMLAttributes xmlAttributes, Augmentations augmentations) throws XNIException {
            super.startElement(qName, xmlAttributes, augmentations);
            this.setLocation();
        }

        private final void setLocation() {
            if (this.locator == null) {
                throw new RuntimeException("Error: locator is null. Check that you have the correct version of Xerces (such as the one that comes with Cocoon) in your endorsed library path.");
            }
            NodeImpl node = null;
            try {
                node = (NodeImpl)this.getProperty("http://apache.org/xml/properties/dom/current-element-node");
            }
            catch (SAXException ex) {
                System.err.println("except" + ex);
            }
            if (node != null) {
                String location = this.locator.getLiteralSystemId() + ":" + this.locator.getLineNumber() + ":" + this.locator.getColumnNumber();
                node.setUserData("location", (Object)location, null);
            }
        }
    }
}

