/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.bean;

import java.util.TreeMap;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.util.MIMEUtils;
import org.apache.cocoon.util.NetUtils;

public class Target {
    private static final String APPEND_TYPE = "append";
    private static final String REPLACE_TYPE = "replace";
    private static final String INSERT_TYPE = "insert";
    private final String type;
    private final String root;
    private final String sourceURI;
    private final String destURI;
    private final String deparameterizedSourceURI;
    private final TreeMap parameters;
    private String parentURI = null;
    private String originalURI = null;
    private String mimeType = null;
    private String defaultFilename = "index";
    private String finalDestinationURI = null;
    private String extension = null;
    private boolean followLinks;
    private boolean confirmExtension;
    private String logger;
    private transient int _hashCode;
    private transient String _toString;

    public Target(String type, String root, String sourceURI, String destURI) throws IllegalArgumentException {
        this.type = type;
        this.root = root;
        if (destURI == null || destURI.length() == 0) {
            throw new IllegalArgumentException("You must specify a destination directory when defining a target");
        }
        if (!destURI.endsWith("/")) {
            destURI = destURI + "/";
        }
        this.destURI = destURI;
        this.parameters = new TreeMap();
        sourceURI = NetUtils.normalize(root + sourceURI);
        this.deparameterizedSourceURI = NetUtils.deparameterize(sourceURI, this.parameters);
        this.sourceURI = NetUtils.parameterize(this.deparameterizedSourceURI, this.parameters);
    }

    public Target(String type, String sourceURI, String destURI) throws IllegalArgumentException {
        this(type, "", sourceURI, destURI);
    }

    public Target(String sourceURI, String destURI) throws IllegalArgumentException {
        this(APPEND_TYPE, "", sourceURI, destURI);
    }

    public Target getDerivedTarget(String originalLinkURI) throws IllegalArgumentException {
        String linkURI = originalLinkURI;
        if (linkURI.startsWith("?")) {
            linkURI = this.getPageURI() + linkURI;
        }
        if (!(linkURI = NetUtils.normalize(NetUtils.absolutize(this.getPath(), linkURI))).startsWith(this.root)) {
            return null;
        }
        linkURI = linkURI.substring(this.root.length());
        Target target = new Target(this.type, this.root, linkURI, this.destURI);
        target.setOriginalURI(originalLinkURI);
        target.setParentURI(this.sourceURI);
        target.setConfirmExtension(this.confirmExtension);
        target.setFollowLinks(this.followLinks);
        target.setDefaultFilename(this.defaultFilename);
        target.setLogger(this.logger);
        return target;
    }

    public void setOriginalURI(String uri) {
        this.originalURI = uri;
    }

    public void setParentURI(String uri) {
        this.parentURI = uri;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
        this.finalDestinationURI = null;
    }

    public void setExtraExtension(String extension) {
        this.extension = extension;
        this.finalDestinationURI = null;
    }

    public void setDefaultFilename(String filename) {
        this.defaultFilename = filename;
    }

    public String getPageURI() {
        String pageURI = this.getSourceURI();
        if (pageURI.indexOf("/") != -1 && (pageURI = pageURI.substring(pageURI.lastIndexOf("/") + 1)).length() == 0) {
            pageURI = "./";
        }
        return pageURI;
    }

    public String getPath() {
        return NetUtils.getPath(this.getSourceURI());
    }

    public String getExtension() {
        return NetUtils.getExtension(this.getSourceURI());
    }

    public String getParentURI() {
        return this.parentURI;
    }

    public String getDestinationURI() throws ProcessingException {
        if (this.finalDestinationURI == null) {
            String string;
            String destinationURI;
            String actualSourceURI = this.sourceURI;
            if (!actualSourceURI.startsWith(this.root)) {
                throw new ProcessingException("Derived target does not share same root: " + actualSourceURI);
            }
            actualSourceURI = actualSourceURI.substring(this.root.length());
            actualSourceURI = this.mangle(actualSourceURI);
            if (APPEND_TYPE.equals(this.type)) {
                destinationURI = this.destURI + actualSourceURI;
            } else if (REPLACE_TYPE.equals(this.type)) {
                destinationURI = this.destURI;
            } else if (INSERT_TYPE.equals(this.type)) {
                int starPos = this.destURI.indexOf("*");
                if (starPos == -1) {
                    throw new ProcessingException("Missing * in replace mapper uri");
                }
                destinationURI = starPos == this.destURI.length() - 1 ? this.destURI.substring(0, starPos) + actualSourceURI : this.destURI.substring(0, starPos) + actualSourceURI + this.destURI.substring(starPos + 1);
            } else {
                throw new ProcessingException("Unknown mapper type: " + this.type);
            }
            if (this.mimeType != null) {
                String ext = NetUtils.getExtension(destinationURI);
                String defaultExt = MIMEUtils.getDefaultExtension(this.mimeType);
                if (!(defaultExt == null || ext != null && ext.equals(defaultExt))) {
                    destinationURI = destinationURI + defaultExt;
                }
            }
            if (this.extension != null) {
                string = destinationURI + this.extension;
            }
            this.finalDestinationURI = string;
        }
        return this.finalDestinationURI;
    }

    public String getTranslatedURI(String path) throws ProcessingException {
        String actualSourceURI = this.sourceURI;
        if (!actualSourceURI.startsWith(this.root)) {
            return actualSourceURI;
        }
        actualSourceURI = this.mangle(actualSourceURI);
        if (this.mimeType != null) {
            String ext = NetUtils.getExtension(actualSourceURI);
            String defaultExt = MIMEUtils.getDefaultExtension(this.mimeType);
            if (!(defaultExt == null || ext != null && ext.equals(defaultExt))) {
                actualSourceURI = actualSourceURI + defaultExt;
            }
        }
        return NetUtils.relativize(path, actualSourceURI);
    }

    public String getAuthlessDestURI() throws ProcessingException {
        return NetUtils.removeAuthorisation(this.getDestinationURI());
    }

    public String getOriginalSourceURI() {
        return this.originalURI;
    }

    public String getSourceURI() {
        return this.sourceURI;
    }

    public String getDeparameterizedSourceURI() {
        return this.deparameterizedSourceURI;
    }

    public TreeMap getParameters() {
        return this.parameters;
    }

    private String mangle(String uri) {
        if (uri.length() == 0 || uri.charAt(uri.length() - 1) == '/') {
            uri = uri + this.defaultFilename;
        }
        uri = uri.replace('\"', '\'');
        uri = uri.replace('?', '_');
        uri = uri.replace(':', '_');
        return uri;
    }

    public boolean equals(Object o) {
        return o instanceof Target && o.toString().equals(this.toString());
    }

    public int hashCode() {
        if (this._hashCode == 0) {
            this._hashCode = this.toString().hashCode();
            return this._hashCode;
        }
        return this._hashCode;
    }

    public String toString() {
        if (this._toString == null) {
            this._toString = "<" + this.type + "|" + this.root + "|" + this.sourceURI + "|" + this.destURI + ">";
            return this._toString;
        }
        return this._toString;
    }

    public boolean confirmExtensions() {
        return this.confirmExtension;
    }

    public boolean followLinks() {
        return this.followLinks;
    }

    public String getLogger() {
        return this.logger;
    }

    public void setConfirmExtension(boolean b) {
        this.confirmExtension = b;
    }

    public void setFollowLinks(boolean b) {
        this.followLinks = b;
    }

    public void setLogger(String string) {
        this.logger = string;
    }
}

