/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.caching;

import java.io.Serializable;
import org.apache.excalibur.source.SourceValidity;

public class CachedResponse
implements Serializable {
    protected final SourceValidity[] validityObjects;
    protected final byte[] response;
    protected Long expires;
    protected final long lastModified;
    protected String contentType;

    public CachedResponse(SourceValidity[] validityObjects, byte[] response) {
        this(validityObjects, response, null);
    }

    public CachedResponse(SourceValidity validityObject, byte[] response) {
        this(new SourceValidity[]{validityObject}, response, null);
    }

    public CachedResponse(SourceValidity[] validityObjects, byte[] response, Long expires) {
        this.validityObjects = validityObjects;
        this.response = response;
        this.expires = expires;
        this.lastModified = this.setLastModified(System.currentTimeMillis());
    }

    public SourceValidity[] getValidityObjects() {
        return this.validityObjects;
    }

    public byte[] getResponse() {
        return this.response;
    }

    public Long getExpires() {
        return this.expires;
    }

    public void setExpires(Long newExpires) {
        this.expires = newExpires;
    }

    protected long setLastModified(long lastModified) {
        return lastModified - lastModified % 1000L;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String value) {
        this.contentType = value;
    }
}

