/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.xml;

import java.io.IOException;
import java.util.Collections;
import java.util.Stack;
import org.apache.avalon.framework.logger.Logger;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLBaseSupport {
    public static final String XMLBASE_NAMESPACE_URI = "http://www.w3.org/XML/1998/namespace";
    public static final String XMLBASE_ATTRIBUTE = "base";
    private int level = 0;
    private Stack bases = new Stack();
    private SourceResolver resolver;
    private Logger logger;

    public XMLBaseSupport(SourceResolver resolver, Logger logger) {
        this.resolver = resolver;
        this.logger = logger;
    }

    public void setDocumentLocation(String loc) throws SAXException {
        this.bases.push(new BaseInfo(loc, -2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
        ++this.level;
        String base = attrs.getValue(XMLBASE_NAMESPACE_URI, XMLBASE_ATTRIBUTE);
        if (base != null) {
            String baseUrl;
            block4: {
                Source baseSource = null;
                try {
                    baseSource = this.resolve(this.getCurrentBase(), base);
                    baseUrl = baseSource.getURI();
                    Object var9_8 = null;
                    if (baseSource == null) break block4;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    if (baseSource != null) {
                        this.resolver.release(baseSource);
                    }
                    throw throwable;
                }
                this.resolver.release(baseSource);
            }
            this.bases.push(new BaseInfo(baseUrl, this.level));
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        if (this.getCurrentBaseLevel() == this.level) {
            this.bases.pop();
        }
        --this.level;
    }

    private Source resolve(String baseURI, String location) throws SAXException {
        try {
            Source source = baseURI != null ? this.resolver.resolveURI(location, baseURI, Collections.EMPTY_MAP) : this.resolver.resolveURI(location);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("XMLBaseSupport: resolved location " + location + " against base URI " + baseURI + " to " + source.getURI());
            }
            return source;
        }
        catch (IOException e) {
            throw new SAXException("XMLBaseSupport: problem resolving uri.", e);
        }
    }

    public Source makeAbsolute(String spec) throws SAXException {
        return this.resolve(this.getCurrentBase(), spec);
    }

    private String getCurrentBase() {
        if (this.bases.size() > 0) {
            BaseInfo baseInfo = (BaseInfo)this.bases.peek();
            return baseInfo.getUrl();
        }
        return null;
    }

    private int getCurrentBaseLevel() {
        if (this.bases.size() > 0) {
            BaseInfo baseInfo = (BaseInfo)this.bases.peek();
            return baseInfo.getLevel();
        }
        return -1;
    }

    private static final class BaseInfo {
        private String url;
        private int level;

        public BaseInfo(String url, int level) {
            this.url = url;
            this.level = level;
        }

        public String getUrl() {
            return this.url;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

