/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager.http;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.excalibur.instrument.manager.DefaultInstrumentManager;
import org.apache.excalibur.instrument.manager.InstrumentDescriptor;
import org.apache.excalibur.instrument.manager.InstrumentSampleDescriptor;
import org.apache.excalibur.instrument.manager.InstrumentSampleSnapshot;
import org.apache.excalibur.instrument.manager.InstrumentableDescriptor;
import org.apache.excalibur.instrument.manager.http.AbstractHandler;

public abstract class AbstractXMLHandler
extends AbstractHandler {
    protected static final String INDENT = "  ";

    public AbstractXMLHandler(String path, DefaultInstrumentManager manager) {
        super(path, "text/xml", manager);
    }

    protected final String replaceToken(String str, String oldToken, String newToken) {
        int pos;
        int len = str.length();
        int oldLen = oldToken.length();
        if (oldLen == 0) {
            return str;
        }
        int newLen = newToken.length();
        int start = 0;
        while ((pos = str.indexOf(oldToken, start)) >= 0) {
            int leftLen = pos;
            String left = leftLen == 0 ? "" : str.substring(0, pos);
            int rightLen = len - pos - oldLen;
            String right = len - pos - oldLen <= 0 ? "" : str.substring(pos + oldLen);
            str = left + newToken + right;
            len = leftLen + newLen + rightLen;
            start = leftLen + newLen;
        }
        return str;
    }

    protected final String makeSafeAttribute(String attribute) {
        attribute = this.replaceToken(attribute, "&", "&amp;");
        attribute = this.replaceToken(attribute, "<", "&lt;");
        attribute = this.replaceToken(attribute, ">", "&gt;");
        attribute = this.replaceToken(attribute, "\"", "&quot;");
        return attribute;
    }

    protected void outputLine(PrintWriter out, String indent, boolean packed, String line) {
        if (!packed) {
            out.print(indent);
        }
        out.print(line);
        if (!packed) {
            out.println();
        }
    }

    protected void outputInstrumentManager(PrintWriter out, DefaultInstrumentManager manager, String indent, boolean recurse, boolean packed, boolean readOnly) throws IOException {
        this.outputLine(out, indent, packed, "<instrument-manager name=\"" + this.makeSafeAttribute(manager.getName()) + "\" " + "description=\"" + this.makeSafeAttribute(manager.getDescription()) + "\" " + "state-version=\"" + manager.getStateVersion() + "\" " + "batched-updates=\"true\" read-only=\"" + readOnly + "\">");
        String childIndent = indent + INDENT;
        InstrumentableDescriptor[] instrumentables = manager.getInstrumentableDescriptors();
        for (int i = 0; i < instrumentables.length; ++i) {
            InstrumentableDescriptor instrumentable = instrumentables[i];
            if (recurse) {
                this.outputInstrumentable(out, instrumentable, childIndent, recurse, packed);
                continue;
            }
            this.outputInstrumentableBrief(out, instrumentable, childIndent, packed);
        }
        this.outputLine(out, indent, packed, "</instrument-manager>");
    }

    protected void outputInstrumentableBrief(PrintWriter out, InstrumentableDescriptor instrumentable, String indent, boolean packed) throws IOException {
        this.outputLine(out, indent, packed, "<instrumentable name=\"" + this.makeSafeAttribute(instrumentable.getName()) + "\" " + "state-version=\"" + instrumentable.getStateVersion() + "\"/>");
    }

    protected void outputInstrumentable(PrintWriter out, InstrumentableDescriptor instrumentable, String indent, boolean recurse, boolean packed) throws IOException {
        InstrumentableDescriptor[] instrumentables = instrumentable.getChildInstrumentableDescriptors();
        InstrumentDescriptor[] instruments = instrumentable.getInstrumentDescriptors();
        String terminator = instrumentables.length > 0 || instruments.length > 0 ? ">" : "/>";
        this.outputLine(out, indent, packed, "<instrumentable name=\"" + this.makeSafeAttribute(instrumentable.getName()) + "\" " + "description=\"" + this.makeSafeAttribute(instrumentable.getDescription()) + "\" " + "state-version=\"" + instrumentable.getStateVersion() + "\" " + "registered=\"" + instrumentable.isRegistered() + "\" " + "configured=\"" + instrumentable.isConfigured() + "\"" + terminator);
        if (instrumentables.length > 0 || instruments.length > 0) {
            int i;
            String childIndent = indent + INDENT;
            for (i = 0; i < instrumentables.length; ++i) {
                InstrumentableDescriptor child = instrumentables[i];
                if (recurse) {
                    this.outputInstrumentable(out, child, childIndent, recurse, packed);
                    continue;
                }
                this.outputInstrumentableBrief(out, child, childIndent, packed);
            }
            for (i = 0; i < instruments.length; ++i) {
                InstrumentDescriptor instrument = instruments[i];
                if (recurse) {
                    this.outputInstrument(out, instrument, childIndent, recurse, packed);
                    continue;
                }
                this.outputInstrumentBrief(out, instrument, childIndent, packed);
            }
            this.outputLine(out, indent, packed, "</instrumentable>");
        }
    }

    protected void outputInstrumentBrief(PrintWriter out, InstrumentDescriptor instrument, String indent, boolean packed) throws IOException {
        this.outputLine(out, indent, packed, "<instrument name=\"" + this.makeSafeAttribute(instrument.getName()) + "\" " + "state-version=\"" + instrument.getStateVersion() + "\"/>");
    }

    protected void outputInstrument(PrintWriter out, InstrumentDescriptor instrument, String indent, boolean recurse, boolean packed) throws IOException {
        InstrumentSampleDescriptor[] samples = instrument.getInstrumentSampleDescriptors();
        String terminator = samples.length > 0 ? ">" : "/>";
        this.outputLine(out, indent, packed, "<instrument name=\"" + this.makeSafeAttribute(instrument.getName()) + "\" " + "description=\"" + this.makeSafeAttribute(instrument.getDescription()) + "\" " + "type=\"" + instrument.getType() + "\" " + "state-version=\"" + instrument.getStateVersion() + "\" " + "registered=\"" + instrument.isRegistered() + "\" " + "configured=\"" + instrument.isConfigured() + "\"" + terminator);
        if (samples.length > 0) {
            String childIndent = indent + INDENT;
            for (int i = 0; i < samples.length; ++i) {
                InstrumentSampleDescriptor sample = samples[i];
                if (recurse) {
                    this.outputSample(out, sample, childIndent, packed);
                    continue;
                }
                this.outputSampleBrief(out, sample, childIndent, packed);
            }
            this.outputLine(out, indent, packed, "</instrument>");
        }
    }

    protected void outputSampleBrief(PrintWriter out, InstrumentSampleDescriptor sample, String indent, boolean packed) throws IOException {
        this.outputLine(out, indent, packed, "<sample name=\"" + this.makeSafeAttribute(sample.getName()) + "\" " + "state-version=\"" + sample.getStateVersion() + "\"/>");
    }

    protected void outputSample(PrintWriter out, InstrumentSampleDescriptor sample, String indent, boolean packed) throws IOException {
        this.outputLine(out, indent, packed, "<sample name=\"" + this.makeSafeAttribute(sample.getName()) + "\" " + "description=\"" + this.makeSafeAttribute(sample.getDescription()) + "\" " + "type=\"" + sample.getType() + "\" " + "interval=\"" + sample.getInterval() + "\" " + "size=\"" + sample.getSize() + "\" " + "value=\"" + sample.getValue() + "\" " + "time=\"" + sample.getTime() + "\" " + "expiration-time=\"" + sample.getLeaseExpirationTime() + "\" " + "state-version=\"" + sample.getStateVersion() + "\" " + "configured=\"" + sample.isConfigured() + "\"/>");
    }

    protected void outputSampleHistory(PrintWriter out, InstrumentSampleDescriptor sample, String indent, long baseTime, boolean packed, boolean compact) throws IOException {
        int firstIndex;
        InstrumentSampleSnapshot snapshot = sample.getSnapshot();
        int[] values = snapshot.getSamples();
        long firstTime = snapshot.getTime() - (long)(snapshot.getSize() - 1) * snapshot.getInterval();
        if (baseTime <= firstTime) {
            firstIndex = 0;
        } else if (baseTime >= snapshot.getTime()) {
            firstTime = snapshot.getTime();
            firstIndex = values.length - 1;
        } else {
            int count = (int)Math.ceil(((double)snapshot.getTime() - (double)baseTime) / (double)snapshot.getInterval()) + 1;
            firstTime = snapshot.getTime() - (long)(count - 1) * snapshot.getInterval();
            firstIndex = values.length - count;
        }
        this.outputLine(out, indent, packed, "<sample name=\"" + this.makeSafeAttribute(sample.getName()) + "\" " + "description=\"" + this.makeSafeAttribute(sample.getDescription()) + "\" " + "type=\"" + sample.getType() + "\" " + "interval=\"" + snapshot.getInterval() + "\" " + "size=\"" + snapshot.getSize() + "\" " + "value=\"" + values[values.length - 1] + "\" " + "time=\"" + snapshot.getTime() + "\" " + "first-time=\"" + firstTime + "\" " + "count=\"" + (values.length - firstIndex) + "\" " + "expiration-time=\"" + sample.getLeaseExpirationTime() + "\" " + "state-version=\"" + snapshot.getStateVersion() + "\" " + "configured=\"" + sample.isConfigured() + "\">");
        String childIndent = indent + INDENT;
        if (compact) {
            StringBuffer sb = new StringBuffer();
            sb.append("<values>");
            for (int i = firstIndex; i < values.length; ++i) {
                if (i > firstIndex) {
                    sb.append(",");
                }
                sb.append(values[i]);
            }
            sb.append("</values>");
            this.outputLine(out, childIndent, packed, sb.toString());
        } else {
            long interval = snapshot.getInterval();
            long time = firstTime;
            for (int i = firstIndex; i < values.length; ++i) {
                this.outputLine(out, childIndent, packed, "<value time=\"" + time + "\" value=\"" + values[i] + "\"/>");
                time += interval;
            }
        }
        this.outputLine(out, indent, packed, "</sample>");
    }
}

