/*
 * Decompiled with CFR 0.152.
 */
package org.tempuri.javacImpl.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.tempuri.javac.JavaClassReader;
import org.tempuri.javac.JavaClassWriter;
import org.tempuri.javac.JavaSourceReader;
import org.tempuri.javac.util.FileSystemClassFactory;

public class FileSystemClassFactoryImpl
implements FileSystemClassFactory {
    HashMap jarCache = new HashMap();
    File[] bootClassPath;
    File[] classPath;
    File[] sourcePath;
    File outputDir;

    public String makeClassName(String fileName) throws IOException {
        File origFile = new File(fileName);
        String canonical = null;
        if (origFile.exists()) {
            canonical = origFile.getCanonicalPath().replace('\\', '/');
        }
        String str = fileName;
        str = str.replace('\\', '/');
        int i = 0;
        while (i < this.sourcePath.length) {
            String prefix = this.sourcePath[i].getCanonicalPath().replace('\\', '/');
            if (canonical != null) {
                if (canonical.startsWith(prefix)) {
                    String result = canonical.substring(prefix.length() + 1, canonical.length() - 5);
                    result = result.replace('/', '.');
                    return result;
                }
            } else {
                File t = new File(this.sourcePath[i], fileName);
                if (t.exists()) {
                    str = t.getCanonicalPath().replace('\\', '/');
                    String result = str.substring(prefix.length() + 1, str.length() - 5).replace('/', '.');
                    return result;
                }
            }
            ++i;
        }
        if (fileName.endsWith(".java")) {
            fileName = fileName.substring(0, fileName.length() - 5);
        }
        fileName = fileName.replace('\\', '.');
        return fileName.replace('/', '.');
    }

    public String makeFileName(String className) throws IOException {
        String str = className;
        str = str.replace('.', '/') + ".java";
        int i = 0;
        while (i < this.sourcePath.length) {
            File t = new File(this.sourcePath[i], str);
            if (t.exists()) {
                return t.getCanonicalPath();
            }
            ++i;
        }
        return str;
    }

    public JavaSourceReader getSourceReader(String className) throws IOException {
        String path = className.replace('.', '/') + ".java";
        int i = 0;
        while (i < this.sourcePath.length) {
            File file = this.sourcePath[i];
            if (file.isDirectory()) {
                File fullpath = new File(file, path);
                if (fullpath.exists()) {
                    return new SourceReaderImpl(className, fullpath);
                }
            } else if (file.exists()) {
                JarEntry entry;
                JarFile jar = (JarFile)this.jarCache.get(file);
                if (jar == null) {
                    jar = new JarFile(file);
                    this.jarCache.put(file, jar);
                }
                if ((entry = jar.getJarEntry(path)) != null) {
                    return new SourceReaderImpl(className, jar, entry);
                }
            }
            ++i;
        }
        return null;
    }

    public JavaClassReader getClassReader(String className) throws IOException {
        String path = className.replace('.', '/') + ".class";
        JavaClassReader result = this.getClassReader(className, path, this.bootClassPath);
        if (result != null) {
            return result;
        }
        result = this.getClassReader(className, path, this.classPath);
        return result;
    }

    private JavaClassReader getClassReader(String className, String path, File[] classPath) throws IOException {
        int i = 0;
        while (i < classPath.length) {
            File file = classPath[i];
            if (file.isDirectory()) {
                File fullpath = new File(file, path);
                if (fullpath.exists()) {
                    return new ClassReaderImpl(className, fullpath);
                }
            } else if (file.exists()) {
                String entryName;
                JarEntry entry;
                JarFile jar = (JarFile)this.jarCache.get(file);
                if (jar == null) {
                    jar = new JarFile(file);
                    this.jarCache.put(file, jar);
                }
                if ((entry = jar.getJarEntry(entryName = className.replace('.', '/') + ".class")) != null) {
                    return new ClassReaderImpl(className, jar, entry);
                }
            }
            ++i;
        }
        return null;
    }

    public JavaClassWriter getClassWriter(String className) throws IOException {
        String uri;
        if (this.outputDir != null) {
            String path = className.replace('.', '/') + ".class";
            File file = new File(this.outputDir, path);
            file.mkdirs();
            return new ClassWriterImpl(className, file);
        }
        SourceReaderImpl sourceReader = (SourceReaderImpl)this.getSourceReader(className);
        if (sourceReader != null && (uri = sourceReader.getURI()).startsWith("file:") && uri.endsWith(".java")) {
            String fileName = uri.substring(5, uri.length() - 5) + ".class";
            return new ClassWriterImpl(className, new File(fileName));
        }
        String path = className.replace('.', '/') + ".class";
        File file = new File(path);
        file.mkdirs();
        return new ClassWriterImpl(className, file);
    }

    public void setBootClassPath(String bcp) {
        this.bootClassPath = this.parsePath(bcp);
    }

    public void setClassPath(String cp) {
        this.classPath = this.parsePath(cp);
    }

    public void setSourcePath(String sp) {
        this.sourcePath = this.parsePath(sp);
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = new File(outputDir);
    }

    private File[] parsePath(String p) {
        StringTokenizer izer = new StringTokenizer(p, File.pathSeparator);
        int count = izer.countTokens();
        File[] result = new File[count];
        int i = 0;
        while (izer.hasMoreTokens()) {
            result[i++] = new File(izer.nextToken());
        }
        return result;
    }

    public static class ClassWriterImpl
    implements JavaClassWriter {
        String className;
        File file;

        ClassWriterImpl(String className, File file) {
            this.className = className;
            this.file = file;
        }

        public String getClassName() {
            return this.className;
        }

        /*
         * WARNING - void declaration
         */
        public void writeClass(InputStream inputStream) throws IOException {
            int count;
            if (this.file.exists()) {
                this.file.delete();
            }
            BufferedOutputStream b = new BufferedOutputStream(new FileOutputStream(this.file));
            byte[] buf = new byte[8192];
            while ((count = inputStream.read(buf, 0, buf.length)) > 0) {
                void var4_4;
                b.write(buf, 0, (int)var4_4);
            }
            b.close();
        }

        public String getURI() {
            return "file:" + this.file.getAbsolutePath().replace('\\', '/');
        }
    }

    public static class ClassReaderImpl
    implements JavaClassReader {
        String className;
        InputStream inputStream;
        File file;
        JarFile jarFile;
        JarEntry jarEntry;

        public ClassReaderImpl(String className, File file) throws IOException {
            this.className = className;
            this.file = file;
        }

        public ClassReaderImpl(String className, JarFile jarFile, JarEntry jarEntry) throws IOException {
            this.className = className;
            this.jarFile = jarFile;
            this.jarEntry = jarEntry;
        }

        public String getClassName() {
            return this.className;
        }

        public InputStream getInputStream() throws IOException {
            if (this.inputStream == null) {
                this.inputStream = this.file != null ? new FileInputStream(this.file) : this.jarFile.getInputStream(this.jarEntry);
                this.inputStream = new BufferedInputStream(this.inputStream);
            }
            return this.inputStream;
        }

        public String getURI() {
            return this.file != null ? "file:" + this.file.getAbsolutePath().replace('\\', '/') : "jar:file:" + this.jarFile.getName() + "!/" + this.jarEntry.getName();
        }

        public String toString() {
            return this.getURI();
        }
    }

    public static class SourceReaderImpl
    implements JavaSourceReader {
        String className;
        Reader reader;
        File file;
        JarFile jarFile;
        JarEntry jarEntry;

        public SourceReaderImpl(String className, File file) throws IOException {
            this.className = className;
            this.file = file;
        }

        public SourceReaderImpl(String className, JarFile jarFile, JarEntry jarEntry) throws IOException {
            this.className = className;
            this.jarFile = jarFile;
            this.jarEntry = jarEntry;
        }

        public String getClassName() {
            return this.className;
        }

        public Reader getReader() throws IOException {
            if (this.reader == null) {
                InputStream is = this.file != null ? new FileInputStream(this.file) : this.jarFile.getInputStream(this.jarEntry);
                this.reader = new InputStreamReader(is);
            }
            return this.reader;
        }

        public String getURI() {
            return this.file != null ? "file:" + this.file.getAbsolutePath().replace('\\', '.') : "jar:file:" + this.jarFile.getName() + "!/" + this.jarEntry.getName();
        }
    }
}

