/*
 * Decompiled with CFR 0.152.
 */
package net.sf.pizzacompiler.compiler;

import net.sf.pizzacompiler.compiler.Constants;
import net.sf.pizzacompiler.compiler.Switches;
import net.sf.pizzacompiler.compiler.VarSymbol;

class Code
implements Constants {
    boolean fatcode;
    int max_stack = 0;
    int max_locals = 0;
    byte[] code = new byte[64];
    int cp = 0;
    char[] exc_start_pc = new char[4];
    char[] exc_end_pc = new char[4];
    char[] exc_handler_pc = new char[4];
    char[] exc_catch_type = new char[4];
    int ncatches = 0;
    char[] line_start_pc = new char[32];
    char[] line_number = new char[32];
    int nlines = 0;
    char[] lvar_start_pc = new char[4];
    char[] lvar_length = new char[4];
    char[] lvar_reg = new char[4];
    VarSymbol[] lvar = new VarSymbol[4];
    int nvars = 0;

    Code(boolean bl) {
        this.fatcode = bl;
    }

    void addCode(int n) {
        if (this.cp == this.code.length) {
            byte[] byArray = new byte[this.cp * 2];
            System.arraycopy(this.code, 0, byArray, 0, this.cp);
            this.code = byArray;
        }
        this.code[this.cp++] = (byte)n;
    }

    void addCatch(int n, int n2, int n3, int n4) {
        if (this.ncatches == this.exc_start_pc.length) {
            char[] cArray = new char[this.ncatches * 2];
            char[] cArray2 = new char[this.ncatches * 2];
            char[] cArray3 = new char[this.ncatches * 2];
            char[] cArray4 = new char[this.ncatches * 2];
            for (int i = 0; i < this.ncatches; ++i) {
                cArray[i] = this.exc_start_pc[i];
                cArray2[i] = this.exc_end_pc[i];
                cArray3[i] = this.exc_handler_pc[i];
                cArray4[i] = this.exc_catch_type[i];
            }
            this.exc_start_pc = cArray;
            this.exc_end_pc = cArray2;
            this.exc_handler_pc = cArray3;
            this.exc_catch_type = cArray4;
        }
        this.exc_start_pc[this.ncatches] = (char)n;
        this.exc_end_pc[this.ncatches] = (char)n2;
        this.exc_handler_pc[this.ncatches] = (char)n3;
        this.exc_catch_type[this.ncatches] = (char)n4;
        ++this.ncatches;
    }

    void addLineNumber(int n, int n2) {
        if (this.nlines > 0 && this.line_start_pc[this.nlines - 1] == n) {
            --this.nlines;
        }
        if (this.nlines == this.line_start_pc.length) {
            char[] cArray = new char[this.nlines * 2];
            char[] cArray2 = new char[this.nlines * 2];
            for (int i = 0; i < this.nlines; ++i) {
                cArray[i] = this.line_start_pc[i];
                cArray2[i] = this.line_number[i];
            }
            this.line_start_pc = cArray;
            this.line_number = cArray2;
        }
        this.line_start_pc[this.nlines] = (char)n;
        this.line_number[this.nlines] = (char)n2;
        ++this.nlines;
    }

    void addLocalVar(int n, VarSymbol varSymbol) {
        if (Switches.debugInfo) {
            while (varSymbol.adr >= this.lvar.length) {
                char[] cArray = new char[this.lvar.length * 2];
                char[] cArray2 = new char[this.lvar.length * 2];
                char[] cArray3 = new char[this.lvar.length * 2];
                VarSymbol[] varSymbolArray = new VarSymbol[this.lvar.length * 2];
                for (int i = 0; i < this.lvar.length; ++i) {
                    cArray[i] = this.lvar_start_pc[i];
                    cArray2[i] = this.lvar_length[i];
                    cArray3[i] = this.lvar_reg[i];
                    varSymbolArray[i] = this.lvar[i];
                }
                this.lvar_start_pc = cArray;
                this.lvar_length = cArray2;
                this.lvar_reg = cArray3;
                this.lvar = varSymbolArray;
            }
            this.lvar_start_pc[varSymbol.adr] = 65535;
            this.lvar_length[varSymbol.adr] = 65535;
            this.lvar_reg[varSymbol.adr] = (char)n;
            this.lvar[varSymbol.adr] = varSymbol;
            ++this.nvars;
        }
    }

    void setStartPc(int n) {
        if (Switches.debugInfo && this.cp < 65535 && n < this.lvar_start_pc.length && this.lvar_start_pc[n] == '\uffff') {
            this.lvar_start_pc[n] = (char)this.cp;
        }
    }

    void setEndPc(int n) {
        if (Switches.debugInfo && n < this.lvar_start_pc.length && this.lvar_start_pc[n] != '\uffff' && this.cp - this.lvar_start_pc[n] < 65535 && this.lvar_length[n] == '\uffff') {
            this.lvar_length[n] = (char)(this.cp - this.lvar_start_pc[n]);
        }
    }
}

