/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.AbstractStreamSource;
import org.apache.cocoon.environment.WriteableSource;
import org.apache.cocoon.serialization.Serializer;
import org.apache.cocoon.xml.AbstractXMLPipe;
import org.apache.cocoon.xml.XMLConsumer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractStreamWriteableSource
extends AbstractStreamSource
implements WriteableSource {
    protected AbstractStreamWriteableSource(ComponentManager manager) {
        super(manager);
    }

    public boolean canCancel(ContentHandler handler) {
        WritingPipe pipe;
        if (handler instanceof WritingPipe && (pipe = (WritingPipe)((Object)handler)).getSource() == this) {
            return pipe.canCancel();
        }
        throw new IllegalArgumentException("The handler is not associated to this source");
    }

    public boolean canCancel(OutputStream stream) {
        return false;
    }

    public void cancel(ContentHandler handler) throws Exception {
        WritingPipe pipe;
        if (handler instanceof WritingPipe && (pipe = (WritingPipe)((Object)handler)).getSource() == this) {
            pipe.cancel();
            return;
        }
        throw new IllegalArgumentException("The handler is not associated to this source");
    }

    public void cancel(OutputStream stream) throws Exception {
        throw new UnsupportedOperationException("Cancel is not implemented on " + this.getClass().getName());
    }

    public ContentHandler getContentHandler() throws SAXException, ProcessingException {
        Serializer serializer;
        ComponentSelector selector;
        String serializerName = this.isHTMLContent() ? "html" : "xml";
        try {
            selector = (ComponentSelector)this.manager.lookup(Serializer.ROLE + "Selector");
            serializer = (Serializer)selector.select((Object)serializerName);
        }
        catch (ComponentException ce) {
            throw new ProcessingException("Cannot get '" + serializerName + "' serializer");
        }
        try {
            return new WritingPipe(this.getOutputStream(), selector, serializer);
        }
        catch (IOException ioe) {
            selector.release((Component)serializer);
            throw new ProcessingException("Cannot open stream for " + this.getSystemId(), (Throwable)ioe);
        }
    }

    private class WritingPipe
    extends AbstractXMLPipe {
        private OutputStream output;
        private Serializer serializer;
        private ComponentSelector selector;

        public WritingPipe(OutputStream output, ComponentSelector selector, Serializer serializer) throws IOException {
            this.output = output;
            this.selector = selector;
            this.serializer = serializer;
            this.setConsumer((XMLConsumer)this.serializer);
            this.serializer.setOutputStream(this.output);
        }

        public WriteableSource getSource() {
            return AbstractStreamWriteableSource.this;
        }

        public void endDocument() throws SAXException {
            super.endDocument();
            try {
                this.close();
            }
            catch (Exception e) {
                throw new SAXException("Error while closing output stream", e);
            }
        }

        public boolean canCancel() {
            return this.output != null;
        }

        public void cancel() throws Exception {
            AbstractStreamWriteableSource.this.cancel(this.output);
            this.close();
        }

        private void close() throws IOException {
            if (this.serializer != null) {
                this.recycle();
                this.selector.release((Component)this.serializer);
                this.serializer = null;
            }
            if (this.output != null) {
                this.output.close();
                this.output = null;
            }
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }
}

