/*
SDX: Documentary System in XML.
Copyright (C) 2000  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
 */
package fr.gouv.culture.sdx.search.lucene.query;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.TermQuery;

/**
* SDXTermQuery extends org.apache.lucene.search.TermQuery. Here, we just want to re-write the method toString(String) to get a @luceneQuery suitable for SimpleQuery ; the query term is escaped by pipes "|", recognized by the QueryParser to escape the word analyzer.
* SDXTermQuery is used by fr.gouv.culture.sdx.search.lucene.query.FieldQuery.
*@see org.apache.lucene.search.RangeQuery
*@see fr.gouv.culture.sdx.search.lucene.query.FieldQuery
*/
public class SDXTermQuery extends TermQuery {

	private Term sdxterm = super.getTerm();
	
	/**
	 * Construct a org.apache.lucene.index.Term*/
	public SDXTermQuery(Term t) {
		super(t);
	}
	
	/** Prints a user-readable version of this query.
	 * Here, we want to encapsulate the query term by pipes "|". */
	public String toString(String field) {
		StringBuffer buffer = new StringBuffer();
		if (!sdxterm.field().equals(field)) {
			buffer.append(sdxterm.field());
			buffer.append(":");
		}
		buffer.append("|" + sdxterm.text() + "|");
		if (getBoost() != 1.0f) {
			buffer.append("^");
			buffer.append(Float.toString(getBoost()));
		}
		return buffer.toString();
	}
	
}